


mgettydefs(4)         mgetty_sendfax manual         mgettydefs(4)


NNAAMMEE
       mgettydefs - speed and terminal settings used by mgetty

DDEESSCCRRIIPPTTIIOONN
       The  //eettcc//ggeettttyyddeeffss  file  contains  information  used  by
       _m_g_e_t_t_y(1) to set up the speed and terminal settings for  a
       line.   It  also  supplies  information  on what the _l_o_g_i_n
       prompt should look like.

       Many versions of UNIX have a version of _g_e_t_t_y(1) that also
       reads  //eettcc//ggeettttyyddeeffss.  Both _m_g_e_t_t_y and _g_e_t_t_y expect simi-
       lar formats in //eettcc//ggeettttyyddeeffss except that,  when  used  by
       _m_g_e_t_t_y, extended functionality is available.  Even so, the
       additional functions are simply ignored by standard _g_e_t_t_y,
       so  they can co-exist using the same file.  Note, however,
       that _m_g_e_t_t_y can be compiled to use a file  different  from
       //eettcc//ggeettttyyddeeffss  if  your _g_e_t_t_y gets upset about the exten-
       sions.  This  manual  page  documents  //eettcc//ggeettttyyddeeffss  and
       describes  the  extended functionality available when used
       by _m_g_e_t_t_y(1).  This document will refer to _g_e_t_t_y(1) except
       where _m_g_e_t_t_y's behaviour is different.

       Each entry in //eettcc//ggeettttyyddeeffss has the following format:

              label#  initial-flags  # final-flags # login-prompt
              #next-label

       Each entry is followed by a blank line.  The login  prompt
       field  can  contain  quoted  characters which will be con-
       verted to other values.  The sequences and their substitu-
       tions are:

       \\nn             newline

       \\rr             carriage return

       \\gg             beep

       \\bb             backspace

       \\vv             vertical tab (VT)

       \\ff             formfeed

       \\tt             tab

       \\LL             portname

       \\CC             time in _c_t_i_m_e(3) format.

       \\NN             number of users currently logged in

       \\UU             number of users currently logged in




greenie                      4 Dec 93                           1





mgettydefs(4)         mgetty_sendfax manual         mgettydefs(4)


       \\DD             date in DD/MM format

       \\TT             time in hh:mm:ss format

       \\II             modem CONNECT attributes

       \\sseeqquueennccee      where  "sequence" is a valid strtol format,
                      such as: \0nnn (octal),  \0xnnn  (hex),  or
                      \nnn (decimal).

       Note  that standard _g_e_t_t_y usually only supports \b, \r and
       \n.

       The various fields are:

       _l_a_b_e_l          This is  the  string  against  which  _g_e_t_t_y
                      tries  to match its second argument.  It is
                      often the speed, such as 11220000, at which the
                      terminal  is  supposed  to run, but it need
                      not be (see below).

       _i_n_i_t_i_a_l_-_f_l_a_g_s  These flags are the initial  _i_o_c_t_l(2)  set-
                      tings to which the terminal is to be set if
                      a terminal type is not specified to  _g_e_t_t_y.
                      The  flags  that  _g_e_t_t_y understands are the
                      ones listed in _t_e_r_m_i_o(7)).  _m_g_e_t_t_y is  usu-
                      ally  compiled for _t_e_r_m_i_o_s(7) and often has
                      a more complete set than _g_e_t_t_y.

       Normally only the speed flag is required in the
                      _i_n_i_t_i_a_l_-_f_l_a_g_s.   _g_e_t_t_y  automatically  sets
                      the  terminal  to  raw input mode and takes
                      care of  the  other  flags.   If  the  "-s"
                      option  is  used  with  _m_g_e_t_t_y(1) the speed
                      setting is ignored.  The _i_n_i_t_i_a_l_-_f_l_a_g  set-
                      tings remain in effect until _g_e_t_t_y executes
                      _l_o_g_i_n(1).

       _f_i_n_a_l_-_f_l_a_g_s    These flags take the  same  values  as  the
                      _i_n_i_t_i_a_l_-_f_l_a_g_s and are set just before _g_e_t_t_y
                      executes _l_o_g_i_n.  The speed  flag  is  again
                      required, except with _m_g_e_t_t_y if the -s flag
                      was supplied.  Two other commonly specified
                      _f_i_n_a_l_-_f_l_a_g_s are TTAABB33, so that tabs are sent
                      to the terminal as spaces,  and  HHUUPPCCLL,  so
                      that  the  line  is  hung  up  on the final
                      close.

       _l_o_g_i_n_-_p_r_o_m_p_t   This entire field is printed as the  _l_o_g_i_n_-
                      _p_r_o_m_p_t.   Unlike  the  above  fields  where
                      white space (a space, tab or  new-line)  is
                      ignored,  they  are  included in the _l_o_g_i_n_-
                      _p_r_o_m_p_t field.  This field is ignored if the
                      "-p"   option   has   been   specified   to



greenie                      4 Dec 93                           2





mgettydefs(4)         mgetty_sendfax manual         mgettydefs(4)


                      _m_g_e_t_t_y(1).

       _n_e_x_t_-_l_a_b_e_l     specifies the label to use if the user user
                      types a _<_b_r_e_a_k_> character, or _g_e_t_t_y detects
                      a reception error.  _G_e_t_t_y searches for  the
                      entry  with  _n_e_x_t_-_l_a_b_e_l  as its _l_a_b_e_l field
                      and set up the terminal for those settings.
                      Usually,  a  series  of  speeds  are linked
                      together in this  fashion,  into  a  closed
                      set;  for  instance,  22440000  linked to 11220000,
                      which in  turn  is  linked  to  330000,  which
                      finally  is  linked to 22440000.  _n_e_x_t_-_l_a_b_e_l is
                      ignored with _m_g_e_t_t_y(1).

       Several additional composite settings  are  available  for
       _i_n_i_t_i_a_l_-_f_l_a_g_s  and  _f_i_n_a_l_-_f_l_a_g_s.   The following composite
       flags are supported by _m_g_e_t_t_y and are usually supported by
       _g_e_t_t_y:

       SSAANNEE                equivalent to ``stty sane''.  (BRKINT,
                           IGNPAR, ISTRIP,  ICRNL,  IXON,  OPOST,
                           CS8, CREAD, ISIG, ICANON, ECHO, ECHOK)

       OODDDDPP                Odd parity (CS7, PARENB, PARODD)

       PPAARRIITTYY,EEVVEENNPP        even parity (CS7, PARENB)

       --OODDDDPP,--PPAARRIITTYY,--EEVVEENNPP
                           no parity (resets PARENB, PARODD,  and
                           sets CS8)

       RRAAWW                 raw   I/O  (no  canonical  processing)
                           (turns off OPOST, ICANON)

       --RRAAWW,CCOOOOKKEEDD         enable canonical processing (turns  on
                           OPOST, ICANON)

       NNLL                  Ignore newlines.  (ICRNL, ONLCR)

       --NNLL                 Respect  newlines (turns INLCR, IGNCR,
                           ICRNL, ONLCR, OCRNL, ONLRET off)

       LLCCAASSEE               Ignore case - treat all as  lowercase.
                           (IUCLC, OLCUC, XCASE) Is set if mgetty
                           believes login is entirely  uppercase.

       --LLCCAASSEE              Repect  case  (turns  off IUCLC, OLCUC
                           and XCASE)

       TTAABBSS                output tabs as tabs

       --TTAABBSS,TTAABB33          output tabs as spaces

       EEKK                  Sets VERASE to "#" and VKILL to  CKILL



greenie                      4 Dec 93                           3





mgettydefs(4)         mgetty_sendfax manual         mgettydefs(4)


                           respectively.   (note  that while many
                           gettys default VERASE to "#".   _m_g_e_t_t_y
                           defaults VERASE to backspace.)

       Additionally,  _m_g_e_t_t_y  (but  not _g_e_t_t_y) can set any of the
       control characters  listed  in  the  cc__cccc  termio(termios)
       structure by the use of two tokens:

       <character name> <value>

       Eg:

       VERASE ^h

       The  value  can  be  set  as ``^<character>'', ``\nnn'' or
       ``\<character>'' (normal UNIX \ escapes).

       See the _t_e_r_m_i_o(7) or _t_e_r_m_i_o_s(7) manual pages to a list  of
       which  ``V''  variables can be changed.  Note that many of
       these can be changed in the c_cc array, but won't have any
       effect.

       If  _g_e_t_t_y  is  called without a second argument, the first
       entry of //eettcc//ggeettttyyddeeffss is used by _g_e_t_t_y, thus making  the
       first  entry  of  //eettcc//ggeettttyyddeeffss the default entry.  It is
       also used  if  _g_e_t_t_y  cannot  find  the  specified  _l_a_b_e_l.
       _M_g_e_t_t_y  use  a  default  label  of  ``n'', but this can be
       changed in the configuration.  If //eettcc//ggeettttyyddeeffss itself is
       missing,  there  is one entry built into the command which
       brings up a terminal at 330000  (configuration  parameter  in
       _m_g_e_t_t_y) baud.

       It  is strongly recommended that after making or modifying
       //eettcc//ggeettttyyddeeffss, it be run through  _g_e_t_t_y  with  the  check
       option to be sure there are no errors.

EEXXAAMMPPLLEESS
       The  following  two lines show an example of 300/1200 baud
       toggle, which is useful for dial-up ports:

              1200# B1200 HUPCL # B1200 SANE IXANY  TAB3  #login:
              #300
              300#  B300  HUPCL  #  B300  SANE IXANY TAB3 #login:
              #1200

       The following line shows a typical 9600 baud entry  for  a
       hard-wired   connection   (not   currently  supported  for
       _m_g_e_t_t_y):

              9600# B9600 # B9600 SANE  IXANY  IXANY  ECHOE  TAB3
              #login: #9600

       The  following  line is a typical smart-modem setup, suit-
       able for _m_g_e_t_t_y:



greenie                      4 Dec 93                           4





mgettydefs(4)         mgetty_sendfax manual         mgettydefs(4)


              19200mg#
                  B19200 #
                  B19200 SANE VERASE \b VINTR \003 HUPCL #
                  \n\D \T \N Users @!login: #19200mg

FFIILLEESS
       /etc/gettydefs

SSEEEE AALLSSOO
       mgetty(1),  getty(8),   login(1),   ioctl(2),   termio(7),
       termios(7).














































greenie                      4 Dec 93                           5


