#include <stdio.h>
#include <linux/bios32.h>
#include <linux/pci.h>

#include "probepci.h" 
#include "release.h"


/* Recognize multi-function device */

int multi_function(bus,dev_fn)
unsigned char   bus;
unsigned char   dev_fn;
{
unsigned char header;
	pcibios_read_config_byte(
		bus, dev_fn, (unsigned char) PCI_HEADER_TYPE, &header);
	if (header&7==7) return 1;
		else	 return 0;
}





/* Gives the Class code using the 16 higher bits */
/* of the PCI_CLASS_REVISION configuration register */

void class_decode(bus,dev_fn)
unsigned char	bus;
unsigned char	dev_fn;
{
struct pci_class_type 	pci_class[PCI_CLASS_NUM] = PCI_CLASS_TYPE;
int 			i;
unsigned long   	class;
        pcibios_read_config_dword(
		bus, dev_fn, (unsigned char) PCI_CLASS_REVISION, &class);
	class=class >> 16;
	for (i=0;i<PCI_CLASS_NUM;i++) 
		if (class==pci_class[i].pci_class_id) {
			printk("ProbePci          %s\n",pci_class[i].pci_class_name);
			break;
	}
	if (i==PCI_CLASS_NUM) printk("ProbePci          Unknown PCI device\n");
}



/* print all the information on the device if it's include in the  */
/* data base, otherwise ask for an infor;ation report. */

int type_decode(bus,dev_fn,vendor)
unsigned char		bus;
unsigned char		dev_fn;
unsigned short          vendor;
{
struct pci_device_type 	pci_device[PCI_DEVICE_NUM] = PCI_DEVICE_TYPE;
int 			i;
unsigned short   	device;


	pcibios_read_config_word(
		bus, dev_fn, (unsigned char) PCI_DEVICE_ID, &device);
	for (i=0;i<PCI_DEVICE_NUM;i++) 
		if ((device==pci_device[i].pci_device_id) && (vendor==pci_device[i].pci_vendor_id)) {
			printk("ProbePci          Device : %s\n",pci_device[i].pci_device_name);
			break;
			}
	if (i==PCI_DEVICE_NUM) {
		printk("ProbePci          Unknown device id :%x \n",device);
		printk("ProbePci          Please find out and mail at potter@cao-vlsi.ibp.fr\n");
		return 1;
	}
	return 0;
}









int device_decode(bus,dev_fn)
unsigned char		bus;
unsigned char		dev_fn;
{
struct pci_vendor_type 	pci_vendor[PCI_VENDOR_NUM] = PCI_VENDOR_TYPE;
int 			i;
unsigned short   	vendor;

	pcibios_read_config_word(
		bus, dev_fn, (unsigned char) PCI_VENDOR_ID, &vendor);
	for (i=0;i<PCI_VENDOR_NUM;i++) 
		if (vendor==pci_vendor[i].pci_vendor_id) {
			printk("ProbePci          Vendor : %s\n",pci_vendor[i].pci_vendor_name);
			break;
	}
	if (i==PCI_VENDOR_NUM) 
		 printk("ProbePci          Unknown vendor id :%x \n",vendor);
	return type_decode( bus, dev_fn, vendor);
}







/* Call all the information procedures */

void info(bus,dev_fn)
unsigned char	bus;
unsigned char	dev_fn;
{
	class_decode(bus,dev_fn);
	device_decode(bus,dev_fn);

}

void probe_devices(bus)
unsigned char bus;
{
unsigned char	dev_fn;
unsigned long	res;

/* For a mysterious reason, my PC crash if I try to probe device 31 function 7  */
/* (i.e. dev_fn=0xff) It can be a bug in my BIOS, or I havn't understood all about */
/* PCI */


	for (dev_fn=0x0;dev_fn<0xff;dev_fn++) {
		pcibios_read_config_dword(
			bus, dev_fn, (unsigned char) PCI_CLASS_REVISION, &res);

/* First we won't try to talk to non_present chip */
/* Second, we get rid of non multi-function device that seems to be lazy  */
/* and not fully decode the function number */

		if ((res!=0xffffffff) && 
			(((dev_fn & 7) == 0) || multi_function(bus,dev_fn))) {
			printk("ProbePci Device found at bus %d, device %d, function %d.\n",
					(int) bus,
					(int) ((dev_fn & 0xf8) >> 3),
					(int) (dev_fn & 7));
			info(bus,dev_fn);
		}
	}
}



int probe_pci(void)
{
	if (pcibios_present()==0) {
		printk("ProbePci PCI bios not detected.\n");
		return 1;
	} else {
		printk( "ProbePci Probe PCI hardware . Copyright Frederic Potter 1994. Thanks to Drew.\n");
		probe_devices(0);
		return 0;
	}
}

int init_module (void)
{
	probe_pci();
	return 0;
}


int cleanup_module (void)
{
	return 0;
}

