#define PCI_CLASS_NOT_DEFINED		0x0000
#define PCI_CLASS_NOT_DEFINED_VGA	0x0001

#define PCI_CLASS_STORAGE_SCSI		0x0100
#define PCI_CLASS_STORAGE_IDE		0x0101
#define PCI_CLASS_STORAGE_FLOPPY	0x0102
#define PCI_CLASS_STORAGE_IPI		0x0103
#define PCI_CLASS_STORAGE_OTHER		0x0180

#define PCI_CLASS_NETWORK_ETHERNET	0x0200
#define PCI_CLASS_NETWORK_TOKEN_RING	0x0201
#define PCI_CLASS_NETWORK_FDDI		0x0202
#define PCI_CLASS_NETWORK_OTHER		0x0280

#define PCI_CLASS_DISPLAY_VGA		0x0300
#define PCI_CLASS_DISPLAY_XGA		0x0301
#define PCI_CLASS_DISPLAY_OTHER		0x0380

#define PCI_CLASS_MULTIMEDIA_VIDEO	0x0400
#define PCI_CLASS_MULTIMEDIA_AUDIO	0x0401
#define PCI_CLASS_MULTIMEDIA_OTHER	0x0480

#define PCI_CLASS_MEMORY_RAM		0x0500
#define PCI_CLASS_MEMORY_FLASH		0x0501
#define PCI_CLASS_MEMORY_OTHER		0x0580

#define PCI_CLASS_BRIDGE_HOST		0x0600
#define PCI_CLASS_BRIDGE_ISA		0x0601
#define PCI_CLASS_BRIDGE_EISA		0x0602
#define PCI_CLASS_BRIDGE_MC		0x0603
#define PCI_CLASS_BRIDGE_PCI		0x0604
#define PCI_CLASS_BRIDGE_PCMCIA		0x0605
#define PCI_CLASS_BRIDGE_OTHER		0x0680

#define PCI_CLASS_OTHERS		0xff

struct pci_class_type {
	unsigned long pci_class_id;
	char *pci_class_name;
};

#define PCI_CLASS_NUM 27
#define PCI_CLASS_TYPE    { \
	{PCI_CLASS_NOT_DEFINED,		"Old unidentified pci device"}, \
	{PCI_CLASS_NOT_DEFINED_VGA,	"Old VGA display controller"}, \
	{PCI_CLASS_STORAGE_SCSI,	"SCSI bus controller"}, \
	{PCI_CLASS_STORAGE_IDE,		"IDE controller"}, \
	{PCI_CLASS_STORAGE_FLOPPY,	"Floppy controller"}, \
	{PCI_CLASS_STORAGE_IPI,		"IPI bus controller"}, \
	{PCI_CLASS_STORAGE_OTHER,	"Unknown type of mass storage controller"}, \
	{PCI_CLASS_NETWORK_ETHERNET,	"Ethernet controller"}, \
	{PCI_CLASS_NETWORK_TOKEN_RING,	"Token ring controller"}, \
	{PCI_CLASS_NETWORK_FDDI,	"FDDI controller"}, \
	{PCI_CLASS_NETWORK_OTHER,	"Unknown type of network controller"}, \
	{PCI_CLASS_DISPLAY_VGA,		"VGA display controller"}, \
	{PCI_CLASS_DISPLAY_XGA,		"XGA display controller"}, \
	{PCI_CLASS_DISPLAY_OTHER,	"Unknown type of display controller"}, \
	{PCI_CLASS_MULTIMEDIA_VIDEO,	"Video device"}, \
	{PCI_CLASS_MULTIMEDIA_AUDIO,	"Audio device"}, \
	{PCI_CLASS_MULTIMEDIA_OTHER,	"Unknown type of multimedia device"}, \
	{PCI_CLASS_MEMORY_RAM,		"RAM controller"}, \
	{PCI_CLASS_MEMORY_FLASH,	"FLASH controller"}, \
	{PCI_CLASS_MEMORY_OTHER,	"Unknown type of memory controller"}, \
	{PCI_CLASS_BRIDGE_HOST,		"Host bridge"}, \
	{PCI_CLASS_BRIDGE_ISA,		"ISA bridge"}, \
	{PCI_CLASS_BRIDGE_EISA,		"EISA bridge"}, \
	{PCI_CLASS_BRIDGE_MC,		"MC bridge"}, \
	{PCI_CLASS_BRIDGE_PCI,		"PCI to PCI bridge"}, \
	{PCI_CLASS_BRIDGE_PCMCIA,	"PCMCIA bridge"}, \
	{PCI_CLASS_BRIDGE_OTHER,	"Unknown type of bridge device"} \
}



#define PCI_VENDOR_ID_S3		0x5333
#define PCI_DEVICE_ID_S3_864		0x88c1

#define PCI_VENDOR_ID_OPTI		0x1045
#define PCI_DEVICE_ID_OPTI_82C822	0xc822
#define PCI_DEVICE_ID_OPTI_82C621	0xc621

struct pci_vendor_type {
	unsigned short pci_vendor_id;
	char *pci_vendor_name;
};


#define PCI_VENDOR_NUM 4
#define PCI_VENDOR_TYPE { \
	{PCI_VENDOR_ID_NCR,		"NCR"}, \
	{PCI_VENDOR_ID_ADAPTEC,		"Adaptec"}, \
	{PCI_VENDOR_ID_S3,		"S3"}, \
	{PCI_VENDOR_ID_OPTI,		"OPTI"} \
}

struct pci_device_type {
	unsigned short pci_vendor_id;
	unsigned short pci_device_id;
	char *pci_device_name;
};

#define PCI_DEVICE_NUM 8
#define PCI_DEVICE_TYPE { \
	{PCI_VENDOR_ID_NCR,	PCI_DEVICE_ID_NCR_53C810,	"53c810"}, \
	{PCI_VENDOR_ID_NCR,	PCI_DEVICE_ID_NCR_53C815,	"53c815"}, \
	{PCI_VENDOR_ID_NCR,	PCI_DEVICE_ID_NCR_53C820,	"53c820"}, \
	{PCI_VENDOR_ID_NCR,	PCI_DEVICE_ID_NCR_53C825,	"53c825"}, \
	{PCI_VENDOR_ID_ADAPTEC,	PCI_DEVICE_ID_ADAPTEC_2940,	"2940"}, \
	{PCI_VENDOR_ID_S3,	PCI_DEVICE_ID_S3_864,		"864-P"}, \
	{PCI_VENDOR_ID_OPTI,	PCI_DEVICE_ID_OPTI_82C822,	"82C822"}, \
	{PCI_VENDOR_ID_OPTI,	PCI_DEVICE_ID_OPTI_82C621,	"82C621"} \
}




