#define E
#include "both.h"
int articleCount=0;


get_message_index()
{
int count,low,high,response,lastread;
char *sp,buf[1024],group[512];
FILE *indexfp,*ifp,*tmpfp;

/* If suck.restart exists something went wrong */
 ifp = fopen( "suck.restart", "r" );
 if (ifp!=NULL) 
 {
  fclose(ifp);
  articleCount=-1;
  return;
 }

 ifp = fopen( "sucknewsrc", "r" );
 if ( ifp == NULL )
 {
  perror( "sucknewsrc:" );
  failure();
 }

 tmpfp = fopen( "suck.tmp", "w" );
 if ( tmpfp == NULL )
 {
  perror("suck.tmp: ");
  failure();
 }

 indexfp = fopen( "suck.index", "w" );
 if (indexfp==NULL)
 {
  perror("suck.index");
  failure();
 }

 while ( fscanf( ifp, "%s %d\n", group, &lastread ) == 2 )
 {
  sprintf(buf,"group %s\r\n",group);
#ifdef DEBUG2
  fprintf(debugfp,"group %s\n",group);
#endif
  sputline(sockfd,buf);
  sgetline(sockfd,buf,1024);
  sp = number(buf, &response);
  if (sp == NULL)
  {
   fprintf(stderr,"Protocol error!\n");
   failure();
  }
  if ( response != 211 )
  {
   fprintf(stderr,"GROUP <%s>, unexpected response %d\n", group, response );
   continue; /* next newsgroup */
  }
  sp = number( sp, &count );
  sp = number( sp, &low );
  sp = number( sp, &high );
  
  fprintf(tmpfp, "%s %d\n", group, high);
  
  if ( lastread && lastread < high )
  {
   if ( lastread < low ) lastread = low;
   sprintf( buf, "xhdr Message-ID %d-\r\n", lastread+1 );
   fprintf(stderr,"%s...articles %d-%d\n", group, lastread+1, high);
   sputline( sockfd, buf );
   sgetline( sockfd, buf, 1024 );
   number(buf, &response);
   if (response == 221)
   {
    do
    {
     sgetline( sockfd, buf, 1024 );
     if (buf[0] != '.' )
     {
      for ( sp = buf; *sp != '<'; sp++ ) ;
      fprintf( indexfp, "%s\n", sp );
      articleCount++;
     }
    } while ( buf[0] != '.' || buf[1] != '\0' );
   } /* end if response */
   else
   {
    fprintf(stderr,"Unexpected response %d getting IDs\n", response );
    failure();
   }
  } /* end if lastread */
 } /* end while */
 fclose(indexfp);
 fclose(tmpfp);
 fclose(ifp);
}


void get_articles(long offset)
{
int response,len;
char buf[1024];
FILE *logfp,*ifp;

 ifp = fopen( "suck.sorted" , "r" );
 if ( ifp == NULL )
 {
  perror("suck.sorted");
  failure();
 }

 fseek(ifp,offset,SEEK_SET); /* goto indexline */

 logfp = fopen( "suck.restart", "w" );
 if ( logfp == NULL )
 {
  perror("suck.restart");
  failure();
 }
 
 for ( sprintf(buf,"article "); fgets(&buf[8], 512, ifp) != NULL;
									sprintf(buf,"article "))
 {
  rewind(logfp);
  fprintf(logfp,"%d\n%d\n",offset,articleCount);
  fflush(logfp);
  offset=ftell(ifp);
  fprintf(stderr,"%d\n", articleCount--);
  len=strlen(buf);
  buf[len++]='\r';
  buf[len++]='\n';
  buf[len]='\0';

#ifdef DEBUG
fputs("SENDING REQUEST\n",debugfp);
fputs(buf,debugfp);
#endif
  sputline(sockfd,buf);
  sgetline(sockfd,buf,1024);
  number(buf, &response);

  if ( response != 220 )
  {
   fprintf(stderr,"*** Warning: Unexpected response\n*** ");
   fputs(buf,stderr);
   fputc('\n',stderr);
   continue;
  }

  do
  {
   len=sgetline(sockfd, buf, 1024);
   puts(buf);
   fflush(stdout);
  } while ( (len!=1) || (buf[0] != '.') );
 
 } /* end for */
 fclose(ifp);
 fclose(logfp);
 unlink("suck.restart");
}


main(int argc, char **argv)
{
char buf[1024];
FILE *fp;
long offset=0;

#ifdef DEBUG
debugfp=fopen("suck.debug","w");
#endif

 connect_to_nntphost( (argc>1) ? argv[1] : getenv("NNTPSERVER") );

 /*
  Get the announcement line
 */

 sgetline(sockfd, buf, 1024);
 fprintf(stderr,"%s\n", buf );

 sputline(sockfd,"mode reader\r\n");
 sgetline(sockfd,buf,1024); /* Again the announcement */
 fprintf(stderr,"%s\n",buf);

 get_message_index();

 switch(articleCount)
 {
 case 0:
 	fprintf(stderr,"No articles.\n");
	goto end;
	break;
 case -1:
	fp = fopen("suck.restart","r");
	fscanf(fp,"%d\n%d\n",&offset,&articleCount);
	fclose(fp);
	fprintf(stderr,"Initiating restart at article %d\n",articleCount);
	break;
 default:
	unlink("suck.sorted");
	fprintf(stderr,"Removing duplicates from list of %d articles.\n",
													articleCount);
	system("sort suck.index | uniq > suck.sorted");
  }
	
  get_articles(offset);
  fprintf(stderr,"skipped %d duplicates\n",articleCount);

end:
 fprintf(stderr,"Closing connection to %s\n",hi->h_name);
 sputline( sockfd, "quit\r\n" );
 close(sockfd);
#ifdef DEBUG
fclose(debugfp);
#endif
}

