#include "both.h"

/* get next number in string */
char *number(char *sp, int *intPtr)
{
int i,c;

 if (sp==NULL) { *intPtr=0; return(sp); }
 for (i=0;sp[i]!=' ';i++) if (sp[i]=='\0') break;
 c=sp[i];
 sp[i]='\0';
 sscanf(sp,"%d",intPtr);
 sp[i++]=c;
 return sp+i;
}

/* exit on failure, but close connection first */
void failure()
{
 close(sockfd);
 exit(-1);
}

void get_hostent(char *host)
{
struct in_addr saddr;
int c;

if (host==NULL) { fprintf(stderr,"No hostname given !\r\n"); exit(-1); }
c=*host;
if (isdigit(c)) 
{
 saddr.s_addr = inet_addr(host); 
 hi = gethostbyaddr((char *)&saddr,sizeof(struct in_addr),AF_INET);
}
else hi = gethostbyname(host);
}

void connect_to_nntphost(char *host)
{
char *ptr;
struct in_addr *aptr;
struct in_addr saddr;
struct sockaddr_in	address;

/*
	Find the internet address of the NNTP server
*/
 get_hostent(host);
 if ( hi == NULL )
 {
  fprintf(stderr,"%s :",host);
  perror("Could not get host information:");
  exit(-1);
 }
 fprintf(stderr,"Official host name: %s\r\n", hi->h_name );
 while ( (ptr = *(hi->h_aliases)) != NULL )
 {
  fprintf(stderr,"Alias %s\r\n", ptr );
  hi->h_aliases++;
 }
 if ( hi->h_addrtype != AF_INET )
 {
  fprintf(stderr,"Unsupported address type.\r\n" );
  exit(-1);
 }
 while ( (aptr = (struct in_addr *)*(hi->h_addr_list)++) != NULL )
 {
  saddr = *aptr;
  fprintf(stderr,"Address: %s\r\n", inet_ntoa(*aptr) );
 }

 /*
  Create a socket
 */
 sockfd = socket( AF_INET, SOCK_STREAM, 0 );
 if ( sockfd == -1 )
 {
  perror("Socket failed:");
  exit(-1);
 }
 
 address.sin_family = AF_INET;
 address.sin_port = htons(119);  /* NNTP port */
 address.sin_addr= saddr;

/* 
 Establish a connection
*/
 if ( connect( sockfd, (struct sockaddr *)&address, sizeof address ) == -1 )
 {
  perror("Connect failed:");
  failure();
 }
 fprintf(stderr,"Connected to %s\r\n",hi->h_name);
}

/*
 get a CR\NL terminated line from newsserver.
 sgetline now checks for maxlen. this means lines > 1024 bytes
 or > maxlen will be truncated automatically with all good/bad consequences.
*/
int	sgetline(int fd, char *sbuf, int maxlen)
{
int	ret;
char *ptr;
static int count=0;
static char tempbuf[1030];

 if (maxlen>1024 || maxlen<1) maxlen=1024;

 if (count>0)			/* some bytes left from previous sgetline */
 {
  ptr=strstr(tempbuf,"\r\n");
#ifdef DEBUG2
fprintf(debugfp,"debug count %d\n",count);
fputs(tempbuf,debugfp);
fputc('\n',debugfp);
#endif
  if (ptr!=NULL) goto returnline;
  if (count>=maxlen) { ptr=&tempbuf[maxlen-1]; goto returnline; }
 }

 do
 {
  ret=recv(fd, &tempbuf[count], maxlen-count, 0);
  if (ret<1) { perror("socket error: "); failure(); }
  count+=ret;
  tempbuf[count]='\0'; /* for strstr to work */
  ptr=strstr(tempbuf,"\r\n");
 } while (ptr==NULL);

returnline:
 ret=ptr-tempbuf;			/* somehow it's the strlen */
 bcopy(tempbuf,sbuf,ret);   /* copy the whole line */
 ptr=sbuf+ret;				/* point to \r\n in sbuf */
 *ptr='\0';					/* terminate sbuf, forget \r\n */
 count= count - ret - 2;	/* count=remaining bytes in tempbuf */
 if (count>0) 
 {
  bcopy(tempbuf+ret+2,tempbuf,count); /* bcopy cares for overlap */
  tempbuf[count]='\0';		/* terminate tempbuf */
 }
 else { count=0; *tempbuf='\0'; }
#ifdef DEBUG1
fprintf(debugfp,"RETURNING ",count);
fputs(sbuf,debugfp);
fputc('\n',debugfp);
#endif
 return(ret);				/* return strlen of sbuf */
}


int sputline(int fd, char *outbuf)
{
#ifdef DEBUG2
fprintf(debugfp,"\ndebug putline:");
fputs(outbuf,debugfp);
#endif
 return send(fd, outbuf, strlen(outbuf), 0);
}
