#include <stdio.h>

#define RNEWS "/usr/lib/news/rnews"

extern int errno;

/* get news data from stdin and post it to the local server */

void main(int argc,char**argv)
{
FILE *pfp=NULL;
char line[1024];
int len,count=0,verbose=0;

 if (argc>1) verbose=1;

 while ( gets(line) != NULL)
 {
  len=strlen(line);
  if ( line[0] == '.' && len == 1) /* end of article */
  {
    if (verbose) fprintf(stderr,"end of article %d\n",count);
    if ( pfp != NULL )
	{
	 pclose(pfp);
	 pfp = NULL;
	 continue;
	}
  }

  if (pfp == NULL)
  {
   if (verbose) fprintf(stderr,"posting article %d\n", ++count);
   pfp = popen(RNEWS, "w");
   if ( pfp == NULL )
   {
	 perror("Error: cannot open rnews: ");
	 exit(1);
   }
  }
  fputs(line, pfp); putc('\n', pfp);
 } /* end while */
 exit(0);
}
