/*  xvset 0.6--graphical interface for xset.
    Copyright (C) 1994 Brian L. Brush <brush@acomp.usf.edu>,
    223 S. Riverhills Dr., Tampa, FL 33617-7240, USA.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <xview/xview.h>
#include <xview/panel.h>

#define	VERSION	0.6

main(argc, argv)
char *argv[];
{
    Frame frame;
    Panel panel;
    Panel_slider_item mouse_accel_slider,
	mouse_thresh_slider,
	bell_vol_slider,
	bell_pitch_slider,
	bell_dur_slider,
	saver_timeout_slider,
	saver_cycle_slider;
    Panel_choice_item saver_blank, saver_exposure;
    Panel_item repeat_check_box, saver_check_box;
    extern void exit();
    char version_info[]="xvset 0.5, Copyright (C) 1994 Brian L. Brush\nxvset comes with ABSOLUTELY NO WARRANTY.  This is free software, and you are\nwelcome to redistribute it under certain conditions.  See the file \"COPYING\"\nfor details.";

    void
    apply(Panel_item item, Event *event)
    {
	char command_string[256];
	char repeat_string[4] = "on";
	char saver_string[4] = "on";
	char saver_blank_string[8] = "blank";
	char saver_exposure_string[9] = "expose";
	int mouse_accel = (int)xv_get(mouse_accel_slider, PANEL_VALUE);
	int mouse_thresh = (int)xv_get(mouse_thresh_slider, PANEL_VALUE);
	int bell_vol = (int)xv_get(bell_vol_slider, PANEL_VALUE);
	int bell_pitch = (int)xv_get(bell_pitch_slider, PANEL_VALUE);
	int bell_dur = (int)xv_get(bell_dur_slider, PANEL_VALUE);
	int saver_timeout = (int)xv_get(saver_timeout_slider, PANEL_VALUE);
	int saver_cycle = (int)xv_get(saver_cycle_slider, PANEL_VALUE);

	if (xv_get(repeat_check_box, PANEL_VALUE) == 0)
	{
		strcpy(repeat_string, "off");
	}
	if (xv_get(saver_check_box, PANEL_VALUE) == 0)
	{
		strcpy(saver_string, "off");
	}
	if (xv_get(saver_blank, PANEL_VALUE) == 1)
	{
		strcpy(saver_blank_string, "noblank");
	}
	if (xv_get(saver_exposure, PANEL_VALUE) == 1)
	{
		strcpy(saver_exposure_string, "noexpose");
	}
	sprintf(command_string, "xset m %d %d b %d %d %d r %s s %s s %d %d s %s s %s",
		mouse_accel,
		mouse_thresh,
		bell_vol,
		bell_pitch,
		bell_dur,
		repeat_string,
		saver_string,
		saver_timeout,
		saver_cycle,
		saver_blank_string,
		saver_exposure_string);
	system(command_string);
    }

    (void) xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

    if (argc > 1)
	{
		if (strcmp(argv[1], "-v") == 0)
		{
			puts(version_info);
			exit(0);
		}
		else
		{
			printf("unknown option %s\n", argv[1]);
			exit(1);
		}
	}
    frame = (Frame)xv_create((int)NULL, FRAME_CMD,
	FRAME_LABEL,		"Server Settings",
	FRAME_CMD_DEFAULT_PIN_STATE,	FRAME_CMD_PIN_IN,
	NULL);
    panel = (Panel)xv_get(frame, FRAME_CMD_PANEL);
    xv_set(panel, PANEL_LAYOUT, PANEL_VERTICAL, NULL);
    mouse_accel_slider = xv_create(panel, PANEL_SLIDER,
	XV_HELP_DATA,		"xvset:mouse_acceleration",
        PANEL_LABEL_STRING,     "    Mouse Acceleration: ",
        PANEL_VALUE,            2,
        PANEL_MIN_VALUE,        0,
        PANEL_MAX_VALUE,        10,
        PANEL_TICKS,            10,
        NULL);
    mouse_thresh_slider = xv_create(panel, PANEL_SLIDER,
	XV_HELP_DATA,		"xvset:mouse_threshold",
	PANEL_LABEL_STRING,	"        Mouse Threshold: ",
	PANEL_VALUE,		4,
	PANEL_MIN_VALUE,	0,
	PANEL_MAX_VALUE,	10,
	PANEL_TICKS,		10,
	NULL);
    bell_vol_slider = xv_create(panel, PANEL_SLIDER,
	XV_HELP_DATA,		"xvset:bell_volume",
	PANEL_LABEL_STRING,	"                 Bell Volume: ",
	PANEL_VALUE,		100,
	PANEL_MIN_VALUE,	0,
	PANEL_MAX_VALUE,	100,
	PANEL_TICKS,		10,
	NULL);
    bell_pitch_slider = xv_create(panel, PANEL_SLIDER,
	XV_HELP_DATA,		"xvset:bell_pitch",
	PANEL_LABEL_STRING,	"                     Bell Pitch: ",
	PANEL_VALUE,		1000,
	PANEL_MIN_VALUE,	0,
	PANEL_MAX_VALUE,	10000,
	PANEL_TICKS,		10,
	NULL);
    bell_dur_slider = xv_create(panel, PANEL_SLIDER,
	XV_HELP_DATA,		"xvset:bell_duration",
	PANEL_LABEL_STRING,	"              Bell Duration: ",
	PANEL_VALUE,		50,
	PANEL_MIN_VALUE,	0,
	PANEL_MAX_VALUE,	1000,
	PANEL_TICKS,		10,
	NULL);
    repeat_check_box = xv_create(panel, PANEL_CHECK_BOX,
	XV_HELP_DATA,		"xvset:auto-repeat",
	PANEL_LABEL_STRING,	"                Auto-repeat: ",
	PANEL_VALUE,		1,
	NULL);
    saver_check_box = xv_create(panel, PANEL_CHECK_BOX,
	XV_HELP_DATA,		"xvset:screen_saver",
	PANEL_LABEL_STRING,	"               Screen Saver: ",
	PANEL_VALUE,		1,
	NULL);
    saver_timeout_slider = xv_create(panel, PANEL_SLIDER,
	PANEL_LABEL_STRING,	"Screen Saver Timeout: ",
	XV_HELP_DATA,		"xvset:screen_saver_timeout",
	PANEL_VALUE,		600,
	PANEL_MIN_VALUE,	0,
	PANEL_MAX_VALUE,	6000,
	PANEL_TICKS,		10,
	NULL);
    saver_cycle_slider = xv_create(panel, PANEL_SLIDER,
	XV_HELP_DATA,		"xvset:screen_saver_cycle",
	PANEL_LABEL_STRING,	"     Screen Saver Cycle: ",
	PANEL_VALUE,		600,
	PANEL_MIN_VALUE,	0,
	PANEL_MAX_VALUE,	6000,
	PANEL_TICKS,		10,
	NULL);
    saver_blank = xv_create(panel, PANEL_CHOICE,
	XV_HELP_DATA,		"xvset:blanking",
	PANEL_LABEL_STRING,	"                      Blanking: ",
	PANEL_CHOICE_STRINGS,	"Blank", "Noblank", NULL,
	PANEL_VALUE,		0,
	NULL);
    saver_exposure = xv_create(panel, PANEL_CHOICE,
	XV_HELP_DATA,		"xvset:exposures",
	PANEL_LABEL_STRING,	"                    Exposures: ",
	PANEL_CHOICE_STRINGS,	"Expose", "Noexpose", NULL,
	PANEL_VALUE,		0,
	NULL);
    xv_create(panel, PANEL_BUTTON,
	XV_HELP_DATA,		"xvset:apply",
	PANEL_LABEL_STRING,	"Apply",
	PANEL_NOTIFY_PROC,	apply,
	NULL);
    window_fit(panel);
    window_fit(frame);
    xv_main_loop(frame);
    exit(0);
}
