#include <stdlib.h>
#include <string.h>
#include "lutil.h"
#include "xutil.h"
#include "ftn.h"
#include "nodelist.h"
#include "config.h"
#include "session.h"

extern int forcedcalls;
extern char *forcedphone;
extern char *forcedline;
#if defined(HAS_TCP) || defined(HAS_TERM)
extern char *inetaddr;
#endif

extern char *get_modem_string(modem_string*,node*);
extern int openport(char*,int);
#if defined(HAS_TCP) || defined(HAS_TERM)
extern int opentcp(char*);
extern void closetcp(void);
#endif
extern void localport(void);
extern void nolocalport(void);
extern void closeport(void);
extern int dialphone(node*,char*);
extern int hangup(node*);
extern void rdoptions(node*);
extern int nodelock(faddr*);
extern int nodeulock(faddr*);

int call(addr)
faddr *addr;
{
	node *nlent;
	int rc=1;
	int speed;
	char *portlist,*p,*q;

	if ((nlent=getnlent(addr)) == NULL)
	{
		logerr("cannot call %s: fatal in nodelist lookup",
			ascfnode(addr,0x1f));
		return 1;
	}

	if (nodelock(addr))
	{
		loginf("system %s locked",ascinode(addr,0x1f));
		return 1;
	}

	rdoptions(nlent);

	inbound=protinbound; /* master sessions are secure */

	if ((nlent->phone || forcedphone
#if defined(HAS_TCP) || defined(HAS_TERM)
					 || inetaddr
#endif
							) &&
	    (forcedcalls || 
	     (((nlent->pflag & (DUMMY|DOWN|HOLD|PVT)) == 0) && 
	      ((localoptions & NOCALL) == 0))))
	{
		loginf("calling %s (%s, phone %s)",ascfnode(addr,0x1f),
			nlent->name,nlent->phone?nlent->phone:forcedphone);
#if defined(HAS_TCP) || defined(HAS_TERM)
		if (inetaddr)
		{
			rc=opentcp(inetaddr);
			if (rc)
			{
				loginf("cannot connect %s",inetaddr);
				nodeulock(addr);
				return rc;
			}
		}
		else
#endif
		     if (forcedline)
		{
			rc=openport(forcedline,0);
			if (rc)
			{
				loginf("cannot open port %s",forcedline);
				nodeulock(addr);
				return rc;
			}
		}
		else
		{
			if ((portlist=xstrcpy(get_modem_string(modemport,nlent))) == NULL)
			{
				logerr("no matching ports defined");
				nodeulock(addr);
				return 1;
			}
			for (rc=1,p=strtok(portlist," \t,");
				rc && p;
				p=strtok(NULL," \t,"))
			{
				if ((q=strrchr(p,':')))
				{
					*q++='\0';
					if ((*q == 'l') || (*q == 'L'))
					{
						speed=atoi(++q);
					}
					else
					{
						speed=atoi(q);
						if (nlent->speed < speed)
							speed=nlent->speed;
					}
				}
				else speed=0;
				rc=openport(p,speed);
			}
			if (rc)
			{
				loginf("no free matching ports");
				free(portlist);
				nodeulock(addr);
				return rc;
			}
			free(portlist);
		}
#if defined(HAS_TCP) || defined(HAS_TERM)
		if (!inetaddr)
#endif
		if ((rc=dialphone(nlent,forcedphone?forcedphone:nlent->phone)))
		{
			loginf("dial failed");
			nodeulock(addr);
		}

		if (rc == 0)
		{
#if defined(HAS_TCP) || defined(HAS_TERM)
			if (!inetaddr)
#endif
				nolocalport();
			rc=session(addr,nlent,SESSION_MASTER,
				SESSION_UNKNOWN,NULL);
		}
#if defined(HAS_TCP) || defined(HAS_TERM)
		if (inetaddr)
		{
			closetcp();
		}
		else
#endif
		{
			localport();
			hangup(nlent);
			closeport();
		}
	}
	else
	{
		loginf("cannot call %s (%s, phone %s)",
			ascfnode(addr,0x1f),nlent->name,
			nlent->phone);
		nodeulock(addr);
	}

	return rc;
}
