#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAS_REGEX_H
#include <regex.h>
#else
char *re_comp(char*);
int re_exec(char*);
#endif
#include <dirent.h>
#include "session.h"
#include "xutil.h"
#include "lutil.h"
#include "config.h"

#ifndef S_ISDIR
#define S_ISDIR(st_mode)       (((st_mode) & S_IFMT) == S_IFDIR)
#endif
#ifndef S_ISREG
#define S_ISREG(st_mode)       (((st_mode) & S_IFMT) == S_IFREG)
#endif

#define KFS 2

extern char *freqname;
extern char *logname;
extern int execsh(char*,char*,char*,char*);
extern unsigned long atoul(char*);

static file_list *respfreq(char*,char*,char*);
static file_list *respmagic(char*);

file_list *respond_wazoo(char*);
file_list *respond_wazoo(fn)
char *fn;
{
	char buf[256];
	char *nm,*pw,*dt,*p;
	file_list *fl=NULL,**tmpl;
	FILE *fp;

	if (freqname == NULL) return NULL;

	if ((fp=fopen(freqname,"r")) == NULL)
	{
		logerr("$cannot open received wazoo freq \"%s\"",freqname);
		unlink(freqname);
		free(freqname);
		freqname=NULL;
		return NULL;
	}

	tmpl=&fl;
	while (fgets(buf,sizeof(buf)-1,fp))
	{
		nm=NULL;
		pw=NULL;
		dt=NULL;
		p=strtok(buf," \n\r");
		if ((p == NULL) || (*p == '\0')) continue;
		nm=p;
		p=strtok(NULL," \n\r");
		if (p && (*p == '!')) pw=p+1;
		else if (p && ((*p == '+') || (*p == '-'))) dt=p;
		p=strtok(NULL," \n\r");
		if (p && (*p == '!')) pw=p+1;
		else if (p && ((*p == '+') || (*p == '-'))) dt=p;
		*tmpl=respfreq(nm,pw,dt);
		while (*tmpl) tmpl=&((*tmpl)->next);
	}

	fclose(fp);
	unlink(freqname);
	free(freqname);
	freqname=NULL;
	for (tmpl=&fl;*tmpl;tmpl=&((*tmpl)->next))
	{
		debug(12,"resplist: %s",(*tmpl)->local);
	}
	return fl;
}

file_list *respond_bark(char*);
file_list *respond_bark(buf)
char *buf;
{
	char *nm,*pw,*dt,*p;

	nm=buf;
	pw="";
	dt="0";
	while (isspace(*nm)) nm++;
	for (p=nm;*p && (!isspace(*p));p++);
	if (*p)
	{
		*p++='\0';
		dt=p;
		while (isspace(*dt)) dt++;
		for (p=dt;*p && (!isspace(*p));p++);
		if (*p)
		{
			*p++='\0';
			pw=p;
			while (isspace(*pw)) pw++;
			for (p=pw;*p && (!isspace(*p));p++);
			*p='\0';
		}
	}
	return respfreq(nm,pw,dt);
}

file_list *respfreq(nm,pw,dt)
char *nm,*pw,*dt;
{
	file_list *fl=NULL,**tfl;
	DIR *dp;
	struct dirent *de;
	struct stat st;
	char mask[256],*p,*q;
	char *tnm,*tdir;
	time_t upd=0L;
	int newer=1,pass;

	loginf("remote requested \"%s\" (update %s, password \"%s\")",nm,dt,pw);

	tfl=&fl;

	if (dt)
	{
		if (*dt == '+')
		{
			newer=1;
			dt++;
		}
		else if (*dt == '-')
		{
			newer=0;
			dt++;
		}
		else newer=1;
		upd=atoul(dt);
	}
	tnm=xstrcpy(magic);
	tnm=xstrcat(tnm,"/");
	tnm=xstrcat(tnm,nm);
	if ((stat(tnm,&st) == 0) &&
	    (S_ISREG(st.st_mode)) &&
	    (access(tnm,X_OK) == 0))
	{
		return respmagic(tnm); /* respmagic will free(tnm) */
	}
	else free(tnm);

	tdir=xstrcpy(public);
	if ((p=strrchr(nm,'/')))
	{
		*p++='\0';
		tdir=xstrcat(tdir,"/");
		tdir=xstrcat(tdir,nm);
	}
	else
		p=nm;

	q=mask;
	while ((*p) && (q < (mask+sizeof(mask)-4)))
	{
		switch (*p)
		{
		case '\\':	*q++='\\'; *q++='\\'; break;
		case '?':	*q++='.'; break;
		case '.':	*q++='\\'; *q++='.'; break;
		case '*':	*q++='.'; *q++='*'; break;
		default:	*q++=*p; break;
		}
		p++;
	}
	*q++='$';
	*q='\0';

	if ((dp=opendir(tdir)) == NULL)
	{
		logerr("$cannot opendir \"%s\"",public);
		free(tdir);
		return NULL;
	}

	for (pass=0;(pass < 2) && (fl == NULL);pass++)
	{
		if (pass > 0)
		{
			for (p=mask;*p;p++) *p=tolower(*p);
			rewinddir(dp);
		}
		debug(12,"try search mask: \"%s\"",mask);
		re_comp(mask);

		while ((de=readdir(dp))) if (re_exec(de->d_name))
		{
			debug(12,"matching file \"%s\"",de->d_name);
			tnm=xstrcpy(public);
			tnm=xstrcat(tnm,"/");
			tnm=xstrcat(tnm,de->d_name);

			if ((stat(tnm,&st) == 0) &&
			    (S_ISREG(st.st_mode)) &&
			    (access(tnm,R_OK) == 0) &&
			    ((upd == 0L) ||
			     ((newer) && (st.st_mtime > upd)) ||
			     ((!newer) && (st.st_mtime <= upd))))
			{
				*tfl=(file_list *)xmalloc(sizeof(file_list));
				(*tfl)->next=NULL;
				(*tfl)->flofp=NULL;
				(*tfl)->floff=0L;
				(*tfl)->disposition=0;
				(*tfl)->local=tnm;
				(*tfl)->remote=xstrcpy(de->d_name);
				tfl=&((*tfl)->next);
			}
			else free(tnm);
		}
		
	}

	free(tdir);
	closedir(dp);
	return fl;
}

file_list *respmagic(cmd) /* must free(cmd) before exit */
char *cmd;
{
	char cmdbuf[256];
	char tmpfn[L_tmpnam];
	char remname[32],*p;
	file_list *fl=NULL;

	debug(12,"respond to \"magic\" file request \"%s\"",cmd);
	(void)tmpnam(tmpfn);
	if ((p=strrchr(cmd,'/'))) p++;
	else p=cmd;
	strncpy(remname,p,sizeof(remname)-1);
	if (remote->addr->name == NULL) remote->addr->name=xstrcpy("Sysop");
	sprintf(cmdbuf,"%s %s",
		cmd,ascfnode(remote->addr,0x7f));
	if (execsh(cmdbuf,"/dev/null",tmpfn,logname))
	{
		logerr("error executing magic file request");
		unlink(tmpfn);
	}
	else
	{
		fl=(file_list *)xmalloc(sizeof(file_list));
		fl->next=NULL;
		fl->flofp=NULL;
		fl->floff=0L;
		fl->disposition=KFS;
		fl->local=xstrcpy(tmpfn);
		fl->remote=xstrcpy(remname);
		debug(12,"magic resp list: \"%s\" -> \"%s\"",
			fl->local,fl->remote);
	}
	free(cmd);
	return fl;
}
