#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <sys/stat.h>
#include "ftn.h"
#include "lutil.h"
#include "config.h"

#ifndef PATH_MAX
#define PATH_MAX 512
#endif

extern FILE *openflo(faddr *,char);

void try_attach(fn,mode,addr,flavor)
char *fn;
int mode;
faddr *addr;
char flavor;
{
	FILE *flo;
	char pn[PATH_MAX],*p,*f;
	struct stat stbuf;

	for (p=fn;*p;p++) if (*p == '\\') *p='/';

	f=fn;
	while (isspace(*f)) f++;
	strncpy(pn,f,sizeof(pn));
	if (*(p=pn+strlen(pn)-1) == '\n') *(p--)='\0';
	while (isspace(*p)) p--;

	debug(3,"Trying fileattach \"%s\" (mode %d) to %s (flavor %c)",
		fn,mode,ascfnode(addr,0x1f),flavor);

	if (stat(pn,&stbuf) != 0)
	{
		for (p=pn;*p;p++) *p=tolower(*p);
		if (stat(pn,&stbuf) != 0)
		{
			strncpy(pn,inbound,sizeof(pn)-1);
			strcat(pn,"/");
			p=pn+strlen(pn);
			if ((f=strrchr(fn,'/'))) f++;
			else f=fn;
			while (isspace(*f)) f++;
			strncpy(p,f,sizeof(pn)-strlen(pn));
			if (*(p=pn+strlen(pn)-1) == '\n') *(p--)='\0';
			while (isspace(*p)) p--;
			if (stat(pn,&stbuf) != 0)
			{
				for (p=pn;*p;p++) *p=tolower(*p);
				if (stat(pn,&stbuf) != 0)
				{
					loginf("$cannot stat \"%s\" attach to %s",
						fn,ascfnode(addr,0x1f));
					return;
				}
			}
		}
	}

	if ((flo=openflo(addr,flavor)) == NULL) return;

	if ((p=strrchr(fn,'/')))
	{
		while (*(++p)) *(fn++)=*p;
		*(fn++)='\0';
	}

	debug(3,"attaching file \"%s\" to node %s",pn,ascfnode(addr,0x1f));

	fseek(flo,0L,SEEK_END);
	switch (mode)
	{
	case 0:	break;
	case 1: fprintf(flo,"#"); break;
	case 2: fprintf(flo,"^"); break;
	}
	fprintf(flo,"%s\n",pn);

	fclose(flo);
	return;
}
