#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sysexits.h>
#ifdef HAS_SYSLOG
#include <syslog.h>
#endif
#include "getopt.h"
#include "lutil.h"
#include "xutil.h"
#include "ftn.h"
#include "falists.h"
#include "rfcmsg.h"
#include "ftnmsg.h"
#include "areas.h"
#include "config.h"
#include "version.h"

extern int newsmode;
extern char *configname;
extern char passwd[];

extern FILE *openpkt(faddr *,char);
extern int putmessage(rfcmsg *,ftnmsg *,FILE *,FILE *,fa_list **);
extern void closepkt(FILE *);
extern char *bgets(char *,int,FILE *);
extern void readareas(char *);
extern void try_attach(char *,int,faddr *,char);

int usetmp=0;
faddr *bestaka;

void usage(void)
{
	confusage("-n -r<addr> -g<grade> <recip> ...");
	fprintf(stderr,"-n		set news mode\n");
	fprintf(stderr,"-r<addr>	address to route packet\n");
	fprintf(stderr,"-g<grade>	[ n | c | h ] \"flavor\" of packet\n");
	fprintf(stderr,"<recip>		list of receipient addresses\n");
}

int main(argc,argv)
int argc;
char *argv[];
{
	int c;
	char *p;
	char buf[BUFSIZ];
	FILE *fp,*pkt = NULL;
	char *routec=NULL;
	faddr *route = NULL;
	fa_list **envrecip, *envrecip_start = NULL;
	int envrecip_count=0;
	area_list *area = NULL, *area_start = NULL;
	int area_count=0;
	int msg_in=0,msg_out=0;
	rfcmsg *msg=NULL,*tmsg;
	ftnmsg *fmsg=NULL;
	faddr *taddr;
	char flavor='n';
	fa_list *sbl = NULL;

#ifdef MAILLOG
	logfacility=MAILLOG;
#endif

	setmyname(argv[0]);
	while ((c=getopt(argc,argv,"g:r:x:I:nh")) != -1)
	if (confopt(c,optarg)) switch (c)
	{
		case 'g':	if (optarg && ((*optarg == 'n') || 
				   (*optarg == 'c') || (*optarg == 'h')))
					flavor=*optarg;
				else 
				{
					usage(); 
					exit(EX_USAGE);
				}
				break;
		case 'r':	routec=optarg; break;
		case 'n':	newsmode=1; break;
		default:	usage(); exit(EX_USAGE);
	}

	if (readconfig())
	{
		fprintf(stderr,"Error getting configuration, aborting\n");
		exit(EX_DATAERR);
	}

	if ((routec) && ((route=parsefaddr(routec)) == NULL))
		logerr("unparsable route address \"%s\"",routec);

	if ((p=strrchr(argv[0],'/'))) p++;
	else p=argv[0];
	if (!strcmp(p,"ifnews")) newsmode=1;

	if (newsmode)
	{
		readareas(areafile);
#ifdef NEWSLOG
		logfacility=NEWSLOG;
#endif
	}

	envrecip=&envrecip_start;
	while (argv[optind])
	if ((taddr=parsefaddr(argv[optind++]))) 
	{
		(*envrecip)=(fa_list*)xmalloc(sizeof(fa_list));
		(*envrecip)->next=NULL;
		(*envrecip)->addr=taddr;
		envrecip=&((*envrecip)->next);
		envrecip_count++;
	}
	else logerr("unparsable recipient \"%s\", ignored",argv[optind-1]);

	if ((!newsmode) && (!envrecip_count))
	{
		logerr("No valid receipients specified, aborting");
		exit(EX_NOUSER);
	}

	if (!route && newsmode && envrecip_count)
		route=envrecip_start->addr;

	if (!route) route=parsefaddr(getenv("NEWSSITE"));

	if (!route)
	{
		logerr("Routing address not specified, aborting");
		exit(EX_USAGE);
	}

	bestaka=bestaka_s(route);

	for(envrecip=&envrecip_start;*envrecip;envrecip=&((*envrecip)->next))
		loginf("envrecip: %s",ascfnode((*envrecip)->addr,0x7f));
	loginf("route: %s",ascfnode(route,0x1f));

	umask(066); /* packets may contain confidential information */

	while (!feof(stdin))
	{
		usetmp=0;
		tidyrfc(msg);
		msg=parsrfc(stdin);

		if (pkt == NULL)
		{
			if (flavor == 'n') flavor='o';
			if ((p=hdr("X-FTN-FLAGS",msg)))
			{
				if (strstr(p,"CRS")) flavor='c';
				else if (strstr(p,"HLD")) flavor='h';
				if (strstr(p,"ATT"))
					try_attach(hdr("Subject",msg),0,route,flavor);
				if (strstr(p,"TFS"))
					try_attach(hdr("Subject",msg),1,route,flavor);
				if (strstr(p,"KFS"))
					try_attach(hdr("Subject",msg),2,route,flavor);
			}
			else if ((p=hdr("Priority",msg)) ||
			         (p=hdr("X-Class",msg)))
			{
				while (isspace(*p)) p++;
				if ((strncasecmp(p,"fast",4) == 0) ||
				    (strncasecmp(p,"high",4) == 0) ||
				    (strncasecmp(p,"crash",5) == 0))
					flavor='c';
				else if ((strncasecmp(p,"slow",4) == 0) ||
				         (strncasecmp(p,"low",3) == 0) ||
				         (strncasecmp(p,"hold",4) == 0))
					flavor='h';
			}
			if ((pkt=openpkt(route,flavor)) == NULL)
			{
				logerr("Unable to open packet for node %s, aborting",
					ascfnode(route,0x1f));
				exit(EX_CANTCREAT);
			}
		}

		if (newsmode)
		{
			tidy_arealist(area_start);
			area_start=areas(hdr("Newsgroups",msg));
			area_count=0;
			for(area=area_start;area;area=area->next)
			{
				area_count++;
				debug(9,"area: %s",area->name);
			}
			tidy_falist(&sbl);
			for (tmsg=msg;tmsg;tmsg=tmsg->next)
				if (strcasecmp(tmsg->key,"X-FTN-SEEN-BY") == 0)
					fill_list(&sbl,tmsg->val);
		}

		if (((!newsmode) && (envrecip_count > 1)) ||
		    ((newsmode) && (area_count > 1)))
		{
			if ((fp=tmpfile()) == NULL)
			{
				logerr("$Cannot open temporary file");
				exit(EX_OSERR);
			}
			while(bgets(buf,sizeof(buf)-1,stdin))
				fputs(buf,fp);
			rewind(fp);
			usetmp=1;
		}
		else
		{
			fp=stdin;
			usetmp=0;
		}

		if (newsmode && ((area_count < 1) || hdr("Control",msg) ||
		     (in_list(route,&sbl))))
		{
			debug(9,"skipping news message w/o valid newsgroups or Control header or seen by this node");
			while(bgets(buf,sizeof(buf)-1,fp));
		}
		else
		{
			fill_list(&sbl,ascfnode(bestaka,0x06));
			fill_list(&sbl,ascfnode(route,0x06));
			tidy_ftnmsg(fmsg);
			if ((fmsg=mkftnhdr(msg)) == NULL)
			{
				logerr("Unable to create FTN headers from RFC ones, aborting");
				exit(EX_UNAVAILABLE);
			}

			if (newsmode)
			{
				fmsg->to->zone=route->zone;
				fmsg->to->net=route->net;
				fmsg->to->node=route->node;
				fmsg->to->point=route->point;
#ifndef REAL_ADDRESS_IN_MSGHDR
				/* overwrite real "from" with our addr */
				fmsg->from->zone=bestaka->zone;
				fmsg->from->net=bestaka->net;
				fmsg->from->node=bestaka->node;
				fmsg->from->point=bestaka->point;
#endif
			}

			if (!newsmode)
			for(envrecip=&envrecip_start;*envrecip;envrecip=&((*envrecip)->next))
			{
				fmsg->to=(*envrecip)->addr;
				if (putmessage(msg,fmsg,fp,pkt,&sbl))
				{
					logerr("Unable to put netmail message into the packet, aborting");
					exit(EX_SOFTWARE);
				}
				if (usetmp) rewind(fp);
				fmsg->to=NULL;
				msg_out++;
			}
			else
			for(area=area_start;area;area=area->next)
			{
				fmsg->area=area->name;
				if (putmessage(msg,fmsg,fp,pkt,&sbl))
				{
					logerr("Unable to put echo message into the packet, aborting");
					exit(EX_SOFTWARE);
				}
				if (usetmp) rewind(fp);
				fmsg->area=NULL;
				msg_out++;
			}
			msg_in++;
		}
		if (usetmp) fclose(fp);
	}

	closepkt(pkt);

	loginf("end input %d, output %d messages",msg_in,msg_out);

	return EX_OK;
}
