#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#ifdef HAS_SYSLOG
#include <syslog.h>
#endif
#include "getopt.h"
#include "lutil.h"
#include "config.h"
#include "version.h"
#include "ftn.h"
#include "getheader.h"

extern int getmessage(FILE *,faddr *,faddr *);
extern void readareas(char *);
extern void readalias(char *);

extern int num_echo,num_mail;

int usetmp=1; /* to tell bgets that we do not use batch mode */

void usage(name)
char *name;
{
	confusage("");
}

FILE *nb = NULL;

int main(argc,argv)
int argc;
char *argv[];
{
	int c;
	int rc;
	faddr from,to;

#ifdef MAILLOG
	logfacility=MAILLOG;
#endif

	setmyname(argv[0]);
	while ((c=getopt(argc,argv,"hx:I:")) != -1)
	if (confopt(c,optarg)) switch (c)
	{
		default:	usage(argv[0]); exit(1);
	}

	if (readconfig())
	{
		logerr("Error getting configuration, aborting");
		exit(1);
	}

	readareas(areafile);
	readalias(aliasfile);

	if (verbose)
	{
		mkdir("/tmp/ifmail",0777);
		loginf("in debug mode resultant messages will go to /tmp/ifmail");
	}

#ifdef PARANOID
	if ((rc=getheader(&from,&to,stdin)) != 0)
#else
	if (((rc=getheader(&from,&to,stdin)) != 0) && (rc != 4))
#endif
	{
		logerr("%s, aborting",(rc==3)?"packet not to this node":
			(rc==4)?"bad password":"bad packet");
		exit(rc);
	}

	while ((rc=getmessage(stdin,&from,&to)) == 1);

	if (nb) fclose(nb);

	loginf("end %d echomail, %d netmail messages processed, rc=%d",
		num_echo,num_mail,rc);

	return rc;
}
