#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "xutil.h"
#include "lutil.h"
#include "ftn.h"
#include "ftnmsg.h"
#include "rfcmsg.h"
#include "config.h"
#include "bwrite.h"
#include "falists.h"

#define MAXMSGSIZE 8192
#define MSGTYPE 2
#define MAXSEEN 70
#define MAXPATH 73

extern int newsmode;
extern char *version;
extern faddr *bestaka;

#ifdef HAS_NDBM_H
extern char *idlookup(char *);
#endif
extern char *bgets(char *,int,FILE *);
extern long sequencer(void);

int needputrfc(msg)
rfcmsg *msg;
{
	faddr *ta;

	/* 0-junk, 1-kludge, 2-pass */

	if (!strcasecmp(msg->key,"X-UUCP-From")) return 0;
	if (!strcasecmp(msg->key,"X-Body-Start")) return 0;
	if (!strncasecmp(msg->key,"X-FTN-",6)) return 0;
	if (!strcasecmp(msg->key,"Newsgroups")) return 0;
	if (!strcasecmp(msg->key,"Xref")) return 0;
	if (!strcasecmp(msg->key,"Return-Receipt-To")) return 1;
	if (!strcasecmp(msg->key,"Received")) return newsmode?0:2;
	if (!strcasecmp(msg->key,"From"))
	{
		if ((ta=parsefaddr(msg->val)))
		{
			tidy_faddr(ta);
			return 0;
		}
		else return 2;
	}
	if (!strcasecmp(msg->key,"To"))
	{
		if (newsmode) return 0;
		if ((ta=parsefaddr(msg->val)))
		{
			tidy_faddr(ta);
			return 0;
		}
		else return 2;
	}
	if (!strcasecmp(msg->key,"Reply-To")) return 2;
	if (!strcasecmp(msg->key,"Lines")) return 0;
	if (!strcasecmp(msg->key,"Date")) return 0;
	if (!strcasecmp(msg->key,"Subject")) 
	{
		if (strlen(msg->val) > MAXSUBJ) return 2;
		else return 0;
	}
	if (!strcasecmp(msg->key,"Organization")) return 1; 
	if (!strcasecmp(msg->key,"Comment-To")) return 0;
	if (!strcasecmp(msg->key,"X-Comment-To")) return 0;
	if (!strcasecmp(msg->key,"Keywords")) return 2;
	if (!strcasecmp(msg->key,"Summary")) return 2;
	/*if (!strcasecmp(msg->key,"")) return ;*/
	return 1;
}

extern char *months[];
static char *weekday[] = {
"Sun","Mon","Tue","Wed","Thu","Fri","Sat"
};

char *viadate(void)
{
	static char buf[64];
	time_t t;
	struct tm *ptm;

	time(&t);
	ptm=localtime(&t);
	sprintf(buf,"%s %s %d %d at %02d:%02d",
		weekday[ptm->tm_wday],months[ptm->tm_mon],
		ptm->tm_mday,ptm->tm_year+1900,ptm->tm_hour,ptm->tm_min);
	return buf;
}

int putmessage(msg,fmsg,fp,pkt,sbl)
rfcmsg *msg;
ftnmsg *fmsg;
FILE *fp,*pkt;
fa_list **sbl;
{
	char buf[BUFSIZ],*p,*q,subjext[16],newsubj[MAXSUBJ+1];
	rfcmsg *tmp;
	int rfcheaders;
	int needsplit,datasize,splitpart;
	fa_list *tmpl;
	fa_list *ptl=NULL;
	int seenlen;
	int oldnet;
	int i;
	char sbe[16];

	debug(3,"putmessage from %s",ascfnode(fmsg->from,0x7f));
	debug(3,"putmessage   to %s",ascfnode(fmsg->to,0x7f));
	debug(3,"putmessage subj %s",fmsg->subj);
	debug(3,"putmessage flags %04x",fmsg->flags);
	debug(3,"putmessage msgid %s",fmsg->msgid);
	debug(3,"putmessage reply %s",fmsg->reply);
	debug(3,"putmessage date %s",fmsg->date);

	needsplit=0;
	splitpart=0;
	do
	{
		datasize=14;

		iwrite(MSGTYPE,         pkt);
		iwrite(fmsg->from->node,pkt);
		iwrite(fmsg->to->node,  pkt);
		iwrite(fmsg->from->net, pkt);
		iwrite(fmsg->to->net,   pkt);
		iwrite(fmsg->flags,     pkt);
		iwrite(0,               pkt);
		awrite(fmsg->date,      pkt);
		awrite(fmsg->to->name,  pkt);
		awrite(fmsg->from->name,pkt);
		if (splitpart)
		{
			sprintf(subjext,"...part %d",splitpart+1);
			strcpy(newsubj,fmsg->subj);
			if ((int)strlen(newsubj) > (int)(MAXSUBJ - strlen(subjext)))
				newsubj[MAXSUBJ - strlen(subjext)] = '\0';
			strcat(newsubj,subjext);
			awrite(newsubj,pkt);
		}
		else awrite(fmsg->subj,pkt);

		if (fmsg->area) fprintf(pkt,"AREA:%s\r",fmsg->area);

		if (!newsmode)
		{
			if (fmsg->to->point)
				fprintf(pkt,"\1TOPT %u\r",fmsg->to->point);
			if (fmsg->from->point)
				fprintf(pkt,"\1FMPT %u\r",fmsg->from->point);
#ifndef FORCEINTL
			if (fmsg->to->zone != fmsg->from->zone)
#endif
				fprintf(pkt,"\1INTL %u:%u/%u %u:%u/%u\r",
					fmsg->to->zone,
					fmsg->to->net,
					fmsg->to->node,
					fmsg->from->zone,
					fmsg->from->net,
					fmsg->from->node
					);
		}
		if ((!needsplit) && fmsg->msgid) 
			fprintf(pkt,"\1MSGID: %s\r",fmsg->msgid);
		else
			fprintf(pkt,"\1MSGID: %s %08lx \r",
				ascfnode(bestaka,0x1f),
				sequencer());
		if (fmsg->reply) fprintf(pkt,"\1REPLY: %s\r",fmsg->reply);

		for (tmp=msg;tmp;tmp=tmp->next) 
		if (!strncmp(tmp->key,"X-FTN-",6) &&
		    strcasecmp(tmp->key,"X-FTN-AREA") &&
		    strcasecmp(tmp->key,"X-FTN-SEEN-BY") &&
		    strcasecmp(tmp->key,"X-FTN-PATH") &&
		    strcasecmp(tmp->key,"X-FTN-Via"))
			if (strcasecmp(tmp->key,"X-FTN-KLUDGE") == 0)
			{
				datasize += strlen(tmp->val);
				fprintf(pkt,"\1");
		/* we should have restored the original string here... */
				kwrite(tmp->val,pkt);
			}
			else
			{
				datasize += strlen(tmp->key)+strlen(tmp->val);
				fprintf(pkt,"\1%s:",tmp->key+6);
				kwrite(tmp->val,pkt);
			}

		rfcheaders=0;
		for (tmp=msg;tmp;tmp=tmp->next) if (needputrfc(tmp) == 1)
		{
			rfcheaders++;
			datasize += strlen(tmp->key)+strlen(tmp->val);
			fprintf(pkt,"\1RFC-%s:",tmp->key);
			kwrite(tmp->val,pkt);
		}
		for (tmp=msg;tmp;tmp=tmp->next) if (needputrfc(tmp) == 2)
		{
			rfcheaders++;
			datasize += strlen(tmp->key)+strlen(tmp->val);
			fprintf(pkt,"%s:",tmp->key);
			cwrite(tmp->val,pkt);
		}
		if (rfcheaders) cwrite("\n",pkt);

		if (needsplit)
		{
			fprintf(pkt," * Continuation %d of a splitted message *\r\r",
				splitpart);
			needsplit=0;
		}
		else if ((p=hdr("X-Body-Start",msg))) 
		{
			datasize += strlen(p);
			cwrite(p,pkt);
		}
		while (!(needsplit=(datasize > MAXMSGSIZE)) &&
			(bgets(buf,sizeof(buf)-1,fp)))
		{
			debug(19,"putmessage body %s",buf);
			datasize += strlen(buf);
			cwrite(buf,pkt);
		}
		if (needsplit)
		{
			fprintf(pkt,"\r * Message split, to be continued *\r");
			splitpart++;
		}
			
		if (newsmode)
		{
			fprintf(pkt,"\r--- ifmail v.%s",version);
			fprintf(pkt,"\r * Origin: "); /* strlen=11 */
			p=ascfnode(fmsg->from,0x1f);
			i=79-11-3-strlen(p);
			if (strlen(fmsg->origin) > i) fmsg->origin[i]='\0';
			cwrite(fmsg->origin ? fmsg->origin : "Unknown",pkt);
			fprintf(pkt," (%s)",p);

			for (tmpl=whoami;tmpl;tmpl=tmpl->next)
			if ((tmpl->addr->point == 0) &&
			    ((bestaka->domain == NULL) ||
			     (tmpl->addr->domain == NULL) ||
			     (strcasecmp(bestaka->domain,
					tmpl->addr->domain) == 0)) &&
			    (bestaka->zone == tmpl->addr->zone))
				fill_list(sbl,ascfnode(tmpl->addr,0x06));
#ifdef HAS_NDBM_H
			if ((p=hdr("Message-ID",msg)))
			{
				while (isspace(*p)) p++;
				q=xstrcpy(p);
				if (*(p=q+strlen(q)-1) == '\n') *(p--)='\0';
				while (isspace(*p)) *(p--)='\0';
				fill_list(sbl,idlookup(q));
				free(q);
			}
#endif
			sort_list(sbl);
			seenlen=MAXSEEN+1;
			/* ensure it will not match for the first entry */
			oldnet=(*sbl)->addr->net-1;
			for (tmpl=*sbl;tmpl;tmpl=tmpl->next)
			{
				if (tmpl->addr->net == oldnet)
					sprintf(sbe," %u",tmpl->addr->node);
				else
					sprintf(sbe," %u/%u",tmpl->addr->net,
							tmpl->addr->node);
				oldnet=tmpl->addr->net;
				seenlen+=strlen(sbe);
				if (seenlen > MAXSEEN)
				{
					seenlen=0;
					fprintf(pkt,"\rSEEN-BY:");
					sprintf(sbe," %u/%u",tmpl->addr->net,
							tmpl->addr->node);
					seenlen=strlen(sbe);
				}
				fprintf(pkt,"%s",sbe);
			}

			for (tmp=msg;tmp;tmp=tmp->next) 
			if (!strcasecmp(tmp->key,"X-FTN-PATH"))
			{
				fill_path(&ptl,tmp->val);
			}
			sprintf(sbe,"%u/%u",bestaka->net,
				bestaka->node);
			fill_path(&ptl,sbe);
			uniq_list(&ptl);
			seenlen=MAXPATH+1;
			/* ensure it will not match for the first entry */
			oldnet=ptl->addr->net-1;
			for (tmpl=ptl;tmpl;tmpl=tmpl->next)
			{
				if (tmpl->addr->net == oldnet)
					sprintf(sbe," %u",tmpl->addr->node);
				else
					sprintf(sbe," %u/%u",tmpl->addr->net,
							tmpl->addr->node);
				oldnet=tmpl->addr->net;
				seenlen+=strlen(sbe);
				if (seenlen > MAXPATH)
				{
					seenlen=0;
					fprintf(pkt,"\r\1PATH:");
					sprintf(sbe," %u/%u",tmpl->addr->net,
							tmpl->addr->node);
					seenlen=strlen(sbe);
				}
				fprintf(pkt,"%s",sbe);
			}
			fprintf(pkt,"\r");
		}
		else /* mail mode */
		{
			for (tmp=msg;tmp;tmp=tmp->next) 
			if (!strcasecmp(tmp->key,"X-FTN-Via"))
			{
			datasize += strlen(tmp->key)+strlen(tmp->val);
				fprintf(pkt,"\1Via");
				kwrite(tmp->val,pkt);
			}
			fprintf(pkt,"\1Via ifmail %s, %s (%s)\r",
				ascfnode(bestaka,0x1f),
				viadate(),version);
		}
		awrite("",pkt); /* trailing zero byte */
	}
	while (needsplit);

	debug(3,"putmessage exiting...");
	return 0;
}
