#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "xutil.h"
#include "lutil.h"
#include "ftn.h"
#include "ftnmsg.h"
#include "rfcmsg.h"
#include "config.h"

#ifndef ULONG_MAX
#define ULONG_MAX 4294967295
#endif

int newsmode=0;
extern char *version;

extern faddr *bestaka;

extern time_t parsedate(char *,void *);
extern void registrate(char *,char *);
extern unsigned long atoul(char*);

extern unsigned long sequencer(void);
extern unsigned long crc(char *);

static char *flnm[] = {
	"PVT","CRS","RCV","SNT","ATT","TRN","ORP","K/S",
	"LOC","HLD","RSV","FRQ","RRQ","RRC","ARQ","FUP"
};

void setflags(tmsg,s)
ftnmsg *tmsg;
char *s;
{
	char *buf,*p;
	int i;

	buf=xstrcpy(s);
	p=strtok(buf," ,\t\n");
	while (p)
	{
		for (i=0;i<16;i++)
			if (!strcasecmp(p,flnm[i]))
				tmsg->flags |= (1 << i);
		p=strtok(NULL," ,\t\n");
	}
	free(buf);
}

char *months[] = {
"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
};

char *ftndate(t)
time_t t;
{
	static char buf[32];
	struct tm *ptm;

	ptm=localtime(&t);
	sprintf(buf,"%2d %s %2d  %02d:%02d:%02d",ptm->tm_mday,
		months[ptm->tm_mon],ptm->tm_year%100,
		ptm->tm_hour,ptm->tm_min,ptm->tm_sec);
	return xstrcpy(buf);
}

char *ftnmsgid(msgid)
char *msgid;
{
	char *buf,*l,*r;
	unsigned long nid;
	faddr *tmp;

	if (msgid)
	{
		buf=xmalloc(strlen(msgid)+65);
		strcpy(buf,msgid);
		if ((l=strchr(buf,'<'))) l++;
		else l=buf;
		while (isspace(*l)) l++;
		if ((r=strchr(l,'>'))) *r='\0';
		if (*(r=l+strlen(l)-1) == '\n') *r='\0';
		if ((tmp=parsefaddr(l)))
		{
			if (strspn(tmp->name,"0123456789") == strlen(tmp->name))
				nid=atoul(tmp->name);
			else nid=ULONG_MAX;
			if (nid == ULONG_MAX) nid=crc(tmp->name);
			sprintf(buf,"%s %08lx",ascfnode(tmp,0x1f),nid);
			tidy_faddr(tmp);
			r=xstrcpy(buf);
		}
		else
		{
			if ((r=strchr(l,'@')) == NULL)
			{
				sprintf(buf,"%s %08lx",
					ascfnode(bestaka,0x1f),
					crc(l));
				r=xstrcpy(buf);
			}
			else
			{
				*r++='\0';
				if (strspn(l,"0123456789") == strlen(l))
					nid=atoul(l);
				else nid=ULONG_MAX;
				if (nid == ULONG_MAX) nid=crc(l);
				sprintf(r+strlen(r)," %08lx",nid);
				r=xstrcpy(r);
			}
		}
	}
	else
	{
		buf=xmalloc(64); /* is it really enough for normal msgid ?*/
		sprintf(buf,"%s %08lx",ascfnode(bestaka,0x1f),
			sequencer());
		r=xstrcpy(buf);
	}

	free(buf);
	return r;
}

void tidy_ftnmsg(tmsg)
ftnmsg *tmsg;
{
	if (tmsg == NULL) return;

	tmsg->flags=0;
	if (tmsg->to) tidy_faddr(tmsg->to); tmsg->to=NULL;
	if (tmsg->from) tidy_faddr(tmsg->from); tmsg->from=NULL;
	if (tmsg->date) free(tmsg->date); tmsg->date=NULL;
	if (tmsg->subj) free(tmsg->subj); tmsg->subj=NULL;
	if (tmsg->msgid) free(tmsg->msgid); tmsg->msgid=NULL;
	if (tmsg->reply) free(tmsg->reply); tmsg->reply=NULL;
	if (tmsg->origin) free(tmsg->origin); tmsg->origin=NULL;
	if (tmsg->area) free(tmsg->area); tmsg->area=NULL;
	free(tmsg);
}

ftnmsg *mkftnhdr(msg)
rfcmsg *msg;
{
	char *freename,*rfcfrom,*p,*l,*r;
	char *fbuf=NULL;
	ftnmsg *tmsg;

	tmsg=(ftnmsg *)xmalloc(sizeof(ftnmsg));

	tmsg->flags=0;
	tmsg->to=NULL;
	tmsg->from=NULL;
	tmsg->date=NULL;
	tmsg->subj=NULL;
	tmsg->msgid=NULL;
	tmsg->reply=NULL;
	tmsg->origin=NULL;
	tmsg->area=NULL;

	if (newsmode)
	{
		if ((p=xstrcpy(hdr("Comment-To",msg))) == NULL)
			p=xstrcpy(hdr("X-Comment-To",msg));
		if (p)
		{
			if ((tmsg->to=parsefaddr(p)) == NULL)
			{
				tmsg->to=parsefaddr("All@p0.f0.n0.z0");
				if ((l=strrchr(p,'<')) && (r=strchr(p,'>')) && (l < r))
				{
					r=l;
					*r--='\0';
					while (isspace(*r)) *r--='\0';
					l=p;
					while (isspace(*l)) l++;
				}
				else if ((l=strrchr(p,'(')) && (r=strchr(p,'>')) && 
				         (l < r))
				{
					*r--='\0';
					while (isspace(*r)) *r--='\0';
					l++;
					while (isspace(*l)) l++;
				}
				else
				{
					l=p;
					while (isspace(*l)) l++;
					r=p+strlen(p)-1;
					if (*r == '\n') *r--='\0';
					while (isspace(*r)) *r--='\0';
				}

				if(*l)
				{
					free(tmsg->to->name);
					tmsg->to->name=xstrcpy(l);
				}
			}
			free(p);
		}
		else
		tmsg->to=parsefaddr("All@p0.f0.n0.z0");
		debug(3,"TO: %s",ascinode(tmsg->to,0x7f));
	}

	p=fbuf=xstrcpy(hdr("From",msg));
	if (fbuf == NULL)
	{
		p=fbuf=xstrcpy(hdr("X-UUCP-From",msg));
		if (p) 
		{
			while (isspace(*p)) p++;
			if ((l=strchr(p,' '))) *l='\0'; 
		}
	}
	if (fbuf == NULL) p=fbuf=xstrcpy("Unidentified User <postmaster>");
	if ((l=strchr(p,'<')) && (r=strchr(p,'>')) && (l < r))
	{
		*l++ = '\0';
		*r++ = '\0';
		rfcfrom=l;
		freename=p;
		debug(3,"From address: \"%s\", name: \"%s\" (angle brackets)",
			rfcfrom,freename);
	}
	else if ((l=strchr(p,'(')) && (r=strrchr(p,')')) && (l < r))
	{
		*l++ = '\0';
		*r++ = '\0';
		rfcfrom=p;
		freename=l;
		debug(3,"From address: \"%s\", name: \"%s\" (round brackets)",
			rfcfrom,freename);
	}
	else
	{
		rfcfrom=p;
		freename=p;
		debug(3,"From address: \"%s\", name: \"%s\" (no brackets)",
			rfcfrom,freename);
	}
	if (rfcfrom)
	{
		while (isspace(*rfcfrom)) rfcfrom++;
		p=rfcfrom+strlen(rfcfrom)-1;
		while ((isspace(*p)) || (*p == '\n')) *(p--)='\0';
	}
	if (freename)
	{
		while (isspace(*freename)) freename++;
		p=freename+strlen(freename)-1;
		while ((isspace(*p)) || (*p == '\n')) *(p--)='\0';
		if ((*freename == '\"') && (*(p=freename+strlen(freename)-1) == '\"'))
		{
			freename++;
			*p='\0';
		}
	}
	if (*freename == '\0') freename=rfcfrom;

	if (strlen(freename) > MAXNAME) freename[MAXNAME]='\0';

	if (newsmode) debug(3,"FROM: %s <%s>",freename,rfcfrom);
	else loginf("from: %s <%s>",freename,rfcfrom);

	if ((tmsg->from=parsefaddr(rfcfrom)) == NULL)
	{
		if (freename && rfcfrom)
		if (!strchr(freename,'@') && 
		    !strchr(freename,'%') && 
		    strncasecmp(freename,rfcfrom,MAXNAME) &&
		    strncasecmp(freename,"uucp",4) &&
		    strncasecmp(freename,"usenet",6) &&
		    strncasecmp(freename,"news",4) &&
		    strncasecmp(freename,"super",5) &&
		    strncasecmp(freename,"admin",5) &&
		    strncasecmp(freename,"system",6)) 
			registrate(freename,rfcfrom);
	}

	debug(3,"From address was%s distinguished as ftn",
		tmsg->from ? "" : " not");

	if ((tmsg->from == NULL) && (bestaka))
	{
		tmsg->from=(faddr *)xmalloc(sizeof(faddr));
		tmsg->from->name=xstrcpy(freename);
		if (strlen(tmsg->from->name) > MAXNAME)
			tmsg->from->name[MAXNAME]='\0';
		tmsg->from->point=bestaka->point;
		tmsg->from->node=bestaka->node;
		tmsg->from->net=bestaka->net;
		tmsg->from->zone=bestaka->zone;
		tmsg->from->domain=xstrcpy(bestaka->domain);
	}

	if (fbuf) free(fbuf); fbuf=NULL;

	p=hdr("Subject",msg);
	if (p)
	{
		while (isspace(*p)) p++;
		tmsg->subj=xstrcpy(p);
		if (*(p=tmsg->subj+strlen(tmsg->subj)-1) == '\n') *p='\0';
		if (strlen(tmsg->subj) > MAXSUBJ) tmsg->subj[MAXSUBJ]='\0';
	}
	else tmsg->subj=xstrcpy(" ");

	debug(3,"SUBJ: \"%s\"",tmsg->subj);

	if ((p=hdr("X-FTN-FLAGS",msg))) setflags(tmsg,p);
	if (hdr("Return-Receipt-To",msg)) tmsg->flags |= RRQ;
	if (!newsmode)
	{
		tmsg->flags |= PVT;
		tmsg->flags |= K_S;
	}

	tmsg->msgid=ftnmsgid(hdr("Message-ID",msg));

	if ((p=hdr("In-Reply-To",msg)) == NULL)
	{
		p=hdr("References",msg);
		if (p)
		{
			for (r=p+strlen(p); (*r != ' ') && (r >= p); r--);
			p=r;
		}
	}
	if (p) tmsg->reply=ftnmsgid(p);

	if ((p=hdr("Date",msg))) 
		tmsg->date=ftndate(parsedate(p,NULL));
	else tmsg->date=ftndate(time((time_t *)NULL));

	debug(3,"DATE: %s, MSGID: %s, REPLY: %s",
		tmsg->date,tmsg->msgid,tmsg->reply);

	if ((p=hdr("Organization",msg)))
	{
		while (isspace(*p)) p++;
		tmsg->origin=xstrcpy(p);
		if (*(p=tmsg->origin+strlen(tmsg->origin)-1) == '\n') *p='\0';
	}

	debug(3,"ORIGIN: %s",tmsg->origin);

	return tmsg;
}
