#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/wait.h>
#include "lutil.h"

#define SHELL "/bin/sh"

int execsh(cmd,in,out,err)
char *cmd,*in,*out,*err;
{
	int pid,status,rc;

	loginf("Execute command: %s",cmd);
	fflush(stdout);
	fflush(stderr);
	if ((pid=fork()) == 0)
	{
		if (in)
		{
			close(0);
			if (open(in,O_RDONLY) != 0)
			{
				logerr("$Reopen of stdin to %s failed",in);
				exit(-1);
			}
		}
		if (out)
		{
			close(1);
			if (open(out,O_WRONLY | O_APPEND | O_CREAT,0600) != 1)
			{
				logerr("$Reopen of stdout to %s failed",out);
				exit(-1);
			}
		}
		if (err)
		{
			close(2);
			if (open(err,O_WRONLY | O_APPEND | O_CREAT,0600) != 2)
			{
				logerr("$Reopen of stderr to %s failed",err);
				exit(-1);
			}
		}
		rc=execl(SHELL,"sh","-c",cmd,NULL);
		logerr("$Exec \"%s\" returned %d",cmd,rc);
		exit(-1);
	}
	while (((rc=wait(&status)) != pid) && ((rc=wait(&status)) != 0))
		logerr("$Wait returned %d, status %d,%d",rc,status>>8,status&0xff);
	if ((status&0xff) == 0) rc=status>>8;
	else rc=status&0xff;
	debug(2,"rc=%d",rc);
	return rc;
}
