/* This module hopefully implements BinkleyTerm packet naming conventions */

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <time.h>
#include "lutil.h"
#include "xutil.h"
#include "ftn.h"
#include "config.h"

#ifndef PATH_MAX
#define PATH_MAX 256
#endif
#define ptyp "ut"
#define ftyp "lo"
#define rtyp "req"
#define styp "spl"
#define btyp "bsy"

extern unsigned long sequencer(void);

static char buf[PATH_MAX];

static char *prepbuf(faddr*);
static char *prepbuf(addr)
faddr *addr;
{
	char *p,*domain=NULL;
	char zpref[8];
	fa_list *tmpl;

	strcpy(buf,outbound);

	if (addr->domain) domain=addr->domain;
	else for (tmpl=nllist;tmpl;tmpl=tmpl->next)
		if (tmpl->addr->zone == addr->zone)
		{
			domain=tmpl->addr->domain;
			break;
		}
	debug(3,"using domain \"%s\" for outbound",domain?domain:"<null>");
	if ((domain != NULL) && (whoami->addr->domain != NULL) &&
	    (strcasecmp(domain,whoami->addr->domain) != 0))
	{
		debug(3,"this is not our primary domain");
		if ((p=strrchr(buf,'/'))) p++;
		else p=buf;
		strcpy(p,domain);
		for (;*p;p++) *p=tolower(*p);
		for (tmpl=nllist;tmpl;tmpl=tmpl->next)
			if ((tmpl->addr->domain) &&
			    (strcasecmp(tmpl->addr->domain,domain) == 0))
				break;
		if (tmpl && (tmpl->addr->zone == addr->zone))
			zpref[0]='\0';
		else sprintf(zpref,".%03x",addr->zone);
	}
	else /* this is our primary domain */
	{
		debug(3,"this is our primary domain");
		if ((addr->zone == 0) || (addr->zone == whoami->addr->zone))
			zpref[0]='\0';
		else sprintf(zpref,".%03x",addr->zone);
	}

	p=buf+strlen(buf);

	if (addr->point)
		sprintf(p,"%s/%04x%04x.pnt/%08x.",
			zpref,addr->net,addr->node,addr->point);
	else
		sprintf(p,"%s/%04x%04x.",zpref,addr->net,addr->node);

	p=buf+strlen(buf);
	return p;
}

char *pktname(addr,flavor)
faddr *addr;
char flavor;
{
	char *p;

	if (is_local(addr))
	{
		debug(3,"local address, put packet into inbound");
		strncpy(buf,inbound,sizeof(buf)-10);
		sprintf(buf+strlen(buf),"/%08lx.pkt",sequencer());
	}
	else
	{
		p=prepbuf(addr);
		if (flavor == 'f') flavor='o';
		sprintf(p,"%c%s",flavor,ptyp);
	}
	debug(3,"packet name is \"%s\"",buf);
	return buf;
}

char *floname(addr,flavor)
faddr *addr;
char flavor;
{
	char *p;

	p=prepbuf(addr);
	if (flavor == 'o') flavor='f';
	sprintf(p,"%c%s",flavor,ftyp);
	debug(3,"flo file name is \"%s\"",buf);
	return buf;
}

char *reqname(addr,flavor)
faddr *addr;
char flavor;
{
	char *p;

	p=prepbuf(addr);
	if (flavor == 'o') flavor='f'; /* in fact this is ignored for reqs */
	sprintf(p,"%s",rtyp);
	debug(3,"req file name is \"%s\"",buf);
	return buf;
}

char *splname(addr,flavor)
faddr *addr;
char flavor;
{
	char *p;

	p=prepbuf(addr);
	if (flavor == 'o') flavor='f'; /* in fact this is ignored for spls */
	sprintf(p,"%s",styp);
	debug(3,"spl file name is \"%s\"",buf);
	return buf;
}

char *bsyname(addr,flavor)
faddr *addr;
char flavor;
{
	char *p;

	p=prepbuf(addr);
	if (flavor == 'o') flavor='f'; /* in fact this is ignored for bsys */
	sprintf(p,"%s",btyp);
	debug(3,"bsy file name is \"%s\"",buf);
	return buf;
}

static char *dow[] = {"su","mo","tu","we","th","fr","sa"};

char *arcname(addr,flavor)
faddr *addr;
char flavor;
{
	char *p;
	char *ext;
	time_t tt;
	struct tm *ptm;
	faddr *bestaka;

	(void)time(&tt);
	ptm=localtime(&tt);
	ext=dow[ptm->tm_wday];

	bestaka=bestaka_s(addr);

	(void)prepbuf(addr);
	p=strrchr(buf,'/');
	if (addr->point)
	{
		sprintf(p,"/%04x%04x.%s0",
			addr->net & 0xffff,
			addr->node & 0xffff,
			ext);
	}
	else
	{
		sprintf(p,"/%04x%04x.%s0",
			((bestaka->net) - (addr->net)) & 0xffff,
			((bestaka->node) - (addr->node) +
				(bestaka->point)) & 0xffff,
			ext);
	}
	debug(3,"arc file name is \"%s\" (flavor '%c' ignored)",buf,flavor);
	return buf;
}
