#!/bin/sh
#
# differ.sh		-	Make nodediffs
#
# $Header$
#
# (c)1994 Cees de Groot
#
# Description:
#	This script uses the IFmail configuration file to find any nodediffs,
#	and creates the new nodelists if necessary. 
#
# Copyright stuff:
#	Don't want to include the complete legal shit here, but the GNU Public
#	License, Version 2 or later, applies.
#
# Comments:
#	You'd better be sure the correct set of nodelists is there. It expects
#	exactly one nodelist, and a number of nodediffs. It applies all 
#	nodediffs to the nodelist, leaving only the new nodelist. Error checking
#	probably needs some extra attention...

#
# Configuration file we need to browse and the nodelist editor
#
IFconfig=/usr/fido/lib/ifmail/config
NLedit=/usr/fido/bin/nledit

#
# Get the nodelists
#
Nodelists=`awk '/^nodelist/ { print $2}' $IFconfig`

#
# Get the nodediffs. He? Yes, we get it from the config file. Please
# make sure you use the same order...
#
Nodediffs=`awk '/^#nodediff/ { print $2}' $IFconfig`
set - $Nodediffs

#
# Walk through the nodelists. We use the path from the first nodelist,
# like IFmail does
#
oldPath=`pwd`
for curList in $Nodelists
do
	if [ -z "$nlPath" ]
	then
		nlPath=`dirname $curList`
		cd $nlPath
		curList=`basename $curList`
	fi
	oldList=`echo $curList.[0-9][0-9][0-9]`

	#
	# Now for the hard stuff: find out the diffs. 
	#
	curDiff=$1
	shift
	echo "Trying to diff $oldList with $curDiff"

	diffCandidates=`echo $curDiff.[0-9][0-9][0-9] | sort`
	if [ "$diffCandidates" != $curDiff'.[0-9][0-9][0-9]' ]
	then
		#
		# Process all candidates in order. We assume the correct diffs
		# are there.
		#
		for curCand in $diffCandidates
		do
			#
			# Get the new nodelist name from the nodelist and the
			# diff name
			#
			newList=$curList`echo $curCand|sed "s/$curDiff//"`
			echo "Applying diff : $oldList -> $curCand -> $newList"
			$NLedit $oldList $curCand $newList
			rm $oldList $curCand 
			oldList=$newList
		done
	fi
done

cd $oldPath
