/*
    Simple window management file
    Copyright (c) Tudor Hulubei & Andrei Pitis, May 1994

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdio.h>
#include <malloc.h>
#include "tty.h"
#include "window.h"


window *window_init(int _startx, int _starty, int _rows, int _columns)
{
    window *this  = (window *)malloc(sizeof(window));
    this->startx  = _startx;
    this->starty  = _starty;
    this->rows    = _rows;
    this->columns = _columns;
    this->cursorx = this->cursory = 0; 
    return this;   
}


int window_write(char *str, int length)
{
    return tty_write(str, length);
}


int window_putch(char c)
{
    return tty_write(&c, 1);
}


void window_cursormove(window *this, int y, int x)
{
    tty_cursormove(y + this->starty, x + this->startx);
}
