.\" Filesystem Hierarchy Standard	-*- nroff -*-
.ig

Copyright (C) 1994, 1995, 1996 Daniel Quinlan, Daniel.Quinlan@linux.org

See below for complete copying terms.

Time-stamp: <96/04/11 16:25:26 quinlan>

TODO:

- "THIS IS ONLY A DRAFT" in page margin?
- Karl Berry, TeX
- remove /var/local or RATIONALE it over /usr/local/var, which is
  the GNU configure default
- New FAQ, FAQ maintainer are needed
- well designed, well planned, memory based - hyphens?
- FTP reference for FHS, FAQ, other documents -> appendix?
- describe { ... } notation or adopt a simple list "cat chgrp chmod ..."
- small caps for FHS, UNIX, etc?
- discuss differences between us and GNU Coding Standards

Release checklist:

 * Is the status and title correct?
 * Update the time-stamp and page header.
 * Check comments.

This document is typeset using GNU groff 1.09 with mm macros and is
preprocessed with pic and tbl.

Notes on writing troff for this document:

 * Use any defined strings listed in the header (.ds) such as "Fs"
   for FHS.
 * Encase all filenames in constant width font like \f(CWfile\fP, but
   do not encase any punctuation.
 * Use \% for any filenames with dashes to prevent hyphenation.  Like
   \f(CW\%/pub/device-list\fP.
 * Use comments if you aren't certain or want to make an editorial
   comment that doesn't need to be printed.
 * Use the language described in RFC 1123, section 1.3.2 (Requirements)
   for this document.
 * Log all changes via an Emacs ChangeLog

..
.nr Cl 2
.nr Hu 3
.nr Hy 0
.\" predefined strings
.ds Fs FHS
.ds Ux UNIX
.PGNH
.PH "'Filesystem Hierarchy Standard''February 10, 1996'"
.SA 0
.ie t \{\
.PGFORM 6i 10.5i 1.25i
.ds HF B B B B B B B
.ds HP 14 12 12 10 10 10 10
.ds Lx L\h'-.3m'\v'-.3m'\s-3A\s0\v'+.3m'T\h'-.2m'\v'+.3m'E\h'-.1m'\v'-.3m'X
.ds Tx T\h'-.2m'\v'+.3m'E\h'-.0m'\v'-.3m'X
\}
.el \{\
.PGFORM 7.2i 11i
.ds Lx LaTeX
.ds Tx TeX
\}
.COVER ms
.TL
Filesystem Hierarchy Standard \(em Draft 5
.AF "\fIedited by Daniel Quinlan\fP"
.AU "\fRFilesystem Hierarchy Standard Group\fP"
.AS 0 5
.nh
.P 1
This standard develops a set of requirements and guidelines for file and
directory placement under \*(Ux-like operating systems.  The guidelines
are intended to support interoperability of applications, system
administration tools, development tools, and scripts.
.AE
.COVEND
.SK
.\" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
.nh
.nr % 1
.af P i
.PF "''- \\\\nP -''"
.\" According to rms, there is no legal requirement to acknowledge
.\" trademarks by printing them so these could be removed.
Linux is not a trademark, and has no connection to \*(Ux.

\*(Ux is a trademark of the X/Open Company, Ltd.

HP-UX is a trademark of Hewlett-Packard.

Novell and Novell NetWare are trademarks of Novell.

SunOS, Sun Microsystems, Sun NIS, Sun RPC, and NFS are trademarks of Sun
Microsystems, Inc.

System V and SVR4 are trademarks of AT&T.

X Window System is a trademark of X Consortium, Inc.

All other copyrights are owned by their owners, unless specifically
noted otherwise.  Use of a term in this document should not be regarded
as affecting the validity of any trademark or service mark.
.BS
Copyright \(co 1994, 1995, 1996 Daniel Quinlan

Permission is granted to make and distribute verbatim copies of this
standard provided the copyright and this permission notice are preserved
on all copies.

.ig
Permission is granted to process this file through a typesetter (such as
troff) and print the results, provided the printed document carries a
permission notice identical to this one except for the removal of this
paragraph (this paragraph not being relevant to the printed document).

..
Permission is granted to copy and distribute modified versions of this
standard under the conditions for verbatim copying, provided also that
the title page is labeled as modified including a reference to the
original standard, provided that information on retrieving the original
standard is included, and provided that the entire resulting derived
work is distributed under the terms of a permission notice identical to
this one.
.BE
.SK
.\" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
.BS
.BE
.nr % 1
.af P 1
.nr Hu 4
.H 1 "Introduction"
.\" I would like to end up with these sub-sections in the introduction:
.\" (moving some things from general to here)
.\"
.\" Statement of General purpose (or is that the abstract?)
.\"
.\" - Organization
.\" - Base Documents, if any
.\" - Background (History)
.\" - Audience
.\" - Purpose (Objectives)
.\"   - basic principles (possible to have read-only /usr, etc.)
.\"     including: broadly implementable, minimal changes to historic
.\"     implementions, minimal changes to existing implementations
.\" - Related Standards

.H 2 "Status of the Standard"
.P
This proposed standard is currently being distributed for review and
comment.

Comments on this draft are welcome from any interested party.
Suggestions for changes in documents should be in the form of a proposed
change of text, together with appropriate supporting comments.

The guidelines in this draft are subject to change.  Use of information
contained in this document is at your own risk.

.H 2 "Organization of the Standard"
.P
This standard is divided into 5 sections:
.AL 1
.LI
Introduction
.LI
The Filesystem: a statement of some guiding principles.
.LI
The Root Directory.
.LI
The \f(CW/usr\fP Hierarchy.
.LI
The \f(CW/var\fP Hierarchy.
.LE

.H 2 "Conventions"
.P
.ie t \{\
\f(CWCourier\fP font is used for the names of files and directories.
\}
.el \{\
We recommend that you read a typeset version of this document rather
than the plain text version.  In the typeset version, the names of files
and directories are set in Courier font.
\}

Components of filenames that vary are represented by a description of
the contents enclosed in "\f(CW<\fP" and "\f(CW>\fP" characters,
\f(CW<thus>\fP.  Electronic mail addresses are also enclosed in "<" and
">" but are shown in the usual typeface.

Optional components of filenames are enclosed in "\f(CW[\fP" and
"\f(CW]\fP" characters and may be combined with the "\f(CW<\fP" and
"\f(CW>\fP" convention.  For example, if a file existed which could be
either be found either with or without an extension, it might be
represented by \f(CW<filename>[.<extension>]\fP.

Variable substrings of directory names and filenames are indicated by
"\f(CW*\fP".
.SK
.H 2 "Background of the FHS"
.P
The process of developing a standard filesystem hierarchy began in
August 1993 with an effort to restructure the file and directory
structure of Linux.  The FSSTND, a filesystem hierarchy standard
specific to the Linux operating system, was released in February 14,
1994.  Subsequent revisions were released on October 9, 1994 and March
28, 1995.

In early 1995, the goal of developing a more comprehensive version of
FSSTND to address not only Linux, but other \*(Ux-like systems was
adopted in conjunction with representatives of the BSD development
community.  As a result, a concerted effort was made to focus on issues
that were general to \*(Ux-like systems.  In recognition of this
widening of scope, the name of the standard (and the mailing list) was
changed to \*(Fs.

Volunteers who have contributed extensively to this standard are listed
at the end of this document.  This standard represents a consensus view
of those and other contributors.

.H 2 "Scope"
.P
This document specifies a standard filesystem hierarchy for \*(Fs
filesystems by specifying the location of files and directories, and the
contents of some system files.

This standard has been designed to be used by system integrators,
package developers, and system administrators in the construction and
maintain ence of \*(Fs compliant filesystems.  It is primarily intended
to be a reference and is not a tutorial on how to manage a conforming
filesystem hierarchy.

The \*(Fs grew out of earlier work on FSSTND, a filesystem organization
standard for the Linux operating system.  It builds on FSSTND to address
interoperability issues not just in the Linux community but in a wider
arena including 4.4BSD-based operating systems.  It incorporates lessons
learned in the BSD world and elsewhere about multi-architecture support
and the demands of heterogeneous networking.

Although this standard is more comprehensive and complete than any other
previous attempt at file hierarchy standardization, updates may become
periodically become necessary.  The needs of the community will
continually change in relation to emerging technology.  It is also
possible that better solutions to the problems we address will be
discovered or that our solutions will no longer be the best possible
solutions.  For these reasons, the \*(Fs group plans to release
supplementary drafts in addition to periodic updates to this document.
However, a specific goal is backwards compatibility from one release of
this document to the next.

Comments related to this standard are welcomed by the \*(Fs group.  Any
comments or suggestions for changes should be directed to the \*(Fs
editor, or if you prefer, any of the listed contributors.  Typographical
or grammatical comments should be directed to the \*(Fs editor.

Please do not send mail to the mailing list without first contacting the
\*(Fs editor or a listed contributor.  Improper messages will not be
well-received on the mailing list.

Questions about how to interpret items in this document may occasionally
arise.  If you have need for a clarification, please contact the \*(Fs
editor.  Since this standard represents a consensus of many
participants, it is important to make certain that any interpretation
also represents their collective opinion.  For this reason it may not be
possible to provide an immediate response unless the inquiry has been
the subject of previous discussion.

.H 2 "Objectives"
.P
In trying to solve the problems above, several objectives were
identified that needed to be achieved in addition to the more technical
matters.  These goals comprise the correction of outstanding problems as
well as the validation of this standard.
.BL
.LI
Solve the problems listed above while limiting transitional difficulties
consequent upon moving away from the former de-facto standards.
.LI
Gain approval of distributors, developers, and other important people in
the Linux and BSD communities, as well as encouraging them to give us
their suggestions.
.LI
Provide a standard that the whole Linux and BSD community will choose to
follow because it solves the problems above and provides the most
sensible structure for the filesystems of \*(Ux-like systems.
.LE
.P
Some of these objectives have already been fully or partially met by
the limited distribution of an advance draft to any developer who
requested one.

.H 2 "Conformance with this Document"
.P
This section defines the meanings of the terms "compliant" and
"compatible" with respect to this standard, and of "partial" compliance
and conformance.

An "implementation" here refers to a distribution, an installed system,
a program, a package (or some similar piece of software or data), or
some component thereof.

An implementation is fully compliant with this standard if every
requirement in this standard is met.  Every file or directory which is
part of the implementation must be located as specified in this
document.  If the contents of a file are described here the actual
contents must correspond to the description.  The implementation must
also attempt to find any files or directories (external to itself)
primarily or exclusively in the location specified in this standard.
.\" awkward

An implementation is fully compatible with this standard if every file
or directory which it contains can be found by looking in the location
specified here and will be found with the contents as specified here,
even if that is not the primary or physical location of the file or
directory in question.  The implementation must, when it attempts to
find any files or directories which are not part of it, do so in the
location specified in this standard, though it may also attempt to find
it in other (non-standard) locations.

An implementation is partially compliant or compatible if it complies
with or is compatible with a significant subset of this document.
Partial compliance or compatibility is only intended to apply to
distributions and not to separate programs.  The phrase "a significant
subset" is admittedly subjective, and in borderline cases, the concerned
party should contact the \*(Fs coordinator.  It is anticipated
that some variation will be tolerated in borderline cases.

To qualify as partially \*(Fs compliant or partially \*(Fs compatible an
implementation must provide a list of all places at which it and the
\*(Fs document differ in addition to a brief explanation of the
reasoning for this difference.  This list shall be provided with the
implementation in question, and also made available to the \*(Fs mailing
list or the \*(Fs editor.

The terms "must", "should", "contains", "is" and so forth should be read
as requirements for compliance or compatibility.

Note that an implementation does not need to contain all the files and
directories specified in this standard to be compliant or compatible.
It is merely necessary for those files that it does contain to be
located appropriately.  For example, if the minix filesystem is not
supported by a distribution, the minix tools need not be included, even
though they are mentioned explicitly in the section on \f(CW/sbin\fP.

Furthermore, certain portions of this document are optional.  In this
case this will be stated explicitly, or indicated with the use of one or
more of "may", "recommend", or "suggest".  Items marked as optional have
no bearing on the compliance or conformance of an implementation; they
are suggestions meant to encourage common practice, but may be located
anywhere at the implementor's choice.
.SK
.H 1 "The Filesystem"
.P
The \*(Ux filesystem is characterized by:
.BL
.LI
A hierarchical structure
.LI
Consistent treatment of file data
.LI
Protection of file data
.LE
.P
This standard assumes that the operating system underlying an
\*(Fs-compliant file system supports the same basic security features
found in most \*(Ux filesystems.  Note that this standard does not
attempt to agree in every possible respect with any particular \*(Ux
system's implementation.  However, many aspects of this standard are
based on ideas found in \*(Ux and other \*(Ux-like systems.

This is after careful consideration of other factors, including:
.BL
.LI
Common and sound practices in the Linux and BSD communities
.\" XXX - again!
.LI
The implementation of other filesystem structures
.LI
Applicable standards
.LE
.P
It is possible to define two orthogonal categories of files:
shareable vs. unshareable and variable vs. static.
.\" categories/categorizations and files/file-data

Shareable data is that which can be shared between several different
hosts; unshareable is that which must be specific to a particular host.
For example, user home directories are shareable data, but device lock
files are not.

Static data includes binaries, libraries, documentation, and anything
that does not change without system administrator intervention; variable
data is anything else that does change without system administrator
intervention.

Throughout this document, and in any well-planned filesystem, an
understanding of these basic principles will help guide the structure
and lend it additional consistency.

The distinction between shareable and unshareable data is needed for
several reasons:
.BL
.LI
In a networked environment (i.e., more than one host at a site), there
is a good deal of data that can be shared between different hosts to
save space and ease the task of maintenance.
.LI
In a networked environment, certain files contain information specific
to a single host.  Therefore these filesystems cannot be shared
(without taking special measures).
.LI
Historical implementations of Linux and BSD filesystems did not allow the
\f(CW/usr\fP hierarchy to be mounted read-only because it contained
files and directories that need to be written to often.  This is a
factor that must be addressed when parts of \f(CW/usr\fP are shared on a
network or mounted read-only because of other considerations such as
security.
.LE

The "shareable" distinction can be used to support, for example:
.BL
.LI
A \f(CW/usr\fP partition (or components of \f(CW/usr\fP) mounted
(read-only) through the network (using NFS).
.LI
A \f(CW/usr\fP partition (or components of \f(CW/usr\fP) mounted from
read-only media.  A CD-ROM can be considered a read-only filesystem
shared with other \*(Fs-compliant systems, using the postal mail system
as a ``network''.
.\" XXX did ``that'' work?
.LE
.P
The "static" versus "variable" distinction affects the
filesystem in two major ways:
.BL
.LI
Since \f(CW/\fP contains both variable and static data, it needs to be mounted
read-write.
.LI
Since the traditional \f(CW/usr\fP contains both variable and static data, and
since we may want to mount it read-only (see above), it is necessary to
provide a method to have \f(CW/usr\fP mounted read-only.  This is done through
the creation of a \f(CW/var\fP hierarchy that is mounted read-write (or is a
part of another read-write partition, such as \f(CW/)\fP, taking over much of
the \f(CW/usr\fP partition's traditional functionality.
.LE

Summarizing chart with examples:
.TS
box,center;
l | l | l.
	shareable	unshareable
_
static	/usr	/etc
	/opt	/boot
_
variable	/var/mail	/var/run
	/var/spool/news	/var/lock
.TE
.SK
.H 1 "The Root Directory"
.P
This section describes the root directory structure.  The contents of
the root filesystem should be adequate to boot, restore, recover, and/or
repair the system:
.BL
.LI
To boot a system, enough must be present to mount \f(CW/usr\fP and other
non-essential parts of the filesystem.  This includes utilities,
configuration, boot loader information, and other essential start-up
data.
.LI
To enable recovery and/or repair of a system, those utilities needed by
an experienced maintainer to diagnose and reconstruct a damaged system
should be present on the root filesystem.
.LI
To restore a system, those utilities needed to restore from system
backups (on floppy, tape, etc.) should be present on the root
filesystem.
.LE
.P
The primary concern used to balance these considerations, which favor
placing many things on the root filesystem, is the goal of keeping
root as small as reasonably possible.  For several reasons, it is
desirable to keep the root filesystem small:
.BL
.LI
It is occasionally mounted from very small media.
.LI
The root filesystem has many system-specific configuration files in it.
Possible examples include a kernel that is specific to the system, a
different hostname, etc.  This means that the root filesystem isn't
always shareable between networked systems.  Keeping it small on
networked systems minimizes the amount of space lost on servers to
unshareable files.  It also allows workstations with smaller local hard
drives.
.LI
While you may have the root filesystem on a large partition, and may be
able to fill it to your heart's content, there will be people with
smaller partitions.  If you have more files installed, you may find
incompatibilities with other systems using root filesystems on smaller
partitions.  If you are a developer then you may be turning your
assumption into a problem for a large number of users.
.LI
Disk errors that corrupt data on the root filesystem are a greater
problem than errors on any other partition.  A small root filesystem is
less prone to corruption as the result of a system crash.
.LE
.P
Software should never create or require special files or subdirectories
in the root directory.  Other locations in the \*(Fs hierarchy provide
more than enough flexibility for any package.
.HU "BEGIN RATIONALE"
.br
.P
There are several reasons why using a root subdirectory is prohibited.
.BL
.LI
It demands space on a root partition which the system administrator may
want kept small and simple for either performance or security reasons.
.LI
It evades whatever discipline the system administrator may have set up
for distributing standard file hierarchies across mountable volumes.
.LE
.HU "END RATIONALE"

.PS
copy "draft.pic"
dir(/,the root directory)
sub("bin","Essential command binaries")
sub("boot","Static files of the boot loader")
sub("dev","Device files")
sub("etc","Host-specific system configuration")
sub("home","User home directories")
sub("lib","Shared libraries")
sub("mnt","Mount point of temporary partitions")
sub("opt","Add-on application software packages")
sub("proc","Process information pseudo-filesystem")
sub("root","Home directory for the root user")
sub("sbin","Essential system binaries")
sub("tmp","Temporary files")
sub("usr","Secondary hierarchy")
sub("var","Variable data")
.PE

Each directory listed above is specified in detail in separate
subsections below.  \f(CW/usr\fP and \f(CW/var\fP each have a complete
section in this document due to the complexity of those directories.

The operating system kernel image should be located in either \f(CW/\fP
or \f(CW/boot\fP.  Additional information on kernel placement can be
found in the section regarding \f(CW/boot\fP, below.

On Linux systems, if the kernel is located in \f(CW/\fP, we recommend
using the names \f(CWvmlinux\fP or \f(CWvmlinuz\fP, which have been used
in recent Linux kernel source packages.

.H 2 "/bin : Essential user command binaries (for use by all users)"
.P
\f(CW/bin\fP contains commands that may be used by both the system
administrator and by users, but which are required in single user mode.
It may also contain commands which are used indirectly by scripts.

All root-only binaries such as daemons, \f(CWinit\fP, \f(CWgetty\fP,
\f(CWupdate\fP, etc. should be placed in \f(CW/sbin\fP or
\f(CW/usr/sbin\fP, depending on whether they are essential.

There should be no subdirectories within \f(CW/bin\fP.

Command binaries that are not essential enough to place into
\f(CW/bin\fP should be placed in \f(CW/usr/bin\fP, instead.  Items that
are only used by non-root users (\f(CWmail\fP, \f(CWchsh\fP, etc.) are
not essential enough to be placed into the root partition.

.HU "Required files for /bin:"
.BL
.LI
General commands:
.sp
The following commands have been included because they are essential.  A
few are present because of their traditional placement in \f(CW/bin\fP.
.VL 2
.LI "\f(CW{"
cat, chgrp, chmod, chown, cp, date, dd, df, dmesg, echo, ed,
false, kill, ln, login, ls, mkdir, mknod, more, mount, mv, ps, pwd, rm,
rmdir, sed, setserial, sh, stty, su, sync, true, umount, uname }\fP
.LE
.P
If \f(CW/bin/sh\fP is Bash, then \f(CW/bin/sh\fP should be a symbolic or
hard link to \f(CW/bin/bash\fP since Bash behaves differently when
called as \f(CWsh\fP or \f(CWbash\fP.  \f(CWpdksh\fP, which may be the
\f(CW/bin/sh\fP on install disks, should likewise be arranged with
\f(CW/bin/sh\fP being a symlink to \f(CW/bin/ksh\fP.  The use of a
symbolic link in these cases allows users to easily see that
\f(CW/bin/sh\fP is not a true Bourne shell.

Since the de-facto standard location of the C-shell is \f(CW/bin/csh\fP,
if and only if a C-shell or equivalent (such as \f(CWtcsh\fP) is
available on the system, it should be available by the name
\f(CW/bin/csh\fP.  \f(CW/bin/csh\fP may be a symbolic link to
\f(CW/bin/tcsh\fP or \f(CW/usr/bin/tcsh\fP.

The \f(CW[\fP and \f(CWtest\fP commands are built into Bash, pdksh, zsh,
and recent Korn shells \(em essentially every Bourne shell replacement
there is for Linux.  These commands should be placed into
\f(CW/usr/bin\fP.  (They must be included as separate binaries with any
Linux system attempting to comply with the POSIX.2 standard.)

.LI
Restoration commands:
.sp
These commands have been added to make restoration of a system possible
(provided that \f(CW/\fP is intact).
.VL 2
.LI "\f(CW{"
tar, gzip, gunzip \fR(link to gzip)\fP, zcat \fR(link to gzip)\fP }\fP
.LE
.P
If system backups are made using programs other than \f(CWgzip\fP and
\f(CWtar\fP, then the root partition should contain the minimal
necessary restoration components.  For instance, many systems should
include \f(CWcpio\fP as it is the next most commonly used backup utility
after \f(CWtar\fP.  Conversely, if no restoration from the root
partition is ever expected, then these binaries may be omitted (i.e., a
ROM chip root, mounting \f(CW/usr\fP through NFS).  If restoration of a
system is planned through the network, then \f(CWftp\fP or \f(CWtftp\fP
(along with everything necessary to get a ftp connection) should be
available on the root partition.

Restoration commands may appear in either \f(CW/bin\fP or
\f(CW/usr/bin\fP on different systems.

.LI
Networking commands:
.sp
These are the only necessary networking binaries that both root and
users will want or need to execute other than the ones in
\f(CW/usr/bin\fP or \f(CW/usr/local/bin\fP.
.VL 2
.LI "\f(CW{"
domainname, hostname, netstat, ping }\fP
.LE
.LE

.H 2 "/boot : Static files of the boot loader"
.P
This directory contains everything required for the boot process except
configuration files and the map installer.  Thus
\f(CW/boot\fP is for anything which is used before the kernel execs
\f(CW/sbin/init\fP.  This includes saved master boot sectors, sector map
files, and anything else that is not directly edited by hand.  Programs
necessary to arrange for the boot loader to be able to boot a file
should be placed in \f(CW/sbin\fP.  Configuration files for boot loaders
should be placed in \f(CW/etc\fP.

The operating system kernel should be located either in \f(CW/\fP or in
\f(CW/boot\fP.

.ft I
Note: On some i386 machines, it may be necessary for \f(CW/boot\fP to be
located on a separate partition below cylinder 1024 of the boot device
due to hardware constraints.
.ft P

.H 2 "/dev : Device files"
.P
The \f(CW/dev\fP directory is the location of special or device files.

If it is possible that devices in \f(CW/dev\fP will need to be manually
created, \f(CW/dev\fP shall contain a command named \f(CWMAKEDEV\fP,
which can create devices as needed.  It may also contain a
\f(CWMAKEDEV.local\fP for any local devices.

If required, \f(CWMAKEDEV\fP should have provisions for creating any
device that may be found on the system, not just those that a particular
implementation installs.

For Linux systems, this standard incorporates by reference the Linux
Device List which is maintained by H. Peter Anvin
<Peter.Anvin@linux.org>, the Linux Device Registrar.  All device special
files should follow the standard in that document, which is available
with the Linux kernel documentation.

Symbolic links in \f(CW/dev\fP should not be distributed with Linux
systems except as provided in the Linux device list. \*(Fs does not yet
attempt to prescribe BSD practice in this regard, though that may change
if the BSD community develops a consensus standard that can be
incorporated in \*(Fs by reference.

.HU "BEGIN RATIONALE"
.br
.P
The requirement not to make symlinks promiscuously is made because local
setups will often differ from that on the distributor's development
machine.  Also, if a distribution install script configures the symbolic
links at install time, these symlinks will often not get updated if
local changes are made in hardware.  When used responsibly at a local
level, however, they can be put to good use.
.HU "END RATIONALE"

.H 2 "/etc : Host-specific system configuration"
.P
\f(CW/etc\fP contains configuration files and directories, which are
specific to the current system.

No binaries should go directly into \f(CW/etc\fP.  Binaries that might
in the past have been found in \f(CW/etc\fP should be placed in
\f(CW/sbin\fP or \f(CW/usr/sbin\fP.  This includes such files as
\f(CWinit\fP, \f(CWgetty\fP, and \f(CWupdate\fP.  Binaries such as
\f(CWhostname\fP that are used by ordinary users as well as the root
user should not be placed in \f(CW/sbin\fP but in \f(CW/bin\fP.

.PS
copy "draft.pic"
dir(/etc,Host-specific system configuration)
sub("X11","Configuration for the X Window System")
sub("opt","Configuration for /opt")
.PE

The following section is intended partly to illuminate the description
of the contents of \f(CW/etc\fP with a number of examples; it is
definitely not an exhaustive list.

.HU "Required files for /etc:"
.BL
.LI
General files:
.sp
These files are needed on most systems.
.VL 2
.LI "\f(CW{"
adjtime, csh.login, disktab, fdprm, fstab, gettydefs, group, inittab,
issue, ld.so.conf, lilo.conf, motd, mtab, mtools, passwd,
profile, psdatabase, securetty, shells, syslog.conf, ttytype }\fP
.\" XXX - { magic, termcap } was moved to /usr/share/misc
.LE

.LI
Networking files:
.sp
These files should be installed on most systems.
.VL 2
.LI "\f(CW{"
exports, ftpusers, gateways, hosts, host.conf, hosts.equiv,
hosts.lpd, inetd.conf, networks, printcap, protocols, resolv.conf, rpc,
services }\fP
.LE
.P
There are two models for setup of the "rc" command scripts which are
invoked by \f(CWinit(8)\fP at boot time, the \f(CW/etc/rc.*\fP BSD model
and the \f(CW/etc/rc.d/*\fP System V model.  Either model may be used,
or a mixture of the two.

Systems that use the shadow password suite will have additional
configuration files in \f(CW/etc\fP (\f(CW/etc/shadow\fP and others) and
programs in \f(CW/usr/sbin\fP (\f(CWuseradd\fP, \f(CWusermod\fP, and
others).
.LE

.H 3 "/etc/X11 : Configuration for the X Window System"
.sp 0
.P
\f(CW/etc/X11\fP is the recommended location for all X11 host-specific
configuration.  This directory is necessary to allow local control if
\f(CW/usr\fP is mounted read only.  Files that should be in this
directory include \f(CWXconfig\fP (and/or \f(CWXF86Config\fP) and
\f(CWXmodmap\fP.

Subdirectories of \f(CW/etc/X11\fP may include those for \f(CWxdm\fP and
for any other programs (some window managers, for example) that need
them.  We recommend that window managers with only one configuration
file which is a default \f(CW.*wmrc\fP file should name it
\f(CWsystem.*wmrc\fP (unless there is a widely-accepted alternative
name) and not use a subdirectory.  Any window manager subdirectories
should be identically named to the actual window manager binary.

\f(CW/etc/X11/xdm\fP holds the configuration files for \f(CWxdm\fP.
These are most of the files normally found in \f(CW/usr/lib/X11/xdm\fP;
see Section 6, \f(CW/var/state/xdm\fP, for more information.

.H 3 "/etc/opt : Configuration files for /opt"
.sp 0
.P
Host-specific configuration files for add-on application software
packages shall be installed within the directory
\f(CW/etc/opt/<package>\fP, where \f(CW<package>\fP is the name of the
subtree in \f(CW/opt\fP where the static data from that package is
stored.  No structure is imposed on the internal arrangement of
\f(CW/etc/opt/<package>\fP.

If a configuration file must reside in a different location in order for
the package or system to function properly, it may be placed in a
location other than \f(CW/etc/opt/<package>\fP.

.HU "BEGIN RATIONALE"
.br
.P
Refer to the rationale for \f(CW/opt\fP.
.HU "END RATIONALE"

.H 2 "/home : User home directories (optional)"
.P
\f(CW/home\fP is a fairly standard concept, but it is clearly a
site-specific filesystem.  The setup will differ from host to host.
This section describes only a suggested placement for user home
directories; nevertheless we recommend that all \*(Fs-compliant
distributions use this as the default location for home directories.

On small systems, each user's directory is typically one of the many
subdirectories of \f(CW/home\fP such as \f(CW/home/smith\fP,
\f(CW/home/torvalds\fP, \f(CW/home/operator\fP, etc.

On large systems (especially when the \f(CW/home\fP directories are
shared amongst many hosts using NFS) it is useful to subdivide user home
directories.  Subdivision may be accomplished by using subdirectories
such as \f(CW/home/staff\fP, \f(CW/home/guests\fP,
\f(CW/home/students\fP, etc.

Different people prefer to place user accounts in a variety of places.
Therefore, no program should rely on this location.  If you want to find
out a user's home directory, you should use the \f(CWgetpwent(3)\fP
library function rather than relying on \f(CW/etc/passwd\fP because user
information may be stored remotely using systems such as NIS.

.H 2 "/lib : Essential shared libraries and kernel modules"
.P

The \f(CW/lib\fP directory contains those shared library images needed
to boot the system and run the commands in the root filesystem.

.PS
copy "draft.pic"
dir(/lib,essential shared libraries and kernel modules)
sub("modules","Loadable kernel modules")
.PE

This includes \f(CW/lib/libc.so.*\fP, \f(CW/lib/libm.so.*\fP, the shared
dynamic linker \f(CW/lib/ld.so\fP, and other shared libraries required
by binaries in \f(CW/bin\fP and \f(CW/sbin\fP.

Shared libraries that are only necessary for binaries in \f(CW/usr\fP
(such as any X Window binaries) do not belong in \f(CW/lib\fP. Only
the shared libraries required to run binaries in \f(CW/bin\fP and
\f(CW/sbin\fP should be here.  The library \f(CWlibm.so.*\fP may also
be placed in \f(CW/usr/lib\fP if it is not required by anything in
\f(CW/bin\fP or \f(CW/sbin\fP.

For compatibility reasons, \f(CW/lib/cpp\fP needs to exist as a
reference to the C preprocessor installed on the system.  The usual
placement of this binary is \f(CW\%/usr/lib/gcc-lib/<target>/<version>/cpp\fP.
\f(CW/lib/cpp\fP can either point at this binary, or at any other
reference to this binary which exists in the filesystem.  (For example,
\f(CW/usr/bin/cpp\fP is also often used.)

The specification for \f(CW/lib/modules\fP is forthcoming.

.H 2 "/mnt : Mount point for temporarily mounted filesystems"
.P
This directory is provided so that the system administrator may
temporarily mount filesystems as needed.  The content of this directory
is a local issue and should not affect the manner in which any program
is run.

We recommend against the use of this directory by installation
programs, and suggest that a suitable temporary directory not in use
by the system should be used instead.

.H 2 "/opt : Add-on application software packages"
.SP
.PS
copy "draft.pic"
dir(/opt,Add-on application software packages)
sub("<package>","Static package objects")
.PE

\f(CW/opt\fP is reserved for the installation of add-on application
software packages.

A package to be installed in \f(CW/opt\fP shall locate its static files
in a separate \f(CW/opt/<package>\fP directory tree, where
\f(CW<package>\fP is a name that describes the software package.

Programs to be invoked by users shall be located in the directory
\f(CW/opt/<package>/bin\fP. If the package includes Unix manual pages,
they shall be located in \f(CW/opt/<package>/man\fP and the same
substructure as \f(CW/usr/share/man\fP shall be used.

The directories \f(CW/opt/bin\fP, \f(CW/opt/doc\fP,
\f(CW/opt/include\fP, \f(CW/opt/info\fP, \f(CW/opt/lib\fP, and
\f(CW/opt/man\fP are reserved for local system administrator use.
Packages may provide "front-end" files intended to be placed in (by
linking or copying) these reserved directories by the local system
administrator, but shall function normally in the absence of these
reserved directories.

Package files that are variable (change in normal operation) should be
installed in \f(CW/var/opt\fP.  See the section on \f(CW/var/opt\fP for
more information.

Host-specific configuration files should be installed in
\f(CW/etc/opt\fP.  See the section on \f(CW/etc\fP for more information.

No other package files should exist outside the \f(CW/opt\fP,
\f(CW/var/opt\fP, and \f(CW/etc/opt\fP hierarchies except for those
package files that must reside in specific locations within the
filesystem tree in order to function properly.  For example, device lock
files must be placed in \f(CW/var/lock\fP and devices must be located in
\f(CW/dev\fP.

.HU "BEGIN RATIONALE"
.br
.P
The use of \f(CW/opt\fP for add-on software is a well-established
practice in the Unix community.  The System V Application Binary
Interface [AT&T 1990], based on the System V Interface Definition (Third
Edition), provides for an \f(CW/opt\fP structure very similar to the one
defined here.

The Intel Binary Compatibility Standard v. 2 (iBCS2) also provides a
similar structure for \f(CW/opt\fP.

Generally, all data required to install a package on a system should be
present within \f(CW/opt/<package>\fP, including files intended to be
copied into \f(CW/etc/opt/<package>\fP and \f(CW/var/opt/<package>\fP as
well as reserved directories in \f(CW/opt\fP.
.HU "END RATIONALE"

.H 2 "/proc : Kernel and process information virtual filesystem"
.P
The proc filesystem is becoming the de-facto standard Linux method for
handling process and system information, rather than \f(CW/dev/kmem\fP
and other similar methods.  We strongly encourage this
for the storage and retrieval of process information as well as other
kernel and memory information.

.H 2 "/root : Home directory for the root user (optional)"
.P
\f(CW/\fP is traditionally the home directory of the root account on
\*(Ux systems.  \f(CW/root\fP is used on many Linux systems and on
some \*(Ux systems.  The root account's home directory may be
determined by developer or local preference.  Obvious possibilities
include \f(CW/\fP, \f(CW/root\fP, and \f(CW/home/root\fP.

If root's home directory is not stored on the root partition it will
be necessary to make certain it will default to \f(CW/\fP if it can
not be located.

Note: we recommend against using the root account for mundane things
such as mail and news, and that it be used solely for system
administration.  For this reason, we recommend that subdirectories such
as \f(CWMail\fP and \f(CWNews\fP not appear in the root account's home
directory, and that mail for administration roles such as
root, postmaster and webmaster be forwarded to an appropriate user.

.H 2 "/sbin : System binaries (binaries once kept in /etc)"
.P
Utilities used for system administration (and other root-only commands)
are stored in \f(CW/sbin\fP, \f(CW/usr/sbin\fP, and
\f(CW/usr/local/sbin\fP.  \f(CW/sbin\fP typically contains binaries
essential for booting the system in addition to the binaries in
\f(CW/bin\fP.  Anything executed after \f(CW/usr\fP is known to be
mounted (when there are no problems) should be placed into
\f(CW/usr/sbin\fP.  Local-only system administration binaries should be
placed into \f(CW/usr/local/sbin\fP.

Deciding what things go in \f(CWsbin\fP directories is simple: If a (non-root) user
will ever need to run it, then it should go somewhere else.  If it will only
be run by system administrators or as root from system management
scripts, then it should go in \f(CW/sbin\fP (or in \f(CW/usr/sbin\fP or
\f(CW/usr/local/sbin\fP if the item is not vital to system operation).
.\" What about mkfs and fsck? - Lars W.

Files such as \f(CWchfn\fP which users only occasionally use should
still be placed in \f(CW/usr/bin\fP.  \f(CWping\fP, although it is
absolutely necessary for root (network recovery and diagnosis) is often
used by users and should live in \f(CW/bin\fP for that reason.

Ordinary users should not have to place any of the \f(CWsbin\fP
directories in their path.

We recommend that users have read and execute permission for everything
in \f(CW/sbin\fP except, perhaps, certain setuid and setgid programs.
The division between \f(CW/bin\fP and \f(CW/sbin\fP was not created for
security reasons or to prevent users from seeing the operating system,
but to provide a good partition between binaries that everyone uses and
ones that are primarily used for administration tasks.  There is no
inherent security advantage in making \f(CW/sbin\fP off-limits for
users.

.HU "Required files for /sbin:"
.BL
.LI
General commands:
.VL 2
.LI "\f(CW{"
clock, getty, init, update, mkswap, swapon, swapoff, telinit }\fP
.LE

.LI
Shutdown commands:
.VL 2
.LI "\f(CW{"
fastboot, fasthalt, halt, reboot, shutdown }\fP
.LE
.sp 0.5
(Or any combination of the above, so long as \f(CWshutdown\fP is
included.)

.LI
Filesystem management commands:
.VL 2
.LI "\f(CW{"
fdisk, fsck, fsck.*, mkfs, mkfs.* }\fP
.LE
.sp 0.5
\f(CW*\fP = one or more of \f(CWext, ext2, minix, msdos, xia\fP and
perhaps others

.LI
Second extended filesystem commands (optional):
.VL 2
.LI "\f(CW{"
badblocks, dumpe2fs, e2fsck, mke2fs, mklost+found, tune2fs }\fP
.LE

.LI
Boot-loader map installer:
.VL 2
.LI "\f(CW{"
lilo }\fP
.LE

.LI
Networking commands:
.VL 2
.LI "\f(CW{"
ifconfig, route }\fP
.LE
.LE

.HU "Optional files for /sbin:"
.BL
.LI
Static binaries:
.SP
.VL 2
.LI "\f(CW{"
ldconfig, sln, ssync }\fP
.LE
.P
Static \f(CWln\fP (\f(CWsln\fP) and static \f(CWsync\fP (\f(CWssync\fP)
are useful when things go wrong.  The primary use of \f(CWsln\fP (to
repair incorrect symlinks in \f(CW/lib\fP after a poorly orchestrated
upgrade) is no longer a major concern now that the \f(CWldconfig\fP
program (usually located in \f(CW/usr/sbin\fP) exists and can act as a
guiding hand in upgrading the dynamic libraries.  Static \f(CWsync\fP is
useful in some emergency situations.  Note that these need not be
statically linked versions of the standard \f(CWln\fP and \f(CWsync\fP,
but may be.

The \f(CWldconfig\fP binary is optional for \f(CW/sbin\fP since a site
may choose to run \f(CWldconfig\fP at boot time, rather than only when
upgrading the shared libraries.  (It's not clear whether or not it is
advantageous to run \f(CWldconfig\fP on each boot.)  Even so, some
people like \f(CWldconfig\fP around for the following (all too common)
situation:

.LB 8 4 " " 3
.LI
I've just removed \f(CW/lib/<file>\fP.
.LI
I can't find out the name of the library because \f(CWls\fP is
dynamically linked, I'm using a shell that doesn't have \f(CWls\fP
built-in, and I don't know about using "\f(CWecho *\fP" as a
replacement.
.LI
I have a static \f(CWsln\fP, but I don't know what to call the link.
.LE

.LI
Miscellaneous:
.SP
.VL 2
.LI "\f(CW{"
ctrlaltdel, kbdrate }\fP
.LE
.P
So as to cope with the fact that some keyboards come up with such a high
repeat rate as to be unusable, \f(CWkbdrate\fP may be installed in
\f(CW/sbin\fP on some systems.
.\" should we advise installing this?

Since the default action in the kernel for the Ctrl-Alt-Del key
combination is an instant hard reboot, it is generally advisable to
disable the behavior before mounting the root filesystem in read-write
mode.  Some \f(CWinit\fP suites are able to disable Ctrl-Alt-Del, but
others may require the \f(CWctrlaltdel\fP program, which may be
installed in \f(CW/sbin\fP on those systems.
.LE

.H 2 "/tmp : Temporary files"
.P
The \f(CW/tmp\fP directory shall be made available for programs that
require temporary files.

Although data stored in \f(CW/tmp\fP may be deleted in a site-specific
manner, it is recommended that files and directories located in
\f(CW/tmp\fP be deleted whenever the system is booted.

Programs shall not assume that any files or directories in \f(CW/tmp\fP
are preserved between invocations of the program.

.HU "BEGIN RATIONALE"
.br
.P
\s-1IEEE\s0 standard P1003.2 (POSIX, part 2) makes requirements that are
similar to the above section.

\*(Fs added the recommendation that \f(CW/tmp\fP be cleaned at boot time
on the basis of historical precedent and common practice, but did not
make it a requirement because system administration is not within the
scope of this standard.
.HU "END RATIONALE"
.SK
.H 1 "The /usr Hierarchy"
.P
\f(CW/usr\fP is the second major section of the filesystem.
\f(CW/usr\fP is shareable, read-only data.  That means that \f(CW/usr\fP
should be shareable between various hosts running \*(Fs-compliant and
should not be written to.  Any information that is host-specific or
varies with time is stored elsewhere.

No large software packages should use a direct subdirectory under the
\f(CW/usr\fP hierarchy.  An exception is made for the X Window System
because of considerable precedent and widely-accepted practice.  This
section of the standard specifies the location for most such packages.

.PS
copy "draft.pic"
dir(/usr,Secondary Hierarchy)
sub("X11R6","X Window System, version 11 release 6")
sub("X386","X Window System, version 11 release 5 on x86 platforms")
sub("bin","Most user commands")
.\" sub("dict","Word lists")
.\" sub("doc","Miscellaneous documentation")
.\" sub("g++-include","GNU C++ include files")
sub("games","Games and educational binaries")
sub("include","Header files included by C programs")
.\" sub("info","GNU Info system's primary directory")
sub("lib","Libraries")
sub("local","Local hierarchy (empty after main installation)")
.\" sub("man","Online manuals")
sub("sbin","Non-vital system administration binaries")
sub("share","Architecture-independent data")
sub("src","Source code")
.PE

The following symbolic links to directories may be present. This
possibility is based on the need to preserve compatibility with older
systems until all implementations can be assumed to use the \f(CW/var\fP
hierarchy.

.DS
.nf
.ft CW
    /usr/adm -> /var/log
    /usr/preserve -> /var/state/<editor>
    /usr/spool -> /var/spool
    /usr/tmp -> /var/tmp
    /usr/spool/locks -> /var/lock
.ft P
.fi
.DE

Once a system no longer requires any one of the above symbolic links,
the link may be removed, if desired.  Notably, it takes little effort to
completely remove \f(CW/usr/preserve\fP since only \f(CWelvis\fP
uses it.

.DS
.H 2 "/usr/X11R6 : X Window System, Version 11 Release 6"
.P
This hierarchy is reserved for the X Window System, version 11 release
6, and related files.

.PS
copy "draft.pic"
dir(/usr/X11R6,X Window System (version 11 release 6))
sub("bin","")
sub("doc","")
sub("include","")
sub("lib","")
sub("man","")
.PE
.DE
To simplify matters and make XFree86 more compatible with the X Window
System on other systems, the following symbolic links should be present:

.nf
.ft CW
    /usr/bin/X11 -> /usr/X11R6/bin
    /usr/lib/X11 -> /usr/X11R6/lib/X11
    /usr/include/X11 -> /usr/X11R6/include/X11
.ft P
.fi
.P
In general, software should not be installed or managed via the above
symbolic links.  They are intended for utilization by users only.  The
difficulty is related to the release version of the X Window System \(em
in transitional periods, it is impossible to know what release of X11 is
in use.  For the same reason, there should not be a symbolic link from
\f(CW/usr/X11\fP pointing to the current X Window System hierarchy.

.H 2 "/usr/X386 : X Window System, Version 11 Release 5, on x86 platforms"
.P
This hierarchy is generally identical to \f(CW/usr/X11R6\fP, except that
the \f(CW/usr\fP symbolic links should be absent if \f(CW/usr/X11R6\fP
is installed.

.DS
.H 2 "/usr/bin : Most user commands"
.P
This is the primary directory of executable commands on the system.

.PS
copy "draft.pic"
dir(/usr/bin,Binaries that are not needed in single-user mode)
sub("mh","Commands for the MH mail handling system")
sub("X11","Symlink to \f(CW/usr/X11R6/bin\fP")
.PE
.DE
Because shell script interpreters (invoked with \f(CW#!<path>\fP on the
first line of a shell script) cannot rely on a path, it is advantageous
to standardize their locations.  The Bourne shell and C-shell
interpreters are already fixed in \f(CW/bin\fP, but Perl, Python, and
Tcl are often found in many different places.  \f(CW/usr/bin/perl\fP,
\f(CW/usr/bin/python\fP, and \f(CW/usr/bin/tcl\fP should reference the
\f(CWperl\fP, \f(CWpython\fP, and \f(CWtcl\fP shell interpreters,
respectively.  They may be symlinks to the physical location of the
shell interpreters.

.DS
.H 2 "/usr/include : Directory for standard include files."
.P
This is where all of the system's general-use include files for the C
and C++ programming languages should be placed.

.PS
copy "draft.pic"
dir(/usr/include,Include files)
sub("X11","Symlink to \f(CW/usr/X11R6/include/X11\fP")
sub("arpa","ARPAnet defined protocol definitions")
sub("asm","Symlink to \f(CW/usr/src/linux/include/asm-<arch>\fP")
sub("bsd","BSD compatibility include files")
sub("g++","GNU C++ include files")
sub("gnu","GNU include files")
sub("linux","Symlink to \f(CW/usr/src/linux/include/linux\fP")
sub("net","Generic network-related definitions")
sub("netax25","+AX25 (ARRL AX.25) specific definitions")
sub("netinet","TCP/IP specific definitions")
sub("netipx","+IPX (Novell IPX/SPX) specific definitions")
sub("protocols","Protocol definitions (mostly INET-based)")
sub("readline","The GNU readline library")
sub("rpc","Sun Microsystems RPC definitions")
sub("rpcsvc","Sun Microsystems RPC service definitions")
sub("sys","System generation include files")
.PE
.DE
.\" H.J. Lu is now trying to get /usr/g++-include into /usr/include
.\"
.\" Note that not all of these subdirectories are required.
.\" fix this  - no longer necessary, see my comments in the section
.\" on compliance/compatibility - iwj
.\"
.\" \f(CW/usr/include/g++\fP is optional, but suggested, until such time
.\" that it becomes the default for the standard Linux C++ libraries.  The
.\" previous location was \f(CW/usr/g++-include\fP.
.\" maybe it should be /usr/include/c++ ???
The \f(CWarpa\fP subdirectory contains protocol header definitions for the
ARPAnet protocols, TCP/IP conversion functions, definitions for
\f(CWftp\fP, \f(CWtelnet\fP prototypes, and similar material.

The \f(CWnet\fP subdirectory contains generic network-related definitions.  It
defines the system kernel interface, protocol family details, etc.

The \f(CWnetinet\fP subdirectory contains INET (DARPA Internet, which is
also known as TCP/IP) specific definitions.

ARRL AX.25 is better known as packet radio.  The Novell IPX/SPX
protocols are part of the Novell NetWare file services.

.H 2 "/usr/lib : Libraries for programming"
.P
\f(CW/usr/lib\fP is intended for object files and libraries.

Historically, \f(CW/usr/lib\fP has also included compiler program
binaries and static data of various kinds \(em both executable code (for
example, GCC's internal binaries may be located under
\f(CW\%/usr/lib/gcc-lib\fP) and other types of data.

Miscellaneous application-specific static files and subdirectories
should be placed in \f(CW/usr/share\fP, and application-specific
binaries in \f(CW/usr/libexec\fP (for internal binaries),
\f(CW/usr/bin\fP (for user commands), or \f(CW/usr/sbin\fP (for system
commands).  However, distributors may place application-specific static
data and binaries in subdirectories of \f(CW/usr/lib\fP instead, at
their discretion.  Such application-specific directories might include,
for example, \f(CWemacs\fP, \f(CW\%gcc-lib\fP, \f(CWmf\fP, \f(CWnews\fP,
\f(CWsmail\fP, \f(CWtexmf\fP, or \f(CWuucp\fP.

Some executable commands such as \f(CWmakewhatis\fP and \f(CWsendmail\fP
have also been traditionally placed in \f(CW/usr/lib\fP.
\f(CWmakewhatis\fP is an internal binary and should be placed in a
binary directory; users access only \f(CWcatman\fP.  Newer
\f(CWsendmail\fP binaries are now placed by default in
\f(CW/usr/sbin\fP; a symbolic link should remain from \f(CW/usr/lib\fP.
Additionally, systems using Smail should place Smail in
\f(CW/usr/sbin/smail\fP, and \f(CW/usr/sbin/sendmail\fP should be a
symbolic link to it.

A symbolic link \f(CW/usr/lib/X11\fP pointing to the \f(CWlib/X11\fP
directory of the default X distribution is required if X is installed.
Note: No host-specific data for the X Window System should be stored in
\f(CW/usr/lib/X11\fP.  Host-specific configuration files such as
\f(CWXconfig\fP or \f(CWXF86Config\fP should be stored in
\f(CW/etc/X11\fP.  This should include configuration data such as
\f(CWsystem.twmrc\fP even if it is only made a symbolic link to a more
global configuration file (probably in \f(CW/usr/X11R6/lib/X11\fP).
.\" we might want to specify locations for fonts and font information

.H 2 "/usr/libexec : Internal binaries"
.P
\f(CW/usr/libexec\fP is intended to hold internal binaries, i.e.,
binaries that are not run from the command line.  Typical examples
include internet daemons started by \f(CWinetd\fP; \f(CWinit\fP
binaries, such as \f(CWgetty\fP; compiler binaries, such as \f(CWcc1\fP;
and any other component executable that does little or nothing when run
from the command line.

Note that while, for BSD systems, \f(CWld.so\fP may be placed here, it
(along with \f(CW\%ld-linux.so\fP) must be placed in \f(CW/lib\fP under
Linux to accommodate dynamically linked programs in \f(CW/bin\fP and
\f(CW/sbin\fP.

Subdirectories may be created under \f(CW/usr/libexec\fP as desired by
applications.  Examples include \f(CWuucp\fP (for UUCP internal
binaries) and \f(CWlpr\fP (for printer daemon filter programs).

No specific programs must be placed here, but it is recommended that any
binaries in \f(CW/usr/lib\fP and \f(CW/usr/sbin\fP that meet the
criterion above be moved to this directory.

.HU "BEGIN RATIONALE"
.br
.P
The concept of a \f(CWlibexec\fP directory was introduced in the Net/2
distribution of the BSD operating system.  It was created to remove
executables that weren't intended to be executed directly by users, from
the standard execution path.
.P
A similar concept has been used in other UNIX operating systems, such as
OSF/1, which names this directory \f(CW/usr/lbin\fP.  The name
\f(CW/usr/lbin\fP was not chosen because it was first used for local
binaries (rather than internal binaries) in System III.  We also felt
that \f(CW/usr/lbin\fP would be more easily mistaken for a directory
that was meant to be placed in a user's execution path.
.\" XXX - provide additional rationale, esp. regarding share and how
.\" most arch-specific stuff around ends up here
.\" /usr/lib/<app> deprecated???
.HU "END RATIONALE"

.H 2 "/usr/local : Local hierarchy"
.P
The \f(CW/usr/local\fP hierarchy is for use by the system administrator
when installing software locally.  It needs to be safe from being
overwritten when the system software is updated.  It may be used for
programs and data that are shareable amongst a group of hosts, but not
found in \f(CW/usr\fP.

.PS
copy "draft.pic"
dir(/usr/local,Local hierarchy)
sub("bin","Local-only binaries")
sub("doc","Local documentation")
sub("etc","Configuration for local-only binaries")
sub("games","Locally installed games")
sub("lib","Libraries for \f(CW/usr/local\fP")
sub("info","Local info pages")
sub("man","Man page hierarchy for \f(CW/usr/local\fP")
sub("share","Local architecture-independent hierarchy")
sub("src","Local source code")
.PE

This directory should always be empty after first installing a
\*(Fs-compliant system.  No exceptions to this rule should be made other
than the listed directory stubs.

Locally installed software should be placed within \f(CW/usr/local\fP
rather than \f(CW/usr\fP unless it is being installed to replace or
upgrade software in \f(CW/usr\fP.

Note that software placed in \f(CW/\fP or \f(CW/usr\fP may be
overwritten by system upgrades (though we recommend that distributions
do not overwrite data in \f(CW/etc\fP under these circumstances).  For
this reason, local software should not be placed outside of
\f(CW/usr/local\fP without good reason.

.H 2 "/usr/sbin : Non-essential standard system binaries"
.P
This directory contains any non-essential binaries used exclusively by
the system administrator.  System administration programs that are
required for system repair, system recovery, mounting \f(CW/usr\fP, or
other essential functions should be placed in \f(CW/sbin\fP instead.

Typically, \f(CW/usr/sbin\fP contains networking daemons, any
non-essential administration tools, and binaries for non-critical server
programs.

.\" I'm not sure about the advisability of this paragraph -
.\" it seems out of our scope - iwj
These server programs are used when entering the System V states known
as "run level 2" (multi-user state) and "run level 3" (networked state)
or the BSD state known as "multi-user mode".  At this point the system
is making services available to users (e.g., printer support) and to
other hosts (e.g., NFS exports).

Locally installed system administration programs should be placed in
\f(CW/usr/local/sbin\fP.

.DS
.H 2 "/usr/share : Architecture-independent data"
.P

.PS
copy "draft.pic"
dir(/usr/share,Architecture-independent data)
sub("dict","Word lists")
sub("doc","Miscellaneous documentation")
sub("games","Static data files for \f(CW/usr/games\fP")
sub("info","GNU Info system's primary directory")
sub("locale","Locale information")
sub("man","Online manuals")
sub("nls","Native language support")
sub("misc","Miscellaneous architecture-independent data")
sub("terminfo","Directories for terminfo database")
sub("tmac","troff macros not distributed with groff")
sub("zoneinfo","Timezone information and configuration")
.PE
.DE

The \f(CW/usr/share\fP hierarchy is for all read-only architecture
independent data files.  Much of this data originally lived in
\f(CW/usr\fP (\f(CWman\fP, \f(CWdoc\fP) or \f(CW/usr/lib\fP (\f(CWdict\fP,
\f(CWterminfo\fP, \f(CWzoneinfo\fP).  This hierarchy is intended to be
shareable among all architecture platforms of a given OS; thus, for
example, a site with i386, Alpha, and PPC platforms might maintain a
single \f(CW/usr/share\fP directory that is centrally-mounted.  Note,
however, that \f(CW/usr/share\fP is generally not intended to be shared
by different OSes or by different releases of the same OS.

Any program or package which contains or requires data that doesn't need
to be modified should store that data in \f(CW/usr/share\fP (or
\f(CW/usr/local/share\fP, if installed locally).  It is recommended that a
subdirectory be used in \f(CW/usr/share\fP for this purpose.

Note that Linux currently uses DBM-format database files.  While these
are not architecture-independent, they are allowed in \f(CW/usr/share\fP
as a short-term measure pending an anticipated switch to the DB 2.0
format.  DB 2.0 uses an architecture independent format.

Game data stored in \f(CW/usr/lib/games\fP should be purely static data.
Any modifiable files, such as score files, game play logs, and so forth,
should be placed in \f(CW/var/games\fP.

It is recommended that application-specific, architecture-independent
directories be placed here.  Such directories include \f(CWgroff\fP,
\f(CWperl\fP, \f(CWghostscript\fP, \f(CWtexmf\fP, and
\f(CWkbd\fP (Linux) or \f(CWsyscons\fP (BSD).  They may, however, be
placed in \f(CW/usr/lib\fP for backwards compatibility, at the
distributor's discretion.  Similarly, a \f(CW/usr/lib/games\fP
hierarchy may be used in addition to the \f(CW/usr/share/games\fP
hierarchy if the distributor wishes to place some game data there.
.\"
.\" Note groff support files should be installed in /usr/share/groff
.\" to simplify groff upgrading on Linux systems, rather than the
.\" distribution of groff files found on current BSD systems.

.H 3 "/usr/share/dict : Word lists"
.sp
.HU "Recommended files for /usr/share/dict:"
.VL 2
.LI "\f(CW{"
words }\fP
.LE
.P
Traditionally this directory contains only the English \f(CWwords\fP
file, which is used by \f(CWlook(1)\fP and various spelling programs.
\f(CWwords\fP may use either American or British spelling.  Sites that
require both may link \f(CWwords\fP to
\f(CW\%/usr/share/dict/american-english\fP
or \f(CW\%/usr/share/dict/british-english\fP.

Word lists for other languages may be added using the English name for
that language, e.g., \f(CW/usr/share/dict/french\fP,
\f(CW/usr/share/dict/danish\fP, etc.  These should, if possible, use an
ISO 8859 character set which is appropriate for the language in
question; if possible the Latin1 (ISO 8859-1) character set should be
used (this is often not possible).

Other word lists, such as the \f(CWweb2\fP "dictionary" should be
included here, if present.

.HU "BEGIN RATIONALE"
.br
.P
The reason that only word lists are located here is that they are the
only files common to all spell checkers.
.HU "END RATIONALE"

.H 3 "/usr/share/man : Manual pages"
.sp
This section details the organization for manual pages throughout the
system, including \f(CW/usr/share/man\fP.  Also refer to the section on
\f(CW/var/spool/man\fP.

.DS
Manual pages are stored in \f(CW<mandir>/<locale>/man[1-9]/<arch>\fP.
An explanation of \f(CW<mandir>\fP, \f(CW<locale>\fP, and \f(CW<arch>\fP
is given below.

.PS
copy "draft.pic"
dir(<mandir>/<locale>,A manual page hierarchy)
sub("man1","User programs")
sub("man2","System calls")
sub("man3","Library functions and subroutines")
sub("man4","Devices")
sub("man5","File formats")
sub("man6","Games")
sub("man7","Miscellaneous")
sub("man8","System administration")
sub("man9","Kernel internal variables and functions")
.PE
.DE
The primary \f(CW<mandir>\fP of the system is \f(CW/usr/share/man\fP.
\f(CW/usr/share/man\fP contains manual information for commands and data under
the \f(CW/\fP and \f(CW/usr\fP filesystems.  Obviously, there are no
manual pages in \f(CW/\fP because they are not required at boot time nor
are they required in emergencies.

Provisions must be made in the structure of \f(CW/usr/share/man\fP to support
manual pages which are written in different (or multiple) languages.
These provisions must take into account the storage and reference of
these manual pages.  Relevant factors include language (including
geographical-based differences), and character code set.

This naming of language subdirectories of \f(CW/usr/share/man\fP is based on
Appendix E of the POSIX 1003.1 standard which describes the locale
identification string \(em the most well-accepted method to describe a
cultural environment.  The \f(CW<locale>\fP string is:
.P 1
\f(CW<language>[_<territory>][.<character-set>][,<version>]\fP

The \f(CW<language>\fP field shall be taken from ISO 639 (a code for the
representation of names of languages).  It shall be two characters wide
and specified with lowercase letters only.

The \f(CW<territory>\fP field shall be the two-letter code of ISO 3166
(a specification of representations of countries), if possible.  (Most
people are familiar with the two-letter codes used for the country codes
in email addresses.\*F) It shall be two characters wide and specified
with uppercase letters only.
.FS
A major exception to this rule is the United Kingdom, which is `GB' in
the ISO 3166, but `UK' for most email addresses.
.FE

The \f(CW<character-set>\fP field should represent the standard
describing the character set.  If the \f(CW\%<character-set>\fP field is
just a numeric specification, the number represents the number of the
international standard describing the character set.  It is recommended
that this be a numeric representation if possible (ISO standards,
especially), not include additional punctuation symbols, and that any
letters be in lowercase.

A parameter specifying a \f(CW<version>\fP of the profile may be placed
after the \f(CW\%<character-set>\fP field, delimited by a comma.  This
may be used to discriminate between different cultural needs; for
instance, dictionary order versus a more systems-oriented collating
order.  This standard recommends not using the \f(CW<version>\fP field,
unless it is necessary.

Systems which use a unique language and code set for all manual pages
may omit the \f(CW<locale>\fP substring and store all manual pages in
\f(CW<mandir>\fP.  For example, systems which only have English manual
pages coded with \s-1ASCII\s0, may store manual pages (the
\f(CWman[1-9]\fP directories) directly in \f(CW/usr/share/man\fP.  (That is
the traditional circumstance and arrangement, in fact.)

Countries for which there is a well-accepted standard character code set
may omit the \f(CW\%<character-set>\fP field, but it is strongly
recommended that it be included, especially for countries with several
"competing" standards.

.DS
Various examples:

.TS
l l l l
l l l lfCW.
Language	Territory	Character Set	Directory
_
English	\(em	ASCII	/usr/share/man/en
English	United Kingdom	ASCII	/usr/share/man/en_GB
English	United States	ASCII	/usr/share/man/en_US
French	Canada	ISO 8859-1	/usr/share/man/fr_CA
French	France	ISO 8859-1	/usr/share/man/fr_FR
German	Germany	ISO 646	/usr/share/man/de_DE.646
German	Germany	ISO 6937	/usr/share/man/de_DE.6937
German	Germany	ISO 8859-1	/usr/share/man/de_DE.88591
German	Switzerland	ISO 646	/usr/share/man/de_CH.646
Japanese	Japan	JIS	/usr/share/man/ja_JP.jis
Japanese	Japan	SJIS	/usr/share/man/ja_JP.sjis
Japanese	Japan	UJIS (or EUC-J)	/usr/share/man/ja_JP.ujis
.TE
.DE

Similarly, provision must be made for manual pages which are
architecture-dependent, such as device-driver documentation or low-level
system administration commands.  These should be placed under an
\f(CW<arch>\fP directory in the appropriate \f(CWman[1-9]\fP directory;
for example, a man page for the i386 ctrlaltdel(8) command might be
placed in \f(CW/usr/share/man/<locale>/man8/i386/ctlaltdel.8\fP.

Manual pages for commands and data under \f(CW/usr/local\fP are stored
in \f(CW/usr/local/man\fP.  Manual pages for the X Window System are
stored in \f(CW/usr/X11R6/man\fP.  It follows that all manual page
hierarchies in the system should have the same structure as
\f(CW/usr/share/man\fP.  Empty directories may be omitted from a manual page
hierarchy.  For example, if \f(CW/usr/local/man\fP has no manual pages
in section 4 (Devices), then \f(CW/usr/local/man/man4\fP may be omitted.

The cat page sections (\f(CWcat[1-9]\fP) containing formatted manual
page entries are also found within subdirectories of
\f(CW<mandir>/<locale>\fP, but are not required nor should they be
distributed in lieu of nroff source manual pages.
.\" other subdirectories, ps[1-9], dvi[1-9], html[1-9] may be here eventually
.\" revise

The MH mail handling system manual pages should have \f(CWmh\fP appended
to all manual page filenames.  All X Window System manual pages should
have an \f(CWx\fP appended to the filename.

The practice of placing various language manual pages in appropriate
subdirectories of \f(CW/usr/share/man\fP also applies to the other manual page
hierarchies, such as \f(CW/usr/local/man\fP and \f(CW/usr/X11R6/man\fP.
(This portion of the standard also applies later in the section on the
optional \f(CW/var/spool/man\fP structure.)

A description of each section follows:
.BL
.LI
\f(CWman1\fP: User programs
.br
Manual pages that describe publicly accessible commands are contained in
this chapter.  Most program documentation that a user will need to use
is located here.
.LI
\f(CWman2\fP: System calls
.br
This section describes all of the system calls (requests for the
kernel to perform operations).
.\" delete parenthesized remark?  assume technical background?
.LI
\f(CWman3\fP: Library functions and subroutines
.br
Section 3 describes program library routines that are not direct calls
to kernel services.  This and chapter 2 are only really of interest to
programmers.
.LI
\f(CWman4\fP: Special files
.br
Section 4 describes the special files, related driver functions, and
networking support available in the system.  Typically, this includes
the device files found in \f(CW/dev\fP and the kernel interface to
networking protocol support.
.LI
\f(CWman5\fP: File formats
.br
The formats for many nonintuitive data files are documented in the
section 5.  This includes various include files, program output files,
and system files.
.LI
\f(CWman6\fP: Games
.br
This chapter documents games, demos, and generally trivial programs.
Different people have various notions about how essential this is.
.LI
\f(CWman7\fP: Miscellaneous
.br
Manual pages that are difficult to classify are designated as being
section 7.  The troff and other text processing macro packages are found
here.
.LI
\f(CWman8\fP: System administration
.br
Documentation for programs used by system administrators for system
operation and maintenance are documented here.  Some of these programs
are also occasionally useful for normal users.
.LI
\f(CWman9\fP: Kernel internal variables and functions
.br
This is used on systems that document the kernel source code.
.LE

.H 3 "/usr/share/misc : Miscellaneous architecture-independent data"
.sp

This directory contains miscellaneous architecture-independent files
which don't require a separate subdirectory under \f(CW/usr/share\fP.
It is a required directory under \f(CW/usr/share\fP.

The following files, if present, should be located under
\f(CW/usr/share/misc\fP:

.VL 2
.LI "\f(CW{"
ascii, magic, termcap, termcap.db }\fP
.LE

Other (application-specific) files may appear here, but a distributor
may place them in \f(CW/usr/lib\fP at their discretion.  Some such
files include:

.VL 2
.LI "\f(CW{"
airport, birthtoken, eqnchar, getopt, gprof.callg, gprof.flat,
inter.phone, ipfw.samp.filters, ipfw.samp.scripts, keycap.pcvt, mail.help,
mail.tildehelp, man.template, map3270, mdoc.template, more.help, na.phone,
nslookup.help, operator, scsi_modes, sendmail.hf, style, units.lib,
vgrindefs, vgrindefs.db, zipcodes }\fP
.LE

.DS
.H 2 "/usr/src : Source code"
.PS
copy "draft.pic"
dir(/usr/src,Source code)
sub("linux","Source code for Linux kernel")
.PE
.DE
Any non-local source code should be placed in this subdirectory.  The only
source code that should always be placed in a specific location is the
kernel source (when present or linked in part to the \f(CW/usr/include\fP
structure).  Subdirectories may be used here if desired.

The source code for the kernel should always be in place or at least the
include files from the kernel source.  Those files are located in these
directories:

.nf
.ft CW
	/usr/src/linux/include/asm-<arch>
	/usr/src/linux/include/linux
.ft P
.fi

\f(CW/usr/include\fP should contain links to these directories, named
\f(CWasm\fP and \f(CWlinux\fP.  Since they are needed by the C compiler,
at least those include files should always be distributed with
installations which include a C compiler.  They should be distributed in
the \f(CW/usr/src/linux\fP directory so there are no problems when
system administrators upgrade their kernel version for the first time.

.\" I added this because it appeared to require that /usr/src/linux
.\" be the physical location of the kernel source - iwj
\f(CW/usr/src/linux\fP may also be a symbolic link to a kernel source
code tree.
.SK
.DS
.H 1 "The /var Hierarchy"
.PS
copy "draft.pic"
dir(/var,Variable data)
sub("account","Process accounting logs (if supported)")
sub("crash","System crash dumps (if supported)")
sub("cron","cron and at jobs")
sub("games","Variable game data")
sub("lock","Lock files")
sub("log","Log files and directories")
sub("mail","User mailbox files")
sub("opt","Variable data for /opt")
sub("run","Files relevant to running processes")
sub("spool","Application spool data")
sub("state","Variable state information")
sub("tmp","Temporary files preserved between system reboots")
sub("yp","Network Information Service (NIS) database files")
.PE
.DE
\f(CW/var\fP contains variable data files.  This includes spool
directories and files, administrative and logging data, and transient
and temporary files.

Some portions of \f(CW/var\fP are not shareable between different
systems.  For instance, \f(CW/var/log\fP, \f(CW/var/lock\fP, and
\f(CW/var/run\fP.  Other portions are shareable, notably
\f(CW/var/mail\fP, \f(CW/var/spool/man\fP, \f(CW/var/spool/fonts\fP,
and \f(CW/var/spool/news\fP.

\f(CW/var\fP is specified here in order to make it possible to mount
\f(CW/usr\fP read-only.  Everything that once went into \f(CW/usr\fP
that is written to during system operation (as opposed to installation
and software maintenance) must be in \f(CW/var\fP.

If \f(CW/var\fP cannot be made a separate partition, it is often
preferable to move \f(CW/var\fP out of the root partition and into the
\f(CW/usr\fP partition.  (This is sometimes done to reduce the size of
the root partition or when space runs low in the root partition.)
However, \f(CW/var\fP should not be linked to \f(CW/usr\fP because this
makes separation of \f(CW/usr\fP and \f(CW/var\fP more difficult and is
likely to create a naming conflict.  Instead, link \f(CW/var\fP to
\f(CW/usr/var\fP.

Applications should generally not add directories to the top level of
\f(CW/var\fP.  Such directories should only be added if they have some
system-wide implication, and in consultation with the \*(Fs mailing list.

The \f(CWlock\fP, \f(CWlog\fP, \f(CWrun\fP, \f(CWspool\fP,
\f(CWstate\fP, and \f(CWtmp\fP directories must be included and used
in all distributions; the \f(CWaccount\fP, \f(CWcrash\fP, \f(CWcron\fP,
\f(CWgames\fP, \f(CWmail\fP, and \f(CWyp\fP directories must be included
and used if the corresponding applications or features are provided in
the distribution.

Several directories are `reserved' in the sense that they should not be
used arbitrarily by some new application, since they would conflict
with historical and/or local practice.  They are:

.nf
.ft CW
    /var/backups
    /var/local
    /var/msgs
    /var/preserve
.ft P
.fi

.H 2 "/var/account : Process accounting logs (if supported)"
.P
This directory holds the current active process accounting log and the
composite process usage data (as used by \f(CWlastcomm\fP and \f(CWsa\fP).
As of the date of this release of the standard, process accounting was not
supported under Linux.

.H 2 "/var/crash : System crash dumps (if supported)"
.P
This directory holds system crash dumps.  As of the date of this release
of the standard, system crash dumps were not supported under Linux.

.H 2 "/var/cron : cron and at jobs"
.P
This directory contains the variable data for the cron and at processes.

.HU "BEGIN RATIONALE"
.br
.P
Previous Linux releases, as well as most commercial vendors, use
\f(CW/var/spool\fP for \f(CWcron\fP.  Given the definition
of \f(CW/var/spool\fP, it was judged reasonable to move \f(CWcron\fP
elsewhere in the \f(CW/var\fP hierarchy.  Precedent from BSD \*(Ux
suggested using \f(CW/var/cron\fP rather than \f(CW/var/state/cron\fP.
Combining \f(CWcron\fP and \f(CWat\fP in this hierarchy assumes
that a free \f(CWcron\fP that includes \f(CWat\fP functionality
will be implemented in the future.
.HU "END RATIONALE"

.H 2 "/var/games : Variable game data"
.P
Any variable data relating to games, such as those in \f(CW/usr/games\fP,
should be placed here.  \f(CW/var/games\fP should hold the variable
data previously found in \f(CW/usr\fP; static data, such as help
text, level descriptions, and so on, should remain elsewhere, such as
\f(CW/usr/lib/games\fP.

.HU "BEGIN RATIONALE"
.br
.P
\f(CW/var/games\fP has been given a hierarchy of its own, rather
than leaving it merged in with the old \f(CW/var/lib\fP as in release
1.2.  The separation allows local control of backup strategies,
permissions, and disk usage, as well as allowing inter-host sharing
and reducing clutter in \f(CW/var/state\fP.  Additionally, \f(CW/var/games\fP
is the path traditionally used by BSD.
.HU "END RATIONALE"

.H 2 "/var/lock : Lock files"
.P
Lock files should be stored within the \f(CW/var/lock\fP directory structure.

Device lock files, such as the serial device lock files that were
originally found in either \f(CW/usr/spool/locks\fP or
\f(CW/usr/spool/uucp\fP, must now be stored in \f(CW/var/lock\fP.  The
naming convention which must be used is
.ie t \{\
\f(CWLCK..\fP followed by the base name of the device.  For example, to
lock \f(CW/dev/cua0\fP the file \f(CWLCK..cua0\fP would be created.
\}
.el \{\
"LCK.." followed by the base name of the device.  For example, to lock
/dev/cua0 the file "LCK..cua0" would be created.
\}

The format used for device lock files must be the HDB UUCP lock
file format.  The HDB format is to store the process identifier (PID) as
a ten byte \s-1ASCII\s0 decimal number, with a trailing newline.  For
example, if process 1230 holds a lock file, it would contain the eleven
characters: space, space, space, space, space, space, one, two, three,
zero, and newline.
.\" Some versions of UUCP add a second line indicating which program created
.\" the lock (uucp, cu, or getty).

Then, anything wishing to use \f(CW/dev/cua0\fP can read the lock file
and act accordingly (all locks in \f(CW/var/lock\fP should be
world-readable).

.H 2 "/var/log : Log files and directories"
.P
The directory contains miscellaneous log files.  Most logs should be
written to this directory or an appropriate subdirectory.
.TS
tab(@);
lfCW l.
lastlog@record of last login of each user
messages@system messages from \f(CWsyslogd\fP
wtmp@record of all logins and logouts
.TE

.H 2 "/var/opt : Variable data for /opt"
.P
Variable data should be installed in \f(CW/var/opt/<package>\fP, where
\f(CW<package>\fP is the name of the subtree in \f(CW/opt\fP where the
static data from an add-on software package is stored, except where
superseded by another file in \f(CW/etc\fP.  No structure is imposed on
the internal arrangement of \f(CW/var/opt/<package>\fP.

.HU "BEGIN RATIONALE"
.br
.P
Refer to the rationale for \f(CW/opt\fP.
.HU "END RATIONALE"

.H 2 "/var/run : Run-time variable files"
.P
This directory contains system information files describing the system
since it was booted.  Files in this directory should be cleared (removed
or truncated as appropriate) at the beginning of the boot process.

Process identifier (PID) files, which were originally placed in
\f(CW/etc\fP, should be placed in \f(CW/var/run\fP.  The naming
convention for PID files is \f(CW<program-name>.pid\fP.  For example,
the \f(CWcrond\fP PID file is named \f(CW/var/run/crond.pid\fP.

The internal format of PID files remains unchanged.  The file should
consist of the process identifier in \s-1ASCII\s0-encoded decimal,
followed by a newline character.  For example, if \f(CWcrond\fP was
process number 25, \f(CW/var/run/crond.pid\fP would contain three
characters: two, five, and newline.

Programs that read PID files should be somewhat flexible in what they
accept; i.e., they should ignore extra whitespace, leading zeroes,
absence of the trailing newline, or additional lines in the PID file.
Programs that create PID files should use the simple specification
located in the above paragraph.

The \f(CWutmp\fP file, which stores information about who is currently
using the system, is located in this directory.

Programs that maintain transient \*(Ux-domain sockets should place them
in this directory.

.DS
.H 2 "/var/spool : Application spool data"
.PS
copy "draft.pic"
dir(/var/spool,Spool directories)
sub("fonts","Locally-generated fonts")
sub("lpd","Printer spool directory")
sub("man","Locally-formatted manual pages")
sub("mqueue","Outgoing mail queue")
sub("news","News spool directory")
sub("rwho","Rwhod files")
sub("smail","Spool directories for smail")
sub("uucp","Spool directory for UUCP")
.PE
.DE

\f(CW/var/spool\fP is intended for `spooled' data from applications.
Such data remains valid even if the application that created it aborts
and restarts.  Some time after being created, the data is automatically
removed, in an application-specific manner; this is typically when some
event occurs (e.g., lpd prints the file, or sendmail sends it) or a time
limit expires (e.g. a news article or a formatted man page is expired).
Data in \f(CW/var/spool\fP is generally of interest to the user in and
of itself, unlike data in \f(CW/var/state\fP, which is generally of
interest only indirectly.

UUCP lock files must be placed in \f(CW/var/lock\fP.  See the above
section on \f(CW/var/lock\fP.

.H 3 "/var/spool/fonts : Locally-generated fonts"
.sp 0
.P
The directory \f(CW/var/spool/fonts\fP should be used to store any
dynamically-created fonts.  In particular, \f(CW/var/spool/fonts/pk\fP
will store all of the fonts which are automatically generated by
\f(CWMakeTeXPK\fP.

There should be a link from \f(CW/usr/lib/texmf/fonts/tmp\fP to
\f(CW/var/spool/fonts\fP.  This link allows users to use single path
\f(CW/usr/lib/texmf/fonts/tfm\fP when making changes to their TEXFONTS
environment variable.  (This is the default path for Karl Berry's \*(Tx
tools, distributed from \f(CWftp.cs.umb.edu:/pub/tex\fP.\*F
.FS
The reason that Karl Berry's tools are mentioned is that they are the
de-facto standard for \*(Ux installations of \*(Tx.  These tools
are widely used in the free \*(Ux community.
.FE
If another \*(Tx distribution is used, a link from the appropriate font
directory to \f(CW/var/spool/fonts\fP should be made.)

The \f(CWMakeTeXPK\fP that is distributed with \f(CWdvipsk\fP will
place \f(CW.pk\fP files in \f(CWfonts/pk/<device>/<fontname>\fP (e.g.,
\f(CWfonts/pk/CanonCX/cmr10.300pk\fP).  The \f(CW.pk\fP files can be
periodically purged from the \f(CW/var/spool/fonts\fP tree, or can be
moved into the \f(CW/usr/lib/texmf\fP tree.  If automatic \f(CW.mf\fP
or \f(CW.tfm\fP generators are used, they should place their data in
the \f(CWmf\fP or \f(CWtfm\fP subdirectories of
\f(CW/var/spool/fonts\fP.

Other dynamically created fonts may also be placed in this tree, under
appropriately-named subdirectories of \f(CW/var/spool/fonts\fP.

.DS
.H 3 "/var/spool/lpd : Line-printer daemon print queues"
.sp
.PS
copy "draft.pic"
dir(/var/spool/lpd,Printer spool directory)
sub("<printer>","Spools for a specific printer (optional)")
.PE
.DE

The lock file for \f(CWlpd\fP, \f(CWlpd.lock\fP, should be placed in
\f(CW/var/spool/lpd\fP.  It is suggested that the lock file for each
printer be placed in the spool directory for that specific printer and
named \f(CWlock\fP.

.H 3 "/var/spool/man : Locally-formatted manual pages (optional)"
.sp
This directory provides a standard location for sites that provide a
read-only \f(CW/usr\fP partition, but wish to allow caching of
locally-formatted man pages.  Sites that mount \f(CW/usr\fP as writable
(e.g., single-user installations) may choose not to use
\f(CW/var/spool/man\fP and may write formatted man pages into the
\f(CWcat[1-9]\fP directories in \f(CW/usr/share/man\fP directly.  We
recommend that most sites use one of the following options instead:
.BL
.LI
Preformat all manual pages alongside the unformatted versions.
.LI
Allow no caching of formatted man pages, and require formatting to be
done each time a man page is brought up.
.LI
Allow local caching of formatted man pages in \f(CW/var/spool/man\fP.
.LE
.P
The structure of \f(CW/var/spool/man\fP needs to reflect both the fact of
multiple man page hierarchies and the possibility of multiple language
support.

Given an unformatted manual page that normally appears in
\f(CW/usr/<path>/man/<locale>/man[1-9]\fP, the cached formatted
version should go in \f(CW/var/spool/man/<path>/<locale>/cat[1-9]\fP.
(Note that the \f(CW<locale>\fP component may be missing.)
For a manual page that normally appears outside \f(CW/usr\fP,
in \f(CW/<path>/man/<locale>/man[1-9]\fP, the cached formatted
version should go in \f(CW/var/spool/man/<path>/<locale>/cat[1-9]\fP.
The \f(CW<path>\fP component is absent in the case of \f(CW/usr/share/man\fP
and \f(CW/var/spool/man\fP.

For example, \f(CW/usr/share/man/man1/ls.1\fP is
formatted into \f(CW/var/spool/man/cat1/ls.1\fP, and
\f(CW/usr/X11R6/man/<locale>/man3/XtClass.3x\fP into
\f(CW/var/spool/man/X11R6/<locale>/cat3/XtClass.3x\fP.

Man pages written to \f(CW/var/spool/man/cat[1-9]\fP may eventually be
transferred to \f(CW/usr/<path>/cat[1-9]\fP or expired; likewise
formatted man pages in \f(CW/usr/<path>/cat[1-9]\fP may be expired if
they are not accessed for a period of time.

If preformatted manual pages come with a system on read-only media
(a CD-ROM, for instance), they shall be installed into
\f(CW/usr/<path>/cat[1-9]\fP.  \f(CW/var/spool/man\fP is reserved as a
writable cache for formatted manual pages.

.HU "BEGIN RATIONALE"
.br
.P
Release 1.2 of the standard specified \f(CW/var/catman\fP for this
hierarchy.  The path has been changed to \f(CW/var/spool\fP to better
reflect the dynamic nature of the formatted man pages.  The directory
name has been changed to \f(CWman\fP to allow for enhancing the hierarchy
to include post-processed formats other than "cat", such as PostScript,
HTML, or DVI.
.HU "END RATIONALE"

.H 3 "/var/spool/rwho : Rwhod files"
.sp
This directory holds the rwhod information for other systems on the
local net.

.HU "BEGIN RATIONALE"
.br
.P
Previous BSD releases used \f(CW/var/rwho\fP for this data; given
its close fit to the definition of `spooled' data, and its historical
precedent in \f(CW/var/spool\fP on other systems, a move was deemed
appropriate.
.HU "END RATIONALE"

.DS
.H 2 "/var/state : Variable state information"

.PS
copy "draft.pic"
dir(/var/state,Variable state information)
sub("<editor>","Saved files after crash and other editor state")
.\" sub("elvis","Saved files after crash or hang-up from elvis")
.\" sub("emacs","State directory for Emacs")
sub("misc","Miscellaneous state data")
.\" sub("news","Variable files for Cnews/INN")
.\" sub("nvi","Saved files after crash or hang-up from nvi")
sub("xdm","X display manager variable data")
sub("<pkgtool>","Packaging support files")
sub("<package>","State data for packages and subsystems")
.PE
.DE

This hierarchy holds state information pertaining to an application or
the system.  State information is data that programs modify while they
run, and that pertains to one specific host.  Users should never need
to modify files in \f(CW/var/state\fP to configure a package's operation.

State information is generally used to preserve the condition of an
application (or a group of inter-related applications) between
invocations and between different instances of the same application.
State information should generally remain valid after a reboot,
.\" (but note that emacs/lock is an exception to this),
should not be logging output, and should not be spooled data.

An application (or a group of inter-related applications) should
use a subdirectory of \f(CW/var/state\fP for its data.  There is one
required subdirectory, \f(CW/var/state/misc\fP, which is intended for
state files that don't need a subdirectory; the other subdirectories
should only be present if the application in question is included in
the distribution.

\f(CW/var/state/<name>\fP is the location that should be used for all
distribution packaging support.  Different distributions may utilize
different names, of course.

.HU "BEGIN RATIONALE"
.br
.P
Previous releases of the standard used the name \f(CW/var/lib\fP.
However, \f(CW/usr/lib\fP is increasingly used solely for object
files or archives of them; this is true of the current BSD \*(Ux
variants as well as current GNU packages.  Accordingly, the name
\f(CW/var/lib\fP seemed inappropriate.

BSD used the name \f(CW/var/db\fP for a similar directory.  This name
seemed overly constricting, as it implied a directory structure intended
primarily for database (\f(CW.db\fP) files.
.HU "END RATIONALE"

.H 3 "/var/state/<editor> : Saved files after crash and other editor state"
.sp
These directories contain saved files generated by any unexpected
termination of an editor (e.g., elvis, jove, nvi).

Other editors may not require a directory for crash-recovery files, but
may require a well-defined place to store other information while the
editor is running.  This information should be stored in a subdirectory
under \f(CW/var/state\fP (for example, GNU Emacs would place lock files
in \f(CW/var/state/emacs/lock\fP).

Future editors may require additional state information beyond
crash-recovery files and lock files -- this information should also be
placed under \f(CW/var/state/<editor>\fP.

.HU "BEGIN RATIONALE"
.br
.P
Previous Linux releases, as well as all commercial vendors, use
\f(CW/var/preserve\fP for vi or its clones.  However, each editor uses
its own format for these crash-recovery files, so a separate directory
is needed for each editor.

Editor-specific lock files are usually quite different from the device
or resource lock files that are stored in \f(CW/var/lock\fP and, hence,
are stored under \f(CW/var/state\fP.
.HU "END RATIONALE"

.H 3 "/var/state/misc : Miscellaneous variable data"
.sp
This directory contains variable data not placed in a subdirectory in
\f(CW/var/state\fP.  An attempt should be made to use relatively unique
names in this directory to avoid namespace conflicts.

Note that files previously stored in \f(CW/var/db\fP in previous BSD
releases are moved here.  These include \f(CWlocate.database\fP and
\f(CWmountdtab\fP, and the kernel symbol database(s).

.H 2 "/var/tmp : Temporary files preserved between system reboots"
.P
The \f(CW/var/tmp\fP directory is made available for programs that require
temporary files or directories that are preserved between system reboots.
Therefore, data stored in \f(CW/var/tmp\fP is more persistent than data
in \f(CW/tmp\fP.

Files and directories located in \f(CW/var/tmp\fP must not be deleted
when the system is booted.  Although data stored in \f(CW/var/tmp\fP
is typically deleted in a site-specific manner, it is recommended that
deletions occur at a less frequent interval than \f(CW/tmp\fP.
.ig
A symbolic link \f(CW/var/tmp/vi.recover\fP to \f(CW/var/state/nvi\fP
is allowed to support versions of nvi compiled without the path name
suggested in the standard.

Programs must not assume that any files or directories are preserved
between invocations of the program.
..
.\" XXX - Why did the second paragraph get commented out?

.H 2 "/var/yp : Network Information Service (NIS) database files"
.P
Variable data for the Network Information Service (NIS), formerly known
as the Sun Yellow Pages (YP), shall be placed in this directory.

.HU "BEGIN RATIONALE"
.br
.P
\f(CW/var/yp\fP is the standard directory for NIS (YP) data and is
almost exclusively used in NIS documentation and systems.

NIS should not be confused with Sun NIS+, which uses a different
directory, \f(CW/var/nis\fP.
.HU "END RATIONALE"
.SK
.\" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
.nr Hu 3
.HU "The \*(Fs mailing list"
.br
.P
The \*(Fs mailing list is located at <linux-fsstnd@ucsd.edu>.
This list was originally located on the <linux-activists@Niksula.hut.fi>
"Mail-Net" as the FSSTND channel.  (To subscribe to the list send
mail to <listserv@ucsd.edu> with body "\f(CWADD linux-fsstnd\fP".)

Thanks to Network Operations at the University of California at San
Diego who allowed us to use their excellent mailing list server.

As noted in the introduction, please do not send mail to the mailing
list without first contacting the \*(Fs editor or a listed contributor.

.HU "Acknowledgments"
.br
.P
Credit for this text should be given to the \*(Fs activists, developers,
system administrators, and users whose input was essential to this
standard.  I (Daniel Quinlan) also wish to thank each of the
contributors who helped me to write, compile, and compose this, a
consensus standard.

We (Daniel Quinlan and the \*(Fs group) express our gratitude for the
support of those Linux developers who have seen that giving Linux a
common filesystem layout is something that will further the development
of the Linux operating system; and to the intrepid BSD folk who answered
our call to help develop a wider standard addressing the needs of both
communities.

We especially wish to note the bravery and perseverance of those Linux
developers who started following drafts of the ancestral FSSTND before
it was even completed.  Without the demonstration they provided that
the FSSTND was worthwhile, the \*(Fs could never have evolved.

.HU "Original contributors"
.P
.nf
Drew Eckhardt           <drew@colorado.edu>
Ian Jackson             <ijackson@cus.cam.ac.uk>
Ian McCloghrie          <ian@ucsd.edu>
Daniel Quinlan          <Daniel.Quinlan@linux.org>
Mike Sangrey            <mike@sojurn.lns.pa.us>
David H. Silber         <dhs@glowworm.firefly.com>
Theodore Ts'o           <tytso@athena.mit.edu>
Stephen Tweedie         <sct@dcs.ed.ac.uk>
.fi
.HU "Additional contributors"
.SP
.nf
Brandon S. Allbery      <bsa@kf8nh.wariat.org>
Keith Bostic            <bostic@cs.berkeley.edu>
Rik Faith               <faith@cs.unc.edu>
Stephen Harris          <sweh@spuddy.mew.co.uk>
Fred N. van Kempen      <waltje@infomagic.com>
John A. Martin          <jmartin@acm.org>
Chris Metcalf           <metcalf@lcs.mit.edu>
Ian Murdock             <imurdock@debian.org>
David C. Niemi          <niemidc@clark.net>
Eric S. Raymond         <esr@thyrsus.com>
.fi
.TC
.\" Local Variables:
.\" fill-column:72
.\" font-lock-maximum-size:0
.\" hilit-auto-highlight-maxout:100000
.\" End:
