#!/bin/perl
# wais-ncsa-httpd.pl -- WAIS search interface
#
# Tony Sanders <sanders@bsdi.com>, Nov 1993
# Hacked to bloody pieces by marca@ncsa.uiuc.edu.

$waisq = "/usr/local/bin/waisq";
$waisd = "/usr/people/marca/localwais/sources";

sub do_wais {
    $query = $ARGV[0];
    $pquery = $query;
    $pquery =~ s/%20/ /g;
    
    open(WAISQ, "-|") || exec ($waisq, "-c", $waisd,
                                "-f", "-", "-S", "www.src", "-g", $pquery);
    print "Content-type: text/html\n\n";
    $title = "WAIS Search Engine";
    print "<HEAD>\n<TITLE>Search of ", $title, "</TITLE>\n</HEAD>\n";
    print "<BODY>\n<H1>", $title, "</H1>\n";

    print "Index \`www\' contains the following\n";
    print "items relevant to \`$pquery\':<P>\n";
    print "<DL>\n";

    local($hits, $score, $headline, $lines, $bytes, $type, $date);
    while (<WAISQ>) {
        /:score\s+(\d+)/ && ($score = $1);
        /:number-of-lines\s+(\d+)/ && ($lines = $1);
        /:number-of-bytes\s+(\d+)/ && ($bytes = $1);
        /:type "(.*)"/ && ($type = $1);
        /:headline "(.*)"/ && ($headline = $1);         # XXX
        /:date "(\d+)"/ && ($date = $1, $hits++, &docdone);
    }
    close(WAISQ);
    print "</DL>\n";

    if ($hits == 0) {
        print "Nothing found.\n";
    }
    print "</BODY>\n";
}

sub docdone {
    if ($headline =~ /Search produced no result/) {
        print "Sorry, no search results.<P>\n";
    } else {
        print "<DT><A HREF=\"$headline\">$headline</A>\n";
        print "<DD>Score: $score, Lines: $lines, Bytes: $bytes\n";
    }
    $score = $headline = $lines = $bytes = $type = $date = '';
}

eval '&do_wais';
