/* This file is copyright 1996 by Matt Gischer (matt@fidalgo.net)
 * It is freely distributable for personal uses, but if you are employing
 * it for other things, you must first ask me.  I guess other than that, 
 * you should follow the GNU Public License.  thanks.  If you make any
 * changes/fixes, please mail them to me.  */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include "shaft.h"

/* This function reads in the configuration file created by the setup program */
void
  readcfg ()
{
  FILE *cfgfile;
  if ((cfgfile = fopen (CFGFILE, "rb")) == NULL)
    {
      printf ("Could not open BBS Configuration file [%s], exiting", CFGFILE);
      printf ("Maybe you should try running the setup program");
      sendtolog ("Could not open BBS Configuration file [%s]", CFGFILE);
      exit (1);
    }
  fread (&cfg, sizeof (struct setup), 1, cfgfile);
  fclose (cfgfile);
}

/* This function gives you a formatted user listing with some of their 
 * information */
void
  userlist ()
{
  FILE *userfile;
  int i = 0;
  char chat[10];

  printf ("\033[1;34m+---------+------------+--------------+-----------------------+-----+\n");
  printf ("| \033[1;31mUser    \033[1;34m| \033[1;32mUser id    \033[1;34m| \033[0;36mAlias        \033[1;34m| \033[1;33mCalling from          \033[1;34m| \033[1;36mSL\033[1;34m  |\n");
  printf ("\033[1;34m+---------+------------+--------------+-----------------------+-----+\n");
  while (i < MAXUSERS)
    {
      if (strcmp (info[i].id, "") != 0)
	{
	  chatstat (chat, i);
	  printf ("|\033[1;31m #%-7i\033[1;34m| %s\033[1;32m%-10s\033[1;34m| \033[0;36m%-12s\033[1;34m | \033[1;33m%-21s \033[1;34m| \033[1;36m%-3i\033[1;34m |\n", i, chat, info[i].id, info[i].alias, info[i].city, info[i].seclev);
	}
      i++;
    }
  printf ("\033[1;34m+---------+------------+--------------+-----------------------+-----+\n");
  printf ("\033[0;22m");
}
