/* This file is copyright 1996 by Matt Gischer (matt@fidalgo.net)
 * It is freely distributable for personal uses, but if you are employing
 * it for other things, you must first ask me.  I guess other than that, 
 * you should follow the GNU Public License.  thanks.  If you make any
 * changes/fixes, please mail them to me.  */
#include <stdio.h>
#include "shaft.h"
#include "file.h"
#include "util.h"
#include "userfile.h"
#include "msg.h"

/* Reads in a menu file and puts it in an array.  stuff is the filename 
 * minus the trailing .mnu */

readmenu (char *stuff)
{
  FILE *menufile;
  char in[80], file[80], ansifile[80];
  int lines, count, i;

  sprintf (file, "%s%s.mnu", MENUPATH, stuff);
  sprintf (ansifile, "%s%s.ans", MENUPATH, stuff);
  if ((menufile = fopen (file, "r")) == NULL)
    {
      printf ("Cannot open %s menu file.. \n", file);
      exit (1);
    }
  for (lines = 0; !feof (menufile); lines++)
    {
      fgets (in, 79, menufile);
    }
  lines = lines / 4;
  menuitems = lines;
  rewind (menufile);
  i = 0;

  do
    {
      fgets (prompt, 80, menufile);
    }
  while (prompt[0] == '#');
  stripnl (prompt);
  for (i = 0; i < lines; i++)
    {

      do
	{
	  fgets (in, 80, menufile);
	}
      while (in[0] == '#');
      stripnl (in);
      strcpy (menu[i].cmd, in);
      do
	{
	  fgets (in, 80, menufile);
	}
      while (in[0] == '#');
      stripnl (in);
      strcpy (menu[i].type, in);
      do
	{
	  fgets (in, 80, menufile);
	}
      while (in[0] == '#');
      stripnl (in);
      strcpy (menu[i].param, in);
      do
	{
	  fgets (in, 80, menufile);
	}
      while (in[0] == '#');
      stripnl (in);
/*      strcpy (menu[i].sl, in); */
      menu[i].sl = atoi (in);
    }
  fclose (menufile);
  domenu (ansifile);
}

/* User enters their choice and this searches for a corresponding menu 
 * entry and executes it if one is found */
domenu (char *ansifile)
{
  char input[80], tmp[80], lame;
  int i = 0, c = 0;
  struct
    {
      char *name;
      void (*function) ();
    }
  util_commands[] =
  {
/* anyone know how I could have indent make it say something like:
 * { "userlist", userlist },
 * instead of splitting it up?  Or turn off the option that makes it
 * mess that stuff up? */
    {
      "userlist", userlist
    }
    ,
    {
      "time", showtime
    }
    ,
    {
      NULL, NULL
    }
  }
  ,
    sys_commands[] =
  {
    {
      "logout", logout
    }
    ,
    {
      NULL, NULL
    }
  }
  ,
    msg_commands[] =
  {
    {
      "write", writemsg
    }
    ,
    {
      "read", readmsg
    }
    ,
    {
      "showbase", showmsgbases
    }
    ,
    {
      "addbase", addmsgbase
    }
    ,
    {
      "delbase", delmsgbase
    }
    ,
    {
      "choose", choosemsgbase
    }
    ,
    {
      "choosec", choosecurrentmsg
    }
    ,
/* These two are so you can type > and < in the msg bases 
 * and have it {in}{de}crement the currentmsgbase by 1 */
    {
      "upone", upone
    }
    ,
    {
      "downone", downone
    }
    ,
    {
      NULL, NULL
    }
  }
  ,
    info_commands[] =
  {
    {
      "changeinfo", changeinfo
    }
    ,
    {
      NULL, NULL
    }
  };

  showmenu (ansifile);
doitagain:
/*  print ("@D-@F=@D[@F#tm@D]@G> @k"); */
  print (prompt);
  gets (input);
  stripnl (input);
  for (i = 0; i < strlen (input); i++)
    {
      tmp[i] = toupper (input[i]);
      input[i] = tmp[i];
    }
  for (i = 0; i <= menuitems; i++)
    {
      if (input[0] == '?')
	{
	  showmenu (ansifile);
	  goto doitagain;
	}
      if (strlen (input) < 1)
	{
	  print ("@CPlease make a menu Selection.\n");
	  goto doitagain;
	}
      if (strcmp (menu[i].cmd, input) == 0)
	{
	  if ((strcmp (menu[i].type, "UTIL")) == 0)
	    {
	      for (c = 0; util_commands[c].name != NULL; c++)
		{
		  if ((strcmp (util_commands[c].name, menu[i].param)) == 0)
		    {
		      if (info[currentu].seclev < menu[i].sl)
			{
			  print ("@FSorry, you don't have access to this feature\n");
			  break;
			}
		      util_commands[c].function ();
		      break;
		    }
		}
	    }
	  else if ((strcmp (menu[i].type, "SYSTEM")) == 0)
	    {
	      for (c = 0; sys_commands[c].name != NULL; c++)
		{
		  if ((strcmp (sys_commands[c].name, menu[i].param)) == 0)
		    {
		      if (info[currentu].seclev < menu[i].sl)
			{
			  print ("@FSorry, you don't have access to this feature\n");
			  break;
			}
		      sys_commands[c].function ();
		      break;
		    }
		}
	    }
	  else if ((strcmp (menu[i].type, "SHOW")) == 0)
	    {
	      if (info[currentu].seclev < menu[i].sl)
		{
		  print ("@FSorry, you don't have access to this feature\n");
		  break;
		}
	      else
		{
		  page (menu[i].param);
		  break;
		}
	    }
	  if ((strcmp (menu[i].type, "INFO")) == 0)
	    {
	      for (c = 0; info_commands[c].name != NULL; c++)
		{
		  if ((strcmp (info_commands[c].name, menu[i].param)) == 0)
		    {
		      if (info[currentu].seclev < menu[i].sl)
			{
			  print ("@FSorry, you don't have access to this feature\n");
			  break;
			}
		      info_commands[c].function ();
		      break;
		    }
		}
	    }
	  else if ((strcmp (menu[i].type, "MSG")) == 0)
	    {
	      for (c = 0; msg_commands[c].name != NULL; c++)
		{
		  if ((strcmp (msg_commands[c].name, menu[i].param)) == 0)
		    {
		      if (info[currentu].seclev < menu[i].sl)
			{
			  print ("@FSorry, you don't have access to this feature\n");
			  break;
			}
		      msg_commands[c].function ();
		      break;
		    }
		}
	    }
	  else if ((strcmp (menu[i].type, "RUN")) == 0)
	    {
	      if (info[currentu].seclev < menu[i].sl)
		{
		  print ("@FSorry, you don't have access to this feature\n");
		  break;
		}
	      DoRun (menu[i].param);
	      break;
	    }
	  else if ((strcmp (menu[i].type, "MENU")) == 0)
	    {
	      if (info[currentu].seclev < menu[i].sl)
		{
		  print ("@FSorry, you don't have access to this feature\n");
		  break;
		}
	      readmenu (menu[i].param);
	      break;
	    }
	}
    }
  goto doitagain;
}

/* Outputs a file with shaftbbs ansi/user codes in it.. this one is used 
 * for menus */
showmenu (char *disp)
{
  FILE *file;
  char in[80];
  int lines, i;

  if ((file = fopen (disp, "r")) == NULL)
    {
      printf ("Cannot open %s menu file.. \n", file);
      exit (1);
    }
  for (lines = 0; !feof (file); lines++)
    {
      fgets (in, 79, file);
    }
  lines--;
  rewind (file);
  for (i = 0; i < lines; i++)
    {
      fgets (in, 79, file);
      print (in);
    }
  fclose (file);
}
