/* This file is copyright 1996 by Matt Gischer (matt@fidalgo.net)
 * It is freely distributable for personal uses, but if you are employing
 * it for other things, you must first ask me.  I guess other than that, 
 * you should follow the GNU Public License.  thanks.  If you make any
 * changes/fixes, please mail them to me.  */
#include <stdio.h>
#include "shaft.h"
#include "msg.h"

void addmsgbase ()
{
  char tmp[80];
  int i, x = 0;

  readmsgbased ();
  while (strcmp (area[x].name, "") != 0)
    x++;
  print ("@FEnter the name of the msg base you would like to add:  ");
  gets (area[x].name);
  print ("@FEnter the description of the msg base you would like to add:  ");
  gets (area[x].desc);
  area[x].number = x;
  print ("@FEnter the minimum security level required to read this msg base:  ");
  gets (tmp);
  area[x].seclev = atoi (tmp);
  area[x].nummsgs = 0;
  writemsgbased ();
}

void delmsgbase ()
{
  char tmp[80];
  int x;

  print ("@FEnter the number of the msg base you would like to delete:  ");
  gets (tmp);
  x = atoi (tmp);
  strcpy (area[x].name, "");
  area[x].seclev = 0;
  area[x].nummsgs = 0;
  writemsgbased ();
}

void showmsgbases ()
{
  int i = 0, x = 0, z = 0;
  char tmp[80];

  for (x = 0; x < MAXMSGAREAS; x++)
    {

      if (strcmp (area[x].name, "") != 0)
	{
	  for (z = 0; z < 30; z++)
	    print ("@D-");
	  puts ("");
	  sprintf (tmp, "@DArea name: [@F%s@D]\n", area[x].name);
	  print (tmp);
	  sprintf (tmp, "@DArea description: [@F%s@D]\n", area[x].desc);
	  print (tmp);
	  sprintf (tmp, "@DNumber of msg area: [@F%i@D]\n", area[x].number);
	  print (tmp);
	  sprintf (tmp, "@DArea security level: [@F%i@D]\n", area[x].seclev);
	  print (tmp);
	  sprintf (tmp, "@DNumber of msgs in area: [@F%i@D]\n", area[x].nummsgs);
	  print (tmp);
	}
    }
}

/* Read message base database */
void readmsgbased ()
{
  FILE *mbfile;
  if ((mbfile = fopen (MSGBASEDATA, "rb")) == NULL)
    {
      printf ("Cannot open message base file...creating a new one\n");
      writemsgbased ();
    }
  fread (&area, sizeof (struct areas), MAXMSGAREAS, mbfile);
  fclose (mbfile);
}

/* Write message base database */
void writemsgbased ()
{
  FILE *mbfile;
  if ((mbfile = fopen (MSGBASEDATA, "wb")) == NULL)
    {
      printf ("Cannot open message base file.\n");
      exit (1);
    }
  fwrite (&area, sizeof (struct areas), MAXMSGAREAS, mbfile);
  fclose (mbfile);
}

/* Do a new scan for messages */
void donewscan ()
{

}

/* Read the last read msg file */
void readlastmsgfile ()
{
  FILE *lastscanfile;
  int a = 0;

  if ((lastscanfile = fopen (LASTSCANFILE, "rb")) == NULL)
    {
      printf ("Could not open last scan file for reading.\n");
      sendtolog ("couldn't open last scan file");
      createlastmsgfile ();
    }
  fread (&curmsgs, sizeof (curmsgs), 1, lastscanfile);
  fclose (lastscanfile);
/* Duplicates the info in the file and puts it in your current msg pointer thing */
/* This _really_ should be changed so that it doesn't keep the whole damn thing in memory */

  for (a = 0; a < MAXMSGAREAS; a++)
    {
	  currentmsg[a] = curmsgs[currentu][a];
    }
}

void writelastmsgfile ()
{
  FILE *lastscanfile;

  int a = 0;

  for (a = 0; a < MAXMSGAREAS; a++)
    {
	  curmsgs[currentu][a] = currentmsg[a];
    }
  if ((lastscanfile = fopen (LASTSCANFILE, "wb")) == NULL)
    {
      printf ("Could not open last scan file for writing.\n");
      sendtolog ("couldn't open last scan file");
      logout ();
    }
  fwrite (&curmsgs, sizeof (curmsgs), 1, lastscanfile);
  fclose (lastscanfile);
}

void createlastmsgfile ()
{
  FILE *lastscanfile;

  if ((lastscanfile = fopen (LASTSCANFILE, "wb")) == NULL)
    {
      printf ("Creating save file for new scans.\n");
      sendtolog ("Creating save file for new scans");
      logout ();
    }
  fwrite (&curmsgs, sizeof (curmsgs), 1, lastscanfile);
  fclose (lastscanfile);
}

void writemsg ()
{
  int line = 0, count = 0, i = 0;
  char file[80], tmp[80];
  FILE *msgtmp, *msgfile;

  getmsgnum ();
  getdate (msg[currentmsg[currentmsgbase]].time);
  sprintf (msg[currentmsg[currentmsgbase]].sender, "@D%s @C(@F%s@C)@k", info[currentu].alias, info[currentu].id);
  print ("@FEnter the Subject of your message below:\n@C-@D=@F> @k");
  gets (msg[currentmsg[currentmsgbase]].subject);

/*print("@CWould you like to post anonymously?");
 * msg[currentmsg[currentmsgbase]].anon=yesno(); */

/* Make all messages public for now */
/*  msg[currentmsg].attr = 0; */
  strcpy (msg[currentmsg[currentmsgbase]].attr, "P");

  printf (area[currentmsgbase].name);
  sprintf (currentmsgfile, "%s%s.dat", MSGBASEPATH, area[currentmsgbase].name);
  if ((msgfile = fopen (currentmsgfile, "a")) == 0)
    {
      exit (1);
    }

/* Write Sender to file */
  sprintf (tmp, "@FPoster: @D%s\n", msg[currentmsg[currentmsgbase]].sender, msgfile);
  fputs (tmp, msgfile);

/* Write Date to file */
  sprintf (tmp, "@FTime: @D%s\n", msg[currentmsg[currentmsgbase]].time, msgfile);
  fputs (tmp, msgfile);

/* Write Subject to file */
  sprintf (tmp, "@FSubject: @D%s\n", msg[currentmsg[currentmsgbase]].subject, msgfile);
  fputs (tmp, msgfile);
  fclose (msgfile);

/* Generate a temporary file to edit.. then use their preferred editor to
 * edit */
  sprintf (file, "%sshaft%i", TMPDIR, randnum (1000));
  sprintf (tmp, "%s %s", info[currentu].editor, file);
  DoRun (tmp);

/* File with typed in text */
  if ((msgtmp = fopen (file, "r")) == 0)
    {
/*      exit (1); */

    }
/* File with header */
  if ((msgfile = fopen (currentmsgfile, "a")) == 0)
    {
      exit (1);
    }

/* Appends edited text to header file */
  while (!feof (msgtmp))
    {
      fgets (tmp, 79, msgtmp);
      if (!feof (msgtmp))
	fputs (tmp, msgfile);
    }

  fclose (msgfile);
  fclose (msgtmp);
  /* Show the msg they just typed in */
  showmsg (currentmsgfile);
  /* Increment the database, so it knows there is another msg */
  area[currentmsgbase].nummsgs++;
  writemsgbased ();

  unlink (file);
}

void
  readmsg ()
{
  char tmp[80];
  sprintf (tmp, "%s%s.dat", MSGBASEPATH, area[currentmsgbase].name);
  showmsg (tmp);
}

void
  getmsgnum ()
{
/*  currentmsg = 1; */
}

void
  showmsg (char *disp)
{
  FILE *file;
  char in[80];
  int lines, i, nummsgsinfile = -1, index = 0, msgsindex[MAXMSGS], x, y = 0;

  if ((file = fopen (disp, "r")) == NULL)
    {
      printf ("Cannot open %s.. \n", file);
    }
/* Find out how many msgs there are in the file */
  while (!feof (file))
    {
      fgets (in, 79, file);
      if (strstr (in, "Poster:"))
	{
	  nummsgsinfile++;
/* This is the line number that each post ends on */
	  msgsindex[nummsgsinfile] = index;
	}
      index++;
    }

  index++;
  nummsgsinfile++;
  msgsindex[nummsgsinfile] = index;
  rewind (file);

/* Find and print out the message */
  for (i = 0; i < nummsgsinfile; i++)
    {
      if (i == currentmsg[currentmsgbase])
	{
	  for (x = 0; x < msgsindex[i]; x++)
	    {
	      fgets (in, 79, file);
	    }
	  fgets (in, 79, file);
	  print (in);
	  for (y = 0; y < msgsindex[currentmsg[currentmsgbase] + 1]; y++)
	    {
	      fgets (in, 79, file);
	      if (strcmp (in, "") == 0)
		break;
	      if (strstr (in, "Poster:") != 0)
		break;
	      print (in);
	    }
	  break;
	}
    }
  currentmsg[currentmsgbase]++;
  fclose (file);
}

void
  choosecurrentmsg ()
{
  char s1[80];

  print ("What message would you like to make the current one?  ");
  gets (s1);
  currentmsg[currentmsgbase] = atoi (s1);
}

void
  choosemsgbase ()
{
  int x = 0, i = 0;
  char choice[80], tmp[80];
  print ("@DChoose a message base:\n");
  while (i < MAXMSGAREAS)
    {
      if (strcmp (area[i].name, "") != 0)
	{
	  sprintf (tmp, "@C%i@0: @F%s - %s\n", i, area[i].name, area[i].desc);
	  print (tmp);
	}
      i++;
    }
  do
    {
      print ("Enter the number of the message base you want: ");
      gets (choice);
      x = atoi (choice);
    }
  while ((x > MAXMSGAREAS) || (strcmp (area[x].name, "") == 0));

  currentmsgbase = x;

}

void
  upone ()
{
  if (strcmp (area[currentmsgbase + 1].name, "") != 0)
    currentmsgbase++;
}

void
  downone ()
{
  if (currentmsgbase > 0)
    currentmsgbase--;
}
