/* This file is copyright 1996 by Matt Gischer (matt@fidalgo.net)
 * It is freely distributable for personal uses, but if you are employing
 * it for other things, you must first ask me.  I guess other than that, 
 * you should follow the GNU Public License.  thanks.  If you make any
 * changes/fixes, please mail them to me.  */
/* ShaftBBS setup program.. you can make a new configuration file or 
 * modify an old one */
#include <stdio.h>
#include <sys/utsname.h>
#include "shaft.h"

main ()
{
  char enter, choice;

  printf ("Welcome to the setup program of Shaft BBS, %s\n", getenv ("USER"));
  printf ("I'm gonna ask you some questions, which you will need to answer\n");
  printf ("Hit Enter to continue...");
  enter = getchar ();
menu:
  printf ("Choose an option...\n");
  printf ("1.	New Configuration\n");
  printf ("2.	Modify an existing one\n");
  printf ("-=> ");
  while ((choice = getchar ()) != atoi ("\n"))
    {
      switch (choice)
	{
	case '1':
	  newcfg ();
	  break;
	  exit (0);
	case '2':
	  modcfg ();
	  break;
	  exit (0);
	default:
	  printf ("You must hit 1 or 2\n");
	  goto menu;
	}
    }
}

newcfg ()
{
  char enter;
  FILE *cfgfile;
  enter = getchar ();
  printf ("Enter the name of your bbs as you would like it to appear to users\n-=> ");
  gets (cfg.bbsname);
  printf ("\nEnter the system operators name here\n-=> ");
  gets (cfg.sysopname);
  printf ("\nEnter the BBS's phone # here\n-=> ");
  gets (cfg.phonenumber);
  printf ("\nIf you are on a network, enter your assigned named here. (i.e. shaft.prism.net) \n -= >");
  gets (cfg.hostname);
  if ((cfgfile = fopen (CFGFILE, "wb")) == 0)
    {
      printf ("Count not open BBS configuration file for writing..[%s]", CFGFILE);
      exit (1);
    }
  fwrite (&cfg, sizeof (struct setup), 1, cfgfile);
  fclose (cfgfile);
  system ("touch data/config.bbs");
}

modcfg ()
{
  char ch[80], lame;
  FILE *cfgfile;

/*      Buffered characters from stdin don't need to be kept.. this is a lame 
 * fix.. someone fix it if they can :) */
  lame = getchar ();
  if ((cfgfile = fopen (CFGFILE, "rb")) == 0)
    {
      printf ("Count not open BBS configuration file for modification..[%s]", CFGFILE);
      exit (1);
    }
  fread (&cfg, sizeof (struct setup), 1, cfgfile);
  fclose (cfgfile);
menu:
  printf ("Enter the number of the item you'd like to change\n");
  printf ("1. %s [BBS Name]\n", cfg.bbsname);
  printf ("2. %s [Sysop's Name]\n", cfg.sysopname);
  printf ("3. %s [BBS Phone Number]\n", cfg.phonenumber);
  printf ("4. %s [BBS hostname]\n", cfg.hostname);
  printf ("5. Save Configuration\n");
  printf ("6. Quit without saving\n");
  printf ("-=> ");
  while ((gets (ch)) != "\n")
    {
      if ((strcmp (ch, "1") == 0))
	{
	  printf ("Enter the new bbs name\n-=> ");
	  gets (cfg.bbsname);
	  goto menu;
	}
      if ((strcmp (ch, "2") == 0))
	{
	  printf ("Enter the new Sysop Name\n-=> ");
	  gets (cfg.sysopname);
	  goto menu;
	}
      if ((strcmp (ch, "3") == 0))
	{
	  printf ("Enter the new phone number\n-=> ");
	  gets (cfg.phonenumber);
	  goto menu;
	}
      if ((strcmp (ch, "4") == 0))
	{
	  printf ("Enter the new hostname\n-=> ");
	  gets (cfg.hostname);
	  goto menu;
	}
      if ((strcmp (ch, "5") == 0))
	{
	  printf ("Saving configuration to %s.\n", CFGFILE);
	  if ((cfgfile = fopen (CFGFILE, "wb")) == 0)
	    {
	      printf ("Count not open BBS configuration file for modification..[%s]", CFGFILE);
	      exit (1);
	    }
	  fwrite (&cfg, sizeof (struct setup), 1, cfgfile);
	  fclose (cfgfile);
	  exit (0);
	}
      if ((strcmp (ch, "6") == 0))
	{
	  exit (0);
	}
      goto menu;
    }
}
