/* This file is copyright 1996 by Matt Gischer (matt@fidalgo.net)
 * It is freely distributable for personal uses, but if you are employing
 * it for other things, you must first ask me.  I guess other than that, 
 * you should follow the GNU Public License.  thanks.  If you make any
 * changes/fixes, please mail them to me.  */

/* ShaftBBS User Editing program.. trying to make it look nice..  
 * Never let anyone but the bbs administrator run this program, unless you
 * want your users modified :) */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include "shaft.h"
#include "spawn.h"

int newuser = 0;

main (int argc, char *argv[])
{
  char in[80];
  info[currentu].ansi = 1;
  print ("@CWelcome to the #F User Editor\n");
  userlist ();
  if (argc < 2)
    {
      print ("@6Enter the user number/name to edit or 'quit' to exit\n");
      print ("@D-@6=@0> @B");
      gets (in);
    }
  else
    {
      strcpy (in, argv[1]);
    }
/* How the heck do i figure out if they entered a string or a number?  If 
 * that can be done then they can ACTUALLY enter a number or name.. so for 
 * right now all they can do is a number.. */
  if ((strcmp (in, "new") == 0))
    {
      adduser ();
    }
  if ((strcmp (in, "del") == 0))
    {
      deluser ();
    }
  if ((strcmp (in, "exit") == 0) || (strcmp (in, "quit") == 0))
    {
      exit (0);
    }
  currentu = atoi (in);
  readinfo ();
  showinfo ();
}

readinfo ()
{
  FILE *userfile;
  if ((userfile = fopen (BBSDATA, "rb")) == NULL)
    {
      printf ("Cannot open userfile, %s...exiting\n", BBSDATA);
      exit (1);
    }
  fread (&info, sizeof (struct user), MAXUSERS, userfile);
  fclose (userfile);
}

writeinfo ()
{
  FILE *userfile;
  if ((userfile = fopen (BBSDATA, "wb")) == NULL)
    {
      printf ("Cannot open userfile, %s...exiting\n", BBSDATA);
      exit (1);
    }
  fwrite (&info, sizeof (struct user), MAXUSERS, userfile);
  fclose (userfile);
  print ("@7Wrote userfile\n");
  exit (0);
}

showinfo ()
{
  int p;
  char tmp[80];
show:
  print ("@60. @D[@C#i@D] @6[@0Login@6]\n");
  print ("1. @D[@C#a@D] @6[@0Alias@6]\n");
  print ("2. @D[@C#f #l@D] @6[@0Name@6]\n");
  print ("3. @D[@C#A@D] @6[@0Address@6]\n");
  print ("4. @D[@C#c@D] @6[@0City@6]\n");
  print ("5. @D[@C#s@D] @6[@0State@6]\n");
  print ("6. @D[@C#Z@D] @6[@0Zip Code@6]\n");
  print ("7. @D[@C#P@D] @6[@0Home Phone@6]\n");
  print ("8. @D[@C#D@D] @6[@0Data Phone@6]\n");
  print ("9. @D[@C#e@D] @6[@0Email Address@6]\n");
  print ("10. @D[@C#C@D] @6[@0User Comment@6]\n");
  print ("11. @D[@C#S@D] @6[@0Security Level@6]\n");
  print ("12. @D[@C#d@D] @6[@0Time a day@6]\n");
  print ("13. @D[@C#t@D] @6[@0Time left today@6]\n");
  print ("14. @D[@C#L@D] @6[@0Date last logged on@6]\n");
  print ("15. @D[@C#E@D] @6[@0Text Editor@6]\n");
  print ("16. @D[@C#Y@D] @6[@0Available for chat@6]\n");
  print ("17. @D[@C#X@D] @6[@0Has Ansi@6]\n");
  print ("@618. @D[@CSave changes@D]\n");
  print ("@619. @D[@CAbort changes@D]\n");
  print ("@D-@6=@0> @C");
  fgets (tmp, 80, stdin);
  stripnl (tmp);
  if (strcmp (tmp, "0") == 0)
    change_login ();
  if (strcmp (tmp, "1") == 0)
    change_alias ();
  if (strcmp (tmp, "2") == 0)
    change_name ();
  if (strcmp (tmp, "3") == 0)
    change_addr ();
  if (strcmp (tmp, "4") == 0)
    change_city ();
  if (strcmp (tmp, "5") == 0)
    change_state ();
  if (strcmp (tmp, "6") == 0)
    change_zipcode ();
  if (strcmp (tmp, "7") == 0)
    change_homephone ();
  if (strcmp (tmp, "8") == 0)
    change_dataphone ();
  if (strcmp (tmp, "9") == 0)
    change_email ();
  if (strcmp (tmp, "10") == 0)
    change_comment ();
  if (strcmp (tmp, "11") == 0)
    change_sl ();
  if (strcmp (tmp, "12") == 0)
    change_timeday ();
  if (strcmp (tmp, "13") == 0)
    change_timeleft ();
  if (strcmp (tmp, "14") == 0)
    change_lastlogin ();
  if (strcmp (tmp, "15") == 0)
    change_editor ();
  if (strcmp (tmp, "16") == 0)
    tog_chat ();
  if (strcmp (tmp, "17") == 0)
    tog_ansi ();
  if (strcmp (tmp, "18") == 0)
    writeinfo ();
  if (strcmp (tmp, "19") == 0)
    exit (0);
  stripnl (tmp);
  goto show;
}

/* Sets currentu to the record number in the user datafile */
getusernum (char *u)
{
  int i = 0, x = 0, z = 0;

  readinfo ();
  while (!(strcmp (info[i].id, "") == 0))
    {
      if ((strcmp (info[i].id, u) == 0))
	{
	  z = 1;
	  break;
	}
      else
	{
	  z = 0;
	}
      i++;
      x++;
    }
  if (z == 0)
    {
      adduser ();
    }
  currentu = x;
}

adduser ()
{
  int i = 0, z;
  time_t t;

  readinfo ();
  while (!(strcmp (info[i].id, "") == 0))
    {
      i++;
    }
  currentu = i;
  change_login ();
  change_alias ();
  change_name ();
  change_addr ();
  change_city ();
  change_state ();
  change_zipcode ();
  change_homephone ();
  change_dataphone ();
  change_email ();
  change_comment ();
  info[i].seclev = NEWLEV;
  info[i].timeday = NEWUSERTIME;
  info[i].timeleft = NEWUSERTIME;
  time (&t);
  info[i].lastlogin = localtime (&t);
  writeinfo ();
  userlist ();
}

userlist ()
{
  int i = 0;

  readinfo ();
  printf ("\033[1;34mUser no.  \033[1;32mUser id\n");
  while (i < MAXUSERS)
    {
      if (strcmp (info[i].id, "") != 0)
	{
	  printf ("\033[1;34m#%-9i \033[1;32m%-10s\n", i, info[i].id);
	}
      i++;
    }
  printf ("\033[0;22m");
}

deluser ()
{
  char in[80];
  int i;
  print ("@BEnter the user number you would like deleted: ");
  gets (in);
  i = atoi (in);

  readinfo ();
  strcpy (info[i].id, NULL);
  strcpy (info[i].alias, NULL);
  strcpy (info[i].firstname, NULL);
  strcpy (info[i].lastname, NULL);
  strcpy (info[i].address, NULL);
  strcpy (info[i].city, NULL);
  strcpy (info[i].state, NULL);
  strcpy (info[i].zipcode, NULL);
  strcpy (info[i].homephone, NULL);
  strcpy (info[i].dataphone, NULL);
  strcpy (info[i].email, NULL);
  strcpy (info[i].comment, NULL);
  info[i].seclev = 0;
  info[i].timeday = 0;
  info[i].timeleft = 0;
  info[i].lastlogin = 0;
  writeinfo ();
}
