/* This file is copyright 1996 by Matt Gischer (matt@fidalgo.net)
 * It is freely distributable for personal uses, but if you are employing
 * it for other things, you must first ask me.  I guess other than that, 
 * you should follow the GNU Public License.  thanks.  If you make any
 * changes/fixes, please mail them to me.  */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <pwd.h>
#include <signal.h>
#include "shaft.h"
#include "userfile.h"
#include "util.h"

void
  readinfo ()
{
  int x;
  FILE *userfile;
  if ((userfile = fopen (BBSDATA, "rb")) == NULL)
    {
      printf ("Cannot open userfile, %s...exiting\n", BBSDATA);
      printf ("Are you running the bbs for the first time? ");
      x = yesno ();
      if (x = 1)
	{
	  newuser = 1;
	  adduser ();
	}
      exit (1);
    }
  fread (&info, sizeof (struct user), MAXUSERS, userfile);
  fclose (userfile);
}

void
  writeinfo ()
{
  FILE *userfile;
  char newfile[80];

  if ((userfile = fopen (BBSDATA, "wb")) == NULL)
    {
      printf ("Cannot open userfile, %s...exiting\n", BBSDATA);
      exit (1);
    }
  fwrite (&info, sizeof (struct user), MAXUSERS, userfile);
  fclose (userfile);
}

void
  changeinfo ()
{
  int i, p;
  char tmp[80];
  i = currentu;

  readinfo ();
  while (atoi (tmp) != 14)
    {
      print ("@61. @D[@C#a@D] @6[@0Alias@6]\n");
      print ("2. @D[@C#f #l@D] @6[@0Name@6]\n");
      print ("3. @D[@C#A@D] @6[@0Address@6]\n");
      print ("4. @D[@C#c@D] @6[@0City@6]\n");
      print ("5. @D[@C#s@D] @6[@0State@6]\n");
      print ("6. @D[@C#Z@D] @6[@0Zip Code@6]\n");
      print ("7. @D[@C#P@D] @6[@0Home Phone@6]\n");
      print ("8. @D[@C#D@D] @6[@0Data Phone@6]\n");
      print ("9. @D[@C#e@D] @6[@0Email Address@6]\n");
      print ("10. @D[@C#C@D] @6[@0User Comment@6]\n");
      print ("11. @D[@C#X@D] @6[@0Ansi?@6]\n");
      print ("12. @D[@C#Y@D] @6[@0Chat?@6]\n");
      print ("@613. @D[@CSave changes and Quit@D]\n");
      print ("@614. @D[@CQuit@D]\n");
      print ("@D-@6=@0> @C");
      fgets (tmp, 79, stdin);
      stripnl (tmp);
      if (strcmp (tmp, "1") == 0)
	change_alias ();
      if (strcmp (tmp, "2") == 0)
	change_name ();
      if (strcmp (tmp, "3") == 0)
	change_addr ();
      if (strcmp (tmp, "4") == 0)
	change_city ();
      if (strcmp (tmp, "5") == 0)
	change_state ();
      if (strcmp (tmp, "6") == 0)
	change_zipcode ();
      if (strcmp (tmp, "7") == 0)
	change_homephone ();
      if (strcmp (tmp, "8") == 0)
	change_dataphone ();
      if (strcmp (tmp, "9") == 0)
	change_email ();
      if (strcmp (tmp, "10") == 0)
	change_comment ();
      if (strcmp (tmp, "11") == 0)
	tog_ansi ();
      if (strcmp (tmp, "12") == 0)
	tog_chat ();
      if (strcmp (tmp, "13") == 0)
	{
	  writeinfo ();
	  strcpy (tmp, "14");
	}
    }
}

/* Sets currentu to the record number in the user datafile */
void
  getusernum ()
{
  int i = 0, x = 0, z = 0;
  char user[80];

  readinfo ();
  getuser (user);
  while (i < MAXUSERS)
    {
      if (strcmp (info[i].id, "") == 0)
	{
	  i++;
	  x++;
	}

      if (strcmp (info[i].id, user) == 0)
	{
	  z = 1;
	  break;
	}
      else
	{
	  z = 0;
	}
      i++;
      x++;
    }
  if (z == 0)
    {
      newuser = 1;
      adduser ();
    }
  if (z != 0)
    {
      currentu = x;
    }
}

void
  getuser (char *username)
{
  int i;

  User = getpwuid (getuid ());
  strcpy (username, User->pw_name);
}

void
  adduser ()
{
  FILE *userfile;
  int i = 0, z, enter;
  time_t t;
  char log[80], user[80];

  signal (SIGINT, exit);
  readinfo ();
  while (!(strcmp (info[i].id, "") == 0))
    {
      i++;
    }
  currentu = i;
/*  getuser(user);
 * strcpy (info[i].id, user); */
  print ("@FWelcome to #F, newuser.  You will need to enter some\n");
  print ("info.  No one but you and the sysop [#U] will be able to see");
  print (" it.\n");
  tog_ansi ();
  enter = getchar ();
  change_alias ();
  change_name ();
  change_addr ();
  change_city ();
  change_state ();
  change_zipcode ();
  change_homephone ();
  change_dataphone ();
  change_email ();
  change_comment ();
  info[i].seclev = NEWLEV;
  info[i].timeday = NEWUSERTIME;
  info[i].timeleft = NEWUSERTIME;
  time (&t);
  info[i].lastlogin = localtime (&t);
  change_editor ();
  tog_chat ();
  signal (SIGINT, logout);
  writeinfo ();
  changeinfo ();
  sprintf (log, "%s created a new account", info[currentu].id);
  sendtolog (log);
  writeinfo ();
}

void
  deluser ()
{
  char nul[80], in[80];
  int i;
  print ("@BEnter the user number you would like deleted: ");
  gets (in);
  i = atoi (in);

  readinfo ();
  strcpy (nul, "");
  strcpy (info[i].id, nul);
  strcpy (info[i].alias, nul);
  strcpy (info[i].firstname, nul);
  strcpy (info[i].lastname, nul);
  strcpy (info[i].address, nul);
  strcpy (info[i].city, nul);
  strcpy (info[i].state, nul);
  strcpy (info[i].zipcode, nul);
  strcpy (info[i].homephone, nul);
  strcpy (info[i].dataphone, nul);
  strcpy (info[i].email, nul);
  strcpy (info[i].comment, nul);
  info[i].seclev = 0;
  info[i].timeday = 0;
  info[i].timeleft = 0;
  info[i].lastlogin = 0;
  strcpy (info[i].editor, nul);
  info[i].chat = 0;
  info[i].ansi = 0;
  writeinfo ();
}
