/* This file is copyright 1996 by Matt Gischer (matt@fidalgo.net)
 * It is freely distributable for personal uses, but if you are employing
 * it for other things, you must first ask me.  I guess other than that, 
 * you should follow the GNU Public License.  thanks.  If you make any
 * changes/fixes, please mail them to me.  */
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>
#include "shaft.h"
#include "util.h"
#include "msg.h"

/* Writes whatever text it's given to the error log.. */
void sendtolog (char *in)
{
  FILE *logfile;
  char out[200], d[80];

  if ((logfile = fopen (ERRLOG, "a+")) == NULL)
    {
      printf ("Error writing to error log.. heh.. that's odd");
      exit (1);
    }
  getdate (d);
  sprintf (out, "%s %s\n", d, in);
  fputs (out, logfile);
  fclose (logfile);
}

/* Tells whether or not user has ANSI color enabled */
void AnsiStat ()
{
  if (info[currentu].ansi == 1)
    print ("You have @AA@BN@CS@DI\n");
  else
    printf ("Get ANSI, dude\n");
}

/* Yes/No prompt.. returns 1 for y and 0 for n */
int yesno ()
{
  int yn;
/* How do i use the ioctl system call to do this? */
  system ("stty -icanon");
  print ("@A(@BY@C/@En@D)@m ");
  yn = getchar ();
  system ("stty icanon");
  if (yn == 'y')
    {
      return 1;
    }
  if (yn == 'n')
    {
      return 0;
    }
}

/* Updates the date a user last logged on.. */
void updatelastlogin ()
{
  time_t now;

  info[currentu].lastlogin = time (&now);
  return;
}

/* Clears the screen */
void clr ()
{
  printf ("\033[H\033[J");
  return;
}

void stripnl (char *in)
{
  char *ptr;

  if (((int *)ptr = strchr (in, '\n')) != NULL)
    *ptr = '\0';
}

/* Change the pointer to upper case */
void toup (char *input)
{
  int i;
  char *tmp;
  tmp = malloc (strlen (input) * sizeof (char));

  for (i = 0; i < strlen (input); i++)
    {
      tmp[i] = toupper (input[i]);
      input[i] = tmp[i];
    }
}

void tolow (char *input)
{
  int i;
  char *tmp;
  tmp = malloc (strlen (input) * sizeof (char));

  for (i = 0; i < strlen (input); i++)
    {
      tmp[i] = tolower (input[i]);
      input[i] = tmp[i];
    }
}

void chatstat (char *lame, int i)
{
  if (info[i].chat == 1)
    strcpy (lame, "\033[1;31m*");
  else
    {
      strcpy (lame, "\033[1;30m*");
    }
}

/* Returns a random number between 0 and i */
int randnum (int i)
{
  double x = RAND_MAX + 1.0;
  int num;

  srand (time (NULL));
  num = 1 + rand () * (i / x);
  return num;
}

/* Returns the date in string format to a pointer */
void getdate (char *date)
{
  time_t t;
  struct tm *tmp;

  time (&t);
  tmp = localtime (&t);
  strftime (date, 80, "%c", tmp);
  return;
}

/* Returns the last login date to ll */
void getll (char *ll)
{
  time_t t;
  struct tm *tmp;

  t = info[currentu].lastlogin;
  tmp = localtime (&t);
  strftime (ll, 100, "%c", tmp);
  return;
}

/* Shows the current time */
void showtime ()
{
  char d[80];

  getdate (d);
  print ("@CIt is currently: @D#T@k\n");
  return;
}

void timecheck ()
{
  info[currentu].timeleft--;
  signal (SIGALRM, timecheck);
  alarm (60);
  if (info[currentu].timeleft == 5)
    {
      print ("\n@F[@DYou have 5 minutes remaining@F]\n");
    }
  if (info[currentu].timeleft == 2)
    {
      print ("\n@F[@DYou have 2 minutes remaining@F]\n");
    }
  if (info[currentu].timeleft == 1)
    {
      print ("\n@F[@DYou have 1 minute remaining@F]\n");
    }
  if (info[currentu].timeleft < 1)
    {
      print ("\n@F[@DYou're outta time, buddy@F]\n");
      logout ();
    }
  return;
}

/* Saves all current info and logs the user out */
void logout ()
{
  updatelastlogin ();
  writeinfo ();
  writelastmsgfile ();
  print ("@FThanks for visiting #F, #a.  Please come again.@k\n");
  exit (0);
}

/* Checks to see if the last time someone logged in was today..
 * if not, it resets their time */
void resettime ()
{
  char now[80], date[80], ll[80];
  time_t t;
  struct tm *tmp;
  struct tm *tmp2;

  time (&t);
  tmp = localtime (&t);
  strftime (date, 80, "%A", tmp);
  t = info[currentu].lastlogin;
  tmp2 = localtime (&t);
  strftime (ll, 80, "%A", tmp2);
  if ((strcmp (date, ll)) != 0)
    {
      info[currentu].timeleft = info[currentu].timeday;
    }
}
