#ifndef CONFIG_H
#define CONFIG_H

#define DEFAULT_MAX_ITER 128	
                                      /*default number of iterations should be set
				   lower for slow computers */
#define FPOINT_TYPE  double 
                                       /*floating point math type on computers
				   with medium speed floating point math should   
				   use float instead */
#define MITSHM			
                                       /*undefine this if you system does not
				   support shared memory */
#define MAXSTEP		0.008	
                                       /*zooming step. For slow computer should
				   be set lower. Longer steps takes more time
				   and invoke yet longer ones etc.. */
#define XSIZE		320	
                                       /*default sizes of window */
#define YSIZE		200

/* You don't need to change these lines unless you now what you are doing */

#undef DEBUG
#define FRAMERATE	20
#define LOOKSIZE 2		
				  /*size explored by autopilot */
#define MAXTIME 50		
				  /*maximum zooming time to one direction */
#define NGUESSES1 40		
				/*maximum number of guesses using first
				   method */
#define NGUESSES2 1000		
				/*maximum number of guesses using second
				   method */
#define STEP		0.0006	
				/*speedup */
#define SPEEDUP		1.5	
				/*speedup of speedup */

#ifdef __GNUC__
#define myfabs(x) fabs(x)
#define CONST const
#define INLINE __inline__
#ifndef __STRICT_ANSI__
#define CONSTF __attribute__ ((const))
#define REGISTERS(n) __attribute__ ((regparm(n)))
#else
#warning Remove -ansi switch from your Makefile to get better code.
#define CONSTF
#define REGISTERS(n)
#endif
#else
#ifdef __cplusplus
#define CONST const
#define INLINE inline
#else
#define myfabs(x) ((x)>0?(x):-(x))
#ifdef ANSI_SOURCE
#define CONST const
#else
#define CONST
#endif
#define INLINE
#endif
#define CONSTF
#define REGISTERS(n)
#endif
#ifdef _plan9_
#define exit(i) exits("Unix exit called")
#define INT_MAX 0xEfffffff
		/*some better way?*/
#endif


/*Don't change following lines */

#undef SCROLLING		/* color scrolling is broken for now */
#define SIFT		(26)	/*fixed point parameters */
#define MAXCOLORS	256	/*number of colors */
#define MUL		(1<<SIFT)
extern int MAXITER;

typedef FPOINT_TYPE number_t;

#endif				/*CONFIG_H */
