#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <limits.h>
#include <signal.h>
#include "allegro.h"
#include <string.h>
#include "zoom.h"
#include "gif.h"
#include "ui.h"
#include "palette.h"
#include "ctrl87.h"

static int mode = -1;
static zoom_context *context;
static int mousex, mousey, mousebuttons;
static width = 640, height = 480;
static int currentbuff = 0;
static int ncolors = 0;
BITMAP *buffers[2];



/*make startup faster */
int _stklen = 8192;
/*int _crt0_startup_flags = _CRT0_FLAG_LOCK_MEMORY; */
void 
__crt0_load_environment_file (char *_app_name)
{
  return;
}

void 
__crt0_setup_arguments (void)
{
  return;
}

char **
__crt0_glob_function (char *_arg)
{
  return 0;
}


typedef struct GFX_MODE_DATA
{
  int w;
  int h;
  char *s;
}
GFX_MODE_DATA;




static GFX_MODE_DATA gfx_mode_data[] =
{
  {320, 200, "320x200"},
  {320, 240, "320x240"},
  {640, 400, "640x400"},
  {640, 480, "640x480"},
  {800, 600, "800x600"},
  {1024, 768, "1024x768"},
  {1280, 1024, "1280x1024"},
  {1600, 1200, "1600x1200"},
  {256, 200, "256x200"},
  {256, 224, "256x224"},
  {256, 240, "256x240"},
  {256, 256, "256x256"},
  {320, 400, "320x400"},
  {320, 480, "320x480"},
  {360, 200, "360x200"},
  {360, 240, "360x240"},
  {360, 270, "360x270",},
  {360, 360, "360x360"},
  {360, 400, "360x400"},
  {360, 480, "360x480"},
  {376, 282, "376x282"},
  {376, 308, "376x308"},
  {376, 564, "376x564"},
  {400, 150, "400x150"},
  {400, 300, "400x300"},
  {400, 600, "400x600"}
};




/* gfx_mode_getter:
 *  Listbox data getter routine for the graphics mode list.
 */
static char *
gfx_mode_getter (int index, int *list_size)
{

  if (index < 0)
    {
      if (list_size)
	*list_size = sizeof (gfx_mode_data) / sizeof (GFX_MODE_DATA);
      return NULL;
    }
  return gfx_mode_data[index].s;

}




/* gfx_card_getter:
 *  Listbox data getter routine for the graphics card list.
 */
static char *
gfx_card_getter (int index, int *list_size)
{

  static char *card[] =
  {
    "Autodetect",
    "VGA mode 13h",
    "Mode-X",
    "VESA 1.x",
    "VESA 2.0 (banked)",
    "VESA 2.0 (linear)",
    "VBE/AF",
    "Xtended mode",
    "ATI 18800/28800",
    "ATI mach64",
    "Cirrus 64xx",
    "Cirrus 54xx",
    "S3",
    "Trident",
    "Tseng ET3000",
    "Tseng ET4000",
    "Video-7"
  };


  if (index < 0)
    {
      if (list_size)
	*list_size = sizeof (card) / sizeof (char *);
      return NULL;

    }
  return card[index];

}




static DIALOG gfx_mode_dialog[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
  {d_shadow_box_proc, 0, 0, 280, 150, 0, 0, 0, 0, 0, 0, NULL},
  {d_ctext_proc, 140, 8, 1, 1, 0, 0, 0, 0, 0, 0, "Graphics Mode"},
  {d_button_proc, 184, 97, 80, 16, 0, 0, 0, D_EXIT, 0, 0, "OK"},
  {d_button_proc, 184, 119, 80, 16, 0, 0, 27, D_EXIT, 0, 0, "Cancel"},
  {d_list_proc, 16, 28, 152, 107, 0, 0, 0, D_EXIT, 0, 0, gfx_card_getter},
  {d_list_proc, 184, 28, 80, 59, 0, 0, 0, D_EXIT, 0, 0, gfx_mode_getter},
  {NULL}
};


#define GFX_CANCEL         3
#define GFX_DRIVER_LIST    4
#define GFX_MODE_LIST      5



/* gfx_mode_select:
 *  Displays the Allegro graphics mode selection dialog, which allows the
 *  user to select a screen mode and graphics card. Stores the selection
 *  in the three variables, and returns zero if it was closed with the 
 *  Cancel button, or non-zero if it was OK'd.
 *  It was modified to use 320x200 as default
 */
static int 
my_gfx_mode_select (int *card, int *w, int *h)
{

  int ret;
  clear_keybuf ();
  do
    {
    }
  while (mouse_b);

  centre_dialog (gfx_mode_dialog);
  set_dialog_color (gfx_mode_dialog, gui_fg_color, gui_bg_color);
  ret = do_dialog (gfx_mode_dialog, GFX_DRIVER_LIST);
  *card = gfx_mode_dialog[GFX_DRIVER_LIST].d1;

  *w = gfx_mode_data[gfx_mode_dialog[GFX_MODE_LIST].d1].w;
  *h = gfx_mode_data[gfx_mode_dialog[GFX_MODE_LIST].d1].h;

  if (ret == GFX_CANCEL)
    return FALSE;
  else
    return TRUE;

}



static void 
print (int x, int y, char *text)
{

  show_mouse (NULL);
  textout (screen, font, text, x, y, 255);
  show_mouse (screen);

}


static void 
display ()
{

  show_mouse (NULL);
  blit (buffers[currentbuff], screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  show_mouse (screen);

}
static PALETTE palette;


void 
set_gui_colors ()
{

  static RGB black =
  {0, 0, 0};
  static RGB grey =
  {48, 48, 48};
  static RGB white =
  {63, 63, 63};

  set_color (0, &black);
  set_color (16, &black);
  set_color (1, &grey);
  set_color (255, &white);
  gui_fg_color = 0;
  gui_bg_color = 1;
}



static int 
my_set_color (int r, int g, int b, int init)
{

  if (init)
    ncolors = 2;
  if (ncolors >= 255)
    return (-1);
  palette[ncolors].r = r / 4;
  palette[ncolors].g = g / 4;
  palette[ncolors].b = b / 4;
  set_color (ncolors, &palette[ncolors]);
  return (ncolors++);

}

static void 
fix_palette ()
{

  int i;
  for (i = 0; i < 2; i++)
    {
      palette[i].r = 0;
      palette[i].g = 0;
      palette[i].b = 0;
      set_color (i, &palette[i]);
    }
  palette[255].r = 63;
  palette[255].g = 63;
  palette[255].b = 63;
  set_color (255, &palette[255]);
  set_palette (palette);
}
static void 
myflip_buffers ()
{
  currentbuff ^= 1;
}


static void 
init_mode ()
{

  int i, high;
  int w, c, h, vh;

again:
  if ((!keypressed ()) && (!joy_b1) && (!joy_b2))
    {
      rest (500);
    }


  clear (screen);
  set_gui_colors ();

  if (!my_gfx_mode_select (&c, &w, &h))
    {
      goto again;
    }
  vh = h;
  if (set_gfx_mode (c, w, h, 0, 0) != 0)
    {
      set_gfx_mode (GFX_VGA, 320, 200, 0, 0);
      goto again;
    }
  width = SCREEN_W;
  height = SCREEN_H;
  buffers[0] = create_bitmap (SCREEN_W, SCREEN_H);
  buffers[1] = create_bitmap (SCREEN_W, SCREEN_H);
  clear (screen);
  show_mouse (screen);
  fix_palette ();
}


static void 
uninitialise ()
{

  text_mode (0);
  allegro_exit ();
  printf ("IMPORTANT NOTE\n\n"
  "One of the main purposes for making this port was to get some money for\n"
	  "buying better computer. XaoS on my 486 works too slowly. But later I decided\n"
	  "to release it freely to show GNU licence to MS-DOS users. So please if you like\n"
	  "this program and want to have more such software send small amount of money to:\n"
	  "Jan Hubicka\n"
	  "Dukeslkych bojovniku 1944\n"
	  "Tabor 390 03\n"
	  "Czech Republic\n\n"
	  "WWW PAGE: http://www.paru.cas.cz/~hubicka/XaoS\n"
	  "EMAIL:    hubicka@paru.cas.cz\n"
	  "TIP:      In xaos pres h for help :)\n\n"
	  "Press enter to continue\n"
    );
  getc (stdin);

}


static void 
resize ()
{

  destroy_bitmap (buffers[0]);
  destroy_bitmap (buffers[1]);
  show_mouse (NULL);
  init_mode ();
  currentbuff = 0;
  resize_to (context, width, height, buffers[0]->line[0], buffers[1]->line[0]);
  ui_updateparameters ();
  ui_message ();
  ui_do_fractal ();
  ui_tbreak ();
  fix_palette ();

}


static void 
main_loop (void)
{

  int lasta = 0;
  int lasts = 0;
  int lasti = 0;
  int lastc = 0;
  int lastf = 0;
  int lastup = 0;
  int lastdown = 0;
  int lastnum = 0, i;
  while (1)
    {
      mousex = mouse_x;
      mousey = mouse_y;
      mousebuttons = 0;
      if (mouse_b == 1)
	mousebuttons |= BUTTON1;
      if (mouse_b == 2)
	mousebuttons |= BUTTON3;
      if (mouse_b == 3 || mouse_b & 4)
	mousebuttons |= BUTTON2;
      ui_mouse (mousex, mousey, mousebuttons, (key[KEY_LEFT] != 0) + 2 * (key[KEY_RIGHT] != 0));

      if (key[1] || key[KEY_Q])
	return;
      if (key[KEY_P])
	{
	  mkpalette (context, my_set_color, 0);
	}

      if (key[KEY_H] || key[KEY_F1])
	{
	  ui_help ();
	}

      for (i = KEY_1; i < KEY_0; i++)
	{
	  int lastnum1 = lastnum;
	  lastnum = 0;
	  if (key[i])
	    {
	      if (!lastnum1)
		{
		  set_formula (context, i - KEY_1);
		  ui_updateparameters ();
		  ui_message ();
		  ui_do_fractal ();
		  ui_tbreak ();
		}
	      lastnum = 1;
	    }
	}

      if (key[KEY_I])
	{
	  if (!lasti)
	    ui_inverse ();
	  lasti = 1;
	}
      else
	lasti = 0;
      if (key[KEY_M])
	{
	  ui_mandelbrot (mousex, mousey);
	}

      if (key[KEY_A])
	{
	  if (!lasta)
	    ui_autopilot ();
	  lasta = 1;
	}
      else
	lasta = 0;
      if (key[KEY_C])
	{
	  if (!lastc)
	    ui_coloringmode ();
	  lastc = 1;
	}
      else
	lastc = 0;
      if (key[KEY_F])
	{
	  if (!lastf)
	    ui_incoloringmode ();
	  lastf = 1;
	}
      else
	lastf = 0;
      if (key[KEY_EQUALS])
	{
	  resize ();
	}
      if (key[KEY_S])
	{
	  if (!lasts)
	    {
	      ui_savefile ();
	    }
	  lasts = 1;
	}
      else
	lasts = 0;
      if (key[KEY_UP])
	{
	  if (!lastup)
	    ui_speedup ();
	  lastup = 1;
	}
      else
	lastup = 0;
      if (key[KEY_DOWN])
	{
	  if (!lastdown)
	    ui_slowdown ();
	  lastdown = 1;
	}
      else
	lastdown = 0;
    }
}


int 
main (int argc, char **argv)
{

  allegro_init ();
  _control87 (MCW_EM, MCW_EM);

  if (windows_version == 3)
    {
      printf ("\nYou seem to be running me under Windows 3.1. This is a Bad Thing.\nYour operating system is broken and needs to be replaced...\n\n");
      sleep (1);
    }
  install_keyboard ();
  install_mouse ();
  install_timer ();

  set_gfx_mode (GFX_VGA, 320, 200, 0, 0);
  signal (SIGFPE, SIG_IGN);
  fix_palette ();

  init_mode ();
  context = make_context (width, height, 0, 1, myflip_buffers, buffers[0]->line[0], buffers[1]->line[0]);
  set_formula (context, 0);
  ui_init (context, display, my_set_color, 0, print, 8);
  sleep (1);
  main_loop ();
  uninitialise ();
  exit (0);
}
