
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <sys/time.h>
#include <limits.h>
#include <vga.h>
#include <vgagl.h>
#include <vgamouse.h>
#include <vgakeyboard.h>
#include <string.h>
#include "vgakey.h"
#include "zoom.h"
#include "gif.h"
#include "ui.h"
#include "palette.h"

static int mode = -1;
static zoom_context *context;
static vga_modeinfo *info;
static int mousex, mousey, mousebuttons;
static width = 640, height = 480;
static int currentbuff = 0;
static int ncolors = 0;
GraphicsContext screen;
GraphicsContext buffers[2];
void *font;

static void print(int x, int y, char *text)
{
    gl_setcontext(&screen);
    gl_enableclipping();
    gl_write(x, y, text);
}

static void draw_mouse(int x, int y, int clear)
{
    static int oldx, oldy;

    if (x < 3)
	x = 3;
    if (y < 3)
	y = 3;
    if (x > width - 5)
	x = width - 5;
    if (y > height - 5)
	y = height - 5;
    if ((oldx != x || oldy != y) && clear) {
	gl_setcontext(&buffers[currentbuff]);
	gl_enableclipping();
	if (mode == G320x240x256
	    || mode == G320x400x256
	    || mode == G360x480x256)
	    gl_copyscreen(&screen);
	else
	    gl_copyboxtocontext(oldx - 3, oldy - 3, 8, 8, &screen, oldx - 3, oldy - 3);
    }
    vga_setcolor(255);
    vga_drawline(x - 3, y - 3, x + 3, y + 3);
    vga_drawline(x - 3, y + 3, x + 3, y - 3);
    vga_setcolor(0);
    vga_drawline(x + 1 - 3, y - 3, x + 1 + 3, y + 3);
    vga_drawline(x + 1 - 3, y + 3, x + 1 + 3, y - 3);
    oldx = x;
    oldy = y;
}

static void display()
{
    /*sleep(1); */
    gl_setcontext(&buffers[currentbuff]);
    gl_copyscreen(&screen);
    draw_mouse(mousex, mousey, 0);
}

static int set_color(int r, int g, int b, int init)
{
    if (init)
	ncolors = 1;
    if (ncolors == 255)
	return (-1);
    gl_setpalettecolor(ncolors, r / 4, g / 4, b / 4);
    return (ncolors++);
}

static void fix_palette()
{
    int i;

    for (i = 0; i < 255; i++)
	gl_setpalettecolor(i, context->cmap[0][i] / 4, context->cmap[1][i] / 4, context->cmap[2][i] / 4);
    gl_setpalettecolor(255, 63, 63, 63);
}

static void myflip_buffers()
{
    currentbuff ^= 1;
}

static void init_mode()
{
    int i, high;

    while (mode == -1) {
	printf("Choose one of the following video modes: \n");
	high = 0;
	for (i = 1; i <= GLASTMODE; i++)
	    if (vga_hasmode(i)) {
		char expl[100];
		char *cols = NULL;
		*expl = '\0';
		info = vga_getmodeinfo(i);
		if (info->colors != 256)
		    continue;
		if (i == G320x200x256)
		    strcpy(expl, "packed-pixel");
		else if (i == G320x240x256
			 || i == G320x400x256
			 || i == G360x480x256)
		    strcpy(expl, "Mode X");
		else
		    strcpy(expl,
			   "packed-pixel, banked");
		if (info->flags & IS_INTERLACED) {
		    if (*expl != '\0')
			strcat(expl, ", ");
		    strcat(expl, "interlaced");
		}
		if (info->flags & IS_DYNAMICMODE) {
		    if (*expl != '\0')
			strcat(expl, ", ");
		    strcat(expl, "dynamically loaded");
		}
		high = i;
		printf("%5d: %dx%d, ",
		       i, info->width, info->height);
		if (cols == NULL)
		    printf("%d", info->colors);
		else
		    printf("%s", cols);
		printf(" colors ");
		if (*expl != '\0')
		    printf("(%s)", expl);
		printf("\n");
	    }
	printf("Enter mode number (1-%d): ", high);
	scanf("%d", &mode);
	getchar();
	printf("\n");
	if (mode < 1 || mode > GLASTMODE) {
	    printf("Error: Mode number out of range \n");
	    mode = -1;
	    continue;
	}
	if (!vga_hasmode(mode)) {
	    printf("Error: Video mode not supported by driver\n");
	    mode = -1;
	    continue;
	}
	info = vga_getmodeinfo(mode);
	if (info->colors != 256) {
	    printf("Error: Only 256 color modes supported\n");
	    mode = -1;
	    continue;
	}
    }
    width = info->width;
    height = info->height;
    vga_setmode(mode);
    gl_setcontextvga(mode);
    gl_getcontext(&screen);
    gl_setcontextvgavirtual(mode);
    gl_getcontext(&buffers[0]);
    gl_setcontextvgavirtual(mode);
    gl_getcontext(&buffers[1]);
    keyboard_init();
    keyboard_translatekeys(1);
    gl_setpalettecolor(255, 63, 63, 63);
    gl_setpalettecolor(0, 0, 0, 0);
}

static void uninitialise()
{
    gl_freecontext(&screen);
    gl_freecontext(&buffers[0]);
    gl_freecontext(&buffers[1]);
    keyboard_close();
    vga_setmode(TEXT);

}

static void resize()
{
    uninitialise();
    mode = -1;
    init_mode();
    currentbuff = 0;
    resize_to(context, width, height, buffers[0].vbuf, buffers[1].vbuf);
    ui_updateparameters();
    ui_message();
    ui_do_fractal();
    ui_tbreak();
    fix_palette();
}

static void main_loop(void)
{
    int lasta = 0;
    int lasts = 0;
    int lasti = 0;
    int lastc = 0;
    int lastf = 0;
    int lastup = 0;
    int lastdown = 0;
    int lastnum = 0, i;

    while (1) {
	mouse_update();
	keyboard_update();
	mousex = mouse_getx();
	mousey = mouse_gety();
	mousebuttons = 0;
	if (mouse_getbutton() == MOUSE_LEFTBUTTON)
	    mousebuttons |= BUTTON1;
	if (mouse_getbutton() == MOUSE_RIGHTBUTTON)
	    mousebuttons |= BUTTON3;
	if (mouse_getbutton() & MOUSE_MIDDLEBUTTON || mouse_getbutton() == (MOUSE_LEFTBUTTON | MOUSE_RIGHTBUTTON))
	    mousebuttons |= BUTTON2;
	draw_mouse(mouse_getx(), mouse_gety(), 1);
	ui_mouse(mousex, mousey, mousebuttons, keyboard_keypressed(SCANCODE1_CURSORLEFT) + 2 * keyboard_keypressed(SCANCODE1_CURSORRIGHT));
	if (keyboard_keypressed(1) || keyboard_keypressed(SCANCODE1_Q))
	    exit(0);
	if (keyboard_keypressed(SCANCODE1_P)) {
	    mkpalette(context, set_color, 0);
	}
	if (keyboard_keypressed(SCANCODE1_H)) {
	    ui_help();
	}
	for (i = SCANCODE1_1; i < SCANCODE1_0; i++) {
	    int lastnum1 = lastnum;
	    lastnum = 0;
	    if (keyboard_keypressed(i)) {
		if (!lastnum1) {
		    set_formula(context, i - SCANCODE1_1);
		    ui_updateparameters();
		    ui_message();
		    ui_do_fractal();
		    ui_tbreak();
		}
		lastnum = 1;
	    }
	}
	if (keyboard_keypressed(SCANCODE1_I)) {
	    if (!lasti)
		ui_inverse();
	    lasti = 1;
	} else
	    lasti = 0;
	if (keyboard_keypressed(SCANCODE1_M)) {
	    ui_mandelbrot(mousex, mousey);
	}
	if (keyboard_keypressed(SCANCODE1_A)) {
	    if (!lasta)
		ui_autopilot();
	    lasta = 1;
	} else
	    lasta = 0;
	if (keyboard_keypressed(SCANCODE1_C)) {
	    if (!lastc)
		ui_coloringmode();
	    lastc = 1;
	} else
	    lastc = 0;
	if (keyboard_keypressed(SCANCODE1_F)) {
	    if (!lastf)
		ui_incoloringmode();
	    lastf = 1;
	} else
	    lastf = 0;
	if (keyboard_keypressed(SCANCODE1_EQUAL)) {
	    resize();
	}
	if (keyboard_keypressed(SCANCODE1_S)) {
	    if (!lasts) {
		ui_savefile();
	    }
	    lasts = 1;
	} else
	    lasts = 0;
	if (keyboard_keypressed(SCANCODE1_CURSORUP)) {
	    if (!lastup)
		ui_speedup();
	    lastup = 1;
	} else
	    lastup = 0;
	if (keyboard_keypressed(SCANCODE1_CURSORDOWN)) {
	    if (!lastdown)
		ui_slowdown();
	    lastdown = 1;
	} else
	    lastdown = 0;
    }
}

int main(int argc, char **argv)
{
    vga_setmousesupport(1);
    vga_init();
    init_mode();
    font = (char *) malloc(256 * 8 * 8);
    gl_expandfont(8, 8, 255, gl_font8x8, font);
    gl_setfont(8, 8, font);
    gl_write(0, 0 + 8, "test");
    context = make_context(width, height, 0, 1, myflip_buffers, buffers[0].vbuf, buffers[1].vbuf);
    set_formula(context, 0);
    ui_init(context, display, set_color, 0, print, 8);
    main_loop();
    uninitialise();
    return (0);
}
