#ifndef XAOS_X11_H
#define XAOS_X11_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include "config.h"
#ifdef MITSHM
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif				/* MITSHM */

typedef struct {
    int n;
    XColor c[256];
} xcol_t;

typedef struct {
    Colormap colormap;
    Display *display;
    Window parent_window;
    Window window;
    unsigned int width, height;
    unsigned int border_width;
    unsigned long background;
    int depth;
    unsigned int class;
    Visual *visual;
    unsigned long valuemask;
    XSetWindowAttributes *attributes;
    unsigned long attr_mask;
    XSizeHints sizehints;
    int screen;
    char *window_name;
    int status;
    GC gc;
    XGCValues xgcvalues;
    xcol_t xcolor;
    Pixmap pixmap;
    XFontStruct *font_struct;
    int screen_changed;
    int lastx, lasty;
    int mouse_x, mouse_y;
    unsigned int mouse_buttons;
    int current;
    XImage *image[2];
#ifdef MITSHM
    XShmSegmentInfo xshminfo[2];
    int SharedMemOption;
    int SharedMemFlag;
#endif				/* MITSHM */
    char *vbuffs[2];
    char *vbuff;
    char *back;
    int linewidth;
} xdisplay;

extern INLINE int alloc_shm_image(xdisplay * d);
extern INLINE void free_shm_image(xdisplay * d);
extern INLINE int alloc_image(xdisplay * d);
extern INLINE void free_image(xdisplay * d);
extern INLINE int xupdate_size(xdisplay * d);
extern INLINE void xflip_buffers(xdisplay * d);
extern INLINE xdisplay *xalloc_display(char *n, int x, int y);
extern INLINE void xfree_display(xdisplay * d);
extern INLINE void xsetcolor(xdisplay * d, int col);
extern INLINE int xsetfont(xdisplay * d, char *font_name);
extern INLINE int xalloc_color(xdisplay * d, int r, int g, int b, int readwrite);
extern INLINE void xfree_colors(xdisplay * d);
extern INLINE void xline(xdisplay * d, int x1, int y1, int x2, int y2);
extern INLINE void xmoveto(xdisplay * d, int x, int y);
extern INLINE void xlineto(xdisplay * d, int x, int y);
extern INLINE void xrect(xdisplay * d, int x1, int y1, int x2, int y2);
extern INLINE void xfillrect(xdisplay * d, int x1, int y1, int x2, int y2);
extern INLINE void xarc(xdisplay * d, int x, int y, unsigned int w,
			unsigned int h, int a1, int a2);
extern INLINE void xfillarc(xdisplay * d, int x, int y, unsigned int w,
			    unsigned int h, int a1, int a2);
extern INLINE void xpoint(xdisplay * d, int x, int y);
extern INLINE void xflush(xdisplay * d);
extern INLINE void xclear_screen(xdisplay * d);
extern INLINE void draw_screen(xdisplay * d);
extern INLINE void xouttext(xdisplay * d, char *string);
extern INLINE void xresize(xdisplay * d, XEvent * ev);
extern INLINE int xmouse_x(xdisplay * d);
extern INLINE int xmouse_y(xdisplay * d);
extern INLINE void xmouse_update(xdisplay * d);
extern INLINE unsigned int xmouse_buttons(xdisplay * d);

#endif				/* XAOS_X11_H */
