#ifdef _plan9_
#include <u.h>
#include <libc.h>
#include <stdio.h>
#else
#include <stdio.h>
#include <malloc.h>
#include <limits.h>
#include <math.h>
#include <string.h>
#ifdef HAVE_ALLOCA
#include <alloca.h>
#endif
#endif
#include "zoom.h"
#include "complex.h"
#include "formulas.h"
#include "plane.h"

int MAXITER = DEFAULT_MAX_ITER;

typedef struct {
    double y0, k, kk, y0k;
} symetry2;

struct symetryinfo2 {
    number_t xsym, ysym;
    int nsymetries;
    symetry2 *symetry;
};

static symetry2 sym_lines[100];
static struct symetryinfo2 cursymetry;
static number_t xmul, ymul, xdist, ydist;

#ifdef SCROLLING
int counter = 0;
#else
#define counter 0
#endif
static zoom_context *d;
static int INLINE calculate(number_t, number_t) CONSTF;
#ifdef DEBUG
int mirrored2 = 0;
#endif

static int INLINE symetries(number_t x, number_t y)
{
    int i;

    for (i = 0; i < cursymetry.nsymetries; i++) {
	double b = cursymetry.symetry[i].k, c = x + b * y, x1, y1, dist;
	int x2, y2;
	x1 = (c - cursymetry.symetry[i].y0k) / (cursymetry.symetry[i].kk);
	y1 = (c - x1) / b;
	x1 = x - 2 * (x - x1);
	y1 = y - 2 * (y - y1);
	if (x1 < d->s.nc || y1 < d->s.ni || x1 >= d->s.mc || y1 >= d->s.mi)
	    continue;

	x2 = (x1 - d->s.nc) * xmul;
	y2 = (y1 - d->s.ni) * ymul;

	dist = myfabs(d->reallocx[x2].possition - x1);
	if (x2 > 0 && myfabs(d->reallocx[x2 - 1].possition - x1) < dist) {
	    x2--;
	    dist = myfabs(d->reallocx[x2].possition - x1);
	} else if (x2 < d->width - 1 && myfabs(d->reallocx[x2 + 1].possition - x1) < dist) {
	    x2++;
	    dist = myfabs(d->reallocx[x2].possition - x1);
	}
	if (dist > xdist)
	    continue;
	dist = myfabs(d->reallocy[y2].possition - y1);
	if (y2 > 0 && myfabs(d->reallocy[y2 - 1].possition - y1) < dist) {
	    y2--;
	    dist = myfabs(d->reallocy[y2].possition - y1);
	} else if (y2 < d->height - 1 && myfabs(d->reallocy[y2 + 1].possition - y1) < dist) {
	    y2++;
	    dist = myfabs(d->reallocy[y2].possition - y1);
	}
	if (dist > ydist)
	    continue;
	if (d->reallocx[x2].symto != -1)
	    x2 = d->reallocx[x2].symto;
	if (d->reallocy[y2].symto != -1)
	    y2 = d->reallocy[y2].symto;
	if (d->reallocx[x2].recalculate ||
	    d->reallocy[y2].recalculate == 1)
	    continue;
#ifdef DEBUG
	mirrored2++;
#endif
	return ((unsigned char) *(d->vbuff + x2 + y2 * d->width));
    }
    return (-1);
}

static int INLINE calculate(number_t x, number_t y)
{
    int i;

    i = symetries(x, y);
    if (i != -1)
	return (i);
    if (d->plane) {
	recalculate(d, &x, &y);
    }
    if (d->mandelbrot)
	i = d->currentformula->calculate(x, y, x, y);
    else
	i = d->currentformula->calculate(x, y, d->pre, d->pim);
    if (i < 0)
	i += (-i / d->num_colors + 1) * d->num_colors;
    if (i == MAXITER)
	return d->colors[0];
    return (d->colors[1 + (i + counter) % (d->num_colors - 1)]);
}

static INLINE void mkrealloc_table(number_t * pos, struct realloc *realloc, CONST int size, CONST number_t begin, CONST number_t end, CONST number_t sym)
{
    int i;
    number_t y, lastpos = -9999;
    struct realloc *r = realloc, *reallocs;
#ifdef DEBUG
    int nadded = 0, nsymetry = 0, nskipped = 0;
#endif
    number_t step = (end - begin) / (number_t) size;
    int plus = 0;
    int symi = -1;

    y = begin;
    if (begin > sym)
	symi = -2;
    for (i = 0; i < size; i++, realloc++) {
	realloc->recalculate = 0;
	realloc->dirty = 0;
	realloc->symto = -1;
	realloc->symref = -1;
	if (y > sym && symi == -1)
	    symi = i - 1;
	if (plus < size)
	    realloc->plus = plus;
	else
	    realloc->plus = size - 1;
	while ( /* *pos < y - step */ 0) {
	    pos++, plus++;
#ifdef DEBUG
	    nskipped++;
#endif
	}
	while (plus < size && (*pos < y - 1.5 * step || *pos < lastpos || (plus > size - 4 && *(pos + 1) < y + 0.5 * step) || (*(pos + 1) < y + step / 2 && myfabs(*pos - y) > myfabs(*(pos + 1) - y) && myfabs(*(pos + 1) - y) < myfabs(*(pos + 1) - y - step) && *(pos + 2) < y + 1.5 * step && *(pos + 3) < y + 2.5 * step))) {
	    pos++, plus++;
#ifdef DEBUG
	    nskipped++;
#endif
	}
	if (*pos >= lastpos && *pos >= y - 1.5 * step && (*pos < y + step || (*pos < y + 1.5 * step && (*(pos + 1) < y + 2 * step || *(pos + 3) < y + 3 * step || *(pos + 4) < y + 4.5 * step || *(pos + 5) < y + 5.5 * step)))) {
	    realloc->possition = *pos;
	    realloc->plus = plus;
	    if (i < size - 5 && i > 5 && *(pos + 1) < end)
		pos++, plus++;
	} else {
#ifdef DEBUG
	    nadded++;
#endif
	    realloc->recalculate = 1;
	    realloc->dirty = 1;
	    realloc->possition = y;
	}
	y += step;
	lastpos = realloc->possition;
    }
    realloc = r;
    realloc++;
    for (i = 1; i <= symi; i++, realloc++) {
	int j, min = 0;
	number_t dist = INT_MAX, tmp;
	if (realloc->symto != -1)
	    continue;
	y = realloc->possition;
	realloc->symto = 2 * symi - i;
	if (realloc->symto >= size - 1)
	    realloc->symto = size - 2;
	dist = myfabs(2 * sym - r[realloc->symto].possition - y), min = j;
	min = -10;
	for (j = realloc->symto > 2 ? -2 : 0; j < 3 && realloc->symto + j < size - 1; j++) {
	    if ((tmp = myfabs(2 * sym - r[realloc->symto + j].possition - y)) < dist) {
		if (2 * sym - r[realloc->symto + j].possition > (realloc - 1)->possition && ( /*i==symi-1|| */ (2 * sym - r[realloc->symto + j].possition < (realloc + 1)->possition))) {
		    dist = tmp;
		    min = j;
		}
	    }
	}
	realloc->symto += min;
	if (realloc->symto <= symi || min == 10) {
	    realloc->symto = -1;
	    continue;
	}
	reallocs = &r[realloc->symto];
	if (reallocs->symto != -1 || reallocs->symref != -1) {
	    realloc->symto = -1;
	    continue;
	}
	if (myfabs(realloc->possition - (2 * sym - reallocs->possition)) < step * 3 / 4) {
	    if (!realloc->recalculate) {
		realloc->symto = -1;
		if (reallocs->symto != -1 || (
						 !reallocs->recalculate		/*&&
										   realloc->possition!=2*sym-reallocs->possition */ ))
		    continue;
		reallocs->plus = i;
		reallocs->symto = i;
		reallocs->dirty = 1;
		realloc->symref = reallocs - r;
		/*reallocs->dirty = realloc->dirty; */
#ifdef DEBUG
		nadded -= reallocs->recalculate;
#endif
		reallocs->recalculate = 0;
		reallocs->possition = 2 * sym - realloc->possition;
	    } else {
		if (reallocs->symto != -1) {
		    realloc->symto = -1;
		    continue;
		}
#ifdef DEBUG
		nadded -= realloc->recalculate;
#endif
		realloc->dirty = 1;
		/*realloc->dirty = reallocs->dirty; */
		realloc->plus = realloc->symto;
		realloc->recalculate = 0;
		reallocs->symref = i;
		realloc->possition = 2 * sym - reallocs->possition;
	    }
#ifdef DEBUG
	    nsymetry++;
#endif
	} else
	    realloc->symto = -1;
    }
    realloc = r + 1;
    for (i = 1; i < size - 1; i++, realloc++) {
	if (realloc->recalculate && (!(realloc - 1)->recalculate || !(realloc + 1)->recalculate)) {
	    realloc->possition = ((realloc - 1)->possition + (realloc + 1)->possition) / 2;
	}
    }
#ifdef DEBUG
    printf("%i added %i skipped %i mirrored\n", nadded, nskipped, nsymetry);
#endif
}


static INLINE void moveoldpoints(void)
{
    char *vline, *vbuff = d->vbuff;
    int *size, *siz, *sizend;
    int *start, *startptr;
    struct realloc *ry, *rend;
    struct realloc *rx, *rend1;
    int plus1 = 0, plus2 = 0;

#ifdef HAVEALLOCA
    size = (int *) alloca(d->width * sizeof(int));
    start = (int *) alloca(d->width * sizeof(int));
#else
    size = (int *) malloc(d->width * sizeof(int));
    start = (int *) malloc(d->width * sizeof(int));
#endif

    startptr = start;
    siz = size;
    for (rx = d->reallocx, rend1 = d->reallocx + d->width;
	 rx < rend1; rx++)
	if ((rx->recalculate) && plus1 < d->width + 1)
	    plus1++;
	else
	    break;
    *startptr = d->reallocx->plus;
    *siz = 0;
    for (; rx < rend1; rx++) {
	if ((rx->recalculate || rx->plus == *startptr + *siz) && *startptr + *siz < d->width)
	    (*siz)++;
	else {
	    siz++, startptr++;
	    if (rx->recalculate) {
		*startptr = 0;
		ry = rx;
		for (; rx < rend1; rx++)
		    if (rx->recalculate)
			(*startptr)--;
		    else
			break;
		if (rx < rend1)
		    *startptr += rx->plus, rx = ry;
		else {
		    plus2 = -(*startptr);
		    startptr--;
		    siz--;
		    break;
		}
	    }
	    *startptr = rx->plus;
	    *siz = 1;
	}

    }
    if (*siz)
	sizend = siz + 1;
    else
	sizend = siz;
#ifdef DEBUG
    printf("nsegments:%i plus1:%i plus2:%i\n", sizend - size, plus1, plus2);
#endif
    for (ry = d->reallocy, rend = ry + d->height; ry < rend; ry++) {
	vline = d->back + ry->plus * d->width;
	if (!ry->recalculate) {
	    vbuff += plus1;
	    for (startptr = start, siz = size; siz < sizend; siz++, startptr++)
		memcpy(vbuff, vline + *startptr, *siz), vbuff += *siz;
	    vbuff += plus2;
	} else
	    vbuff += d->width;
    }
#ifndef HAVEALLOCA
    free((void *) size);
    free((void *) start);
#endif
}


static INLINE void calculatenew(void)
{
    number_t x, y;
    int s;
    char *vbuff = d->vbuff;
    struct realloc *rx, *ry, *rend, *rend1;
#ifdef DEBUG
    int tocalculate = 0;
    int avoided = 0;
    /*int s2; */
    mirrored2 = 0;
#endif


    for (s = 0; s < 2; s++) {
	vbuff = d->vbuff + s * d->width;
	for (ry = d->reallocy + s, rend = ry + d->height; ry < rend; ry += 2) {
	    if (ry->recalculate) {
		y = ry->possition;
		for (rx = d->reallocx, rend1 = rx + d->width;
		     rx < rend1; rx++) {
		    if (!rx->dirty /*!rx->recalculate && rx->symto == -1 */ ) {
#ifdef DEBUG
			tocalculate++;
#endif
			if (ry != d->reallocy && ry < rend - 2 &&
			    rx != d->reallocx && rx < rend1 - 2 &&
			    !(ry - 1)->dirty &&
			    !(ry + 1)->dirty &&
			    (vbuff[-d->width] == vbuff[d->width] &&
			     (
				 (s == 0 &&
			       vbuff[-d->width + 1] == vbuff[d->width] &&
			       vbuff[-d->width - 1] == vbuff[d->width] &&
				vbuff[d->width] == vbuff[d->width - 1] &&
				  vbuff[d->width] == vbuff[d->width + 1]
				 ) || (s == 1 &&
				       vbuff[-1] == vbuff[d->width] &&
				       vbuff[+1] == vbuff[d->width]
				 )
			     ))) {
			    *vbuff = vbuff[d->width];
#ifdef DEBUG
			    avoided++;
#endif
			} else {
			    /*s2=mirrored2; */
			    *vbuff = calculate(rx->possition, y);
			    /*if(s2==mirrored2) vga_drawpixel(rx-d->reallocx,ry-d->reallocy,255); */
			}
		    }
		    vbuff++;
		    ry->dirty = 0;
		}
		ry->recalculate = 2;
	    } else		/*if recalculate */
		vbuff += d->width;
	    vbuff += d->width;
	}			/*for ry */
    }				/*for s */
    for (s = 0; s < 2; s++) {
	vbuff = d->vbuff + s;
	for (rx = d->reallocx + s, rend = rx + d->width; rx < rend; rx += 2) {
	    if (rx->recalculate) {
		x = rx->possition;
		for (ry = d->reallocy, rend1 = ry + d->height; ry < rend1; ry++) {
		    if (ry->symto == -1) {
#ifdef DEBUG
			tocalculate++;
#endif
			if (rx != d->reallocx && rx < rend - 2 &&
			    ry != d->reallocy && ry < rend1 - 2 &&
			    !(rx - 1)->dirty &&
			    !(rx + 1)->dirty &&
			    (vbuff[-1] == vbuff[1] && (
							  (s == 0 &&
				      vbuff[-1 + d->width] == vbuff[1] &&
				      vbuff[-1 - d->width] == vbuff[1] &&
				      vbuff[-1] == vbuff[1 + d->width] &&
					vbuff[-1] == vbuff[1 - d->width])
							  || (s == 1 &&
					   vbuff[d->width] == vbuff[1] &&
					     vbuff[-d->width] == vbuff[1]
							  )
			     ))) {
#ifdef DEBUG
			    avoided++;
#endif
			    *vbuff = vbuff[1];
			} else {
			    /*s2=mirrored2; */
			    *vbuff = calculate(x, ry->possition);
			    /*if(s2==mirrored2) vga_drawpixel(rx-d->reallocx,ry-d->reallocy,255); */
			}
		    }
		    vbuff += d->width;
		    rx->dirty = 0;
		}
		rx->recalculate = 0;
		vbuff -= d->width * d->height - 2;
	    } else
		vbuff += 2;
	}
    }
#ifdef DEBUG
    printf("Avoided caluclating of %i points from %i and mirrored %i %2.2f%% %2.2f%%\n", avoided, tocalculate, mirrored2, 100.0 * (avoided + mirrored2) / tocalculate, 100.0 * (tocalculate - avoided - mirrored2) / d->width / d->height);
#endif
}


static INLINE void dosymetry(void)
{
    char *vbuff = d->vbuff;
    struct realloc *rx, *ry, *rend;

    vbuff = d->vbuff;
    for (ry = d->reallocy, rend = ry + d->height; ry < rend; ry++) {
	if (ry->symto != -1) {
	    memcpy(vbuff, d->vbuff + d->width * ry->symto, d->width * sizeof(*vbuff));
	}
	vbuff += d->width;
    }
    vbuff = d->vbuff;
    for (rx = d->reallocx, rend = rx + d->width; rx < rend; rx++) {
	if (rx->symto != -1) {
	    char *vsrc = d->vbuff + rx->symto, *vend = vbuff + d->width * d->height;
	    for (; vbuff < vend; vbuff += d->width, vsrc += d->width)
		*vbuff = *vsrc;
	    vbuff -= d->width * d->height;
	}
	vbuff++;
    }
}

static void combine_methods(void)
{
    int i, j;
    struct symetryinfo *s1 = d->currentformula->out + d->coloringmode,
    *s2 = d->currentformula->in + d->incoloringmode;
    if (d->mandelbrot != d->currentformula->mandelbrot) {
	cursymetry.xsym = INT_MAX;
	cursymetry.ysym = INT_MAX;
	cursymetry.nsymetries = 0;
	return;
    }
    xmul = d->width / (d->s.mc - d->s.nc);
    ymul = d->height / (d->s.mi - d->s.ni);
    xdist = (d->s.mc - d->s.nc) / d->width / 6;
    ydist = (d->s.mi - d->s.ni) / d->height / 6;
    if (s1->xsym == s2->xsym)
	cursymetry.xsym = s1->xsym;
    else
	cursymetry.xsym = INT_MAX;
    if (s1->ysym == s2->ysym)
	cursymetry.ysym = s1->ysym;
    else
	cursymetry.ysym = INT_MAX;
    if (d->plane == P_PARABOL)
	cursymetry.xsym = INT_MAX;
    if (d->plane == P_LAMBDA) {
	if (cursymetry.xsym == 0 && cursymetry.ysym == 0)
	    cursymetry.xsym = 1;
	else
	    cursymetry.xsym = INT_MAX;
    }
    if (d->plane == P_INVLAMBDA)
	cursymetry.xsym = INT_MAX;
    if (d->plane == P_TRANLAMBDA) {
	if (cursymetry.xsym != 0 || cursymetry.ysym != 0)
	    cursymetry.xsym = INT_MAX;
    }
    if (d->plane == P_MEREBERG)
	cursymetry.xsym = INT_MAX;
    cursymetry.symetry = sym_lines;
    cursymetry.nsymetries = 0;
    if (d->plane == P_PARABOL || d->plane == P_LAMBDA || d->plane == P_INVLAMBDA ||
	d->plane == P_TRANLAMBDA || d->plane == P_MEREBERG)
	return;
    for (i = 0; i < s1->nsymetries; i++) {
	number_t y1 = s1->symetry[i].y0 + d->s.nc * s1->symetry[i].k;
	number_t y2 = s1->symetry[i].y0 + d->s.mc * s1->symetry[i].k;
	if ((y1 > d->s.ni ? (y1 < d->s.mi || y2 < d->s.mi) :
	     y2 > d->s.ni)) {
	    for (j = 0; j < s2->nsymetries; j++) {
		if (s1->symetry[i].k == s2->symetry[j].k &&
		    s1->symetry[i].y0 == s2->symetry[j].y0) {
		    cursymetry.symetry[cursymetry.nsymetries].k = s1->symetry[i].k;
		    cursymetry.symetry[cursymetry.nsymetries].y0 = s1->symetry[i].y0;
		    cursymetry.symetry[cursymetry.nsymetries].kk = s1->symetry[i].k * s1->symetry[i].k + 1;
		    cursymetry.symetry[cursymetry.nsymetries++].y0k = s1->symetry[i].y0 * s1->symetry[i].k;
		}
	    }
	}
    }
}

void do_fractal(zoom_context * context)
{
    char *tmp;
    number_t *posptr;
    struct realloc *r, *rend;

    d = context;
    if (d->dirty)
	d->dirty--;
    combine_methods();
    d->switch_function();
    tmp = d->vbuff;
    d->vbuff = d->back;
    d->back = tmp;
    MAXITER = d->maxiter;
    coloringmode = d->coloringmode;
    incoloringmode = d->incoloringmode;
#ifdef SCROLLING
    counter++;
#endif

    mkrealloc_table(d->xpos, d->reallocx, d->width, d->s.nc, d->s.mc, cursymetry.xsym);
    mkrealloc_table(d->ypos, d->reallocy, d->height, d->s.ni, d->s.mi, cursymetry.ysym);

    for (r = d->reallocx, posptr = d->xpos, rend = d->reallocx + d->width;
	 r < rend; r++, posptr++)
	*posptr = r->possition;
    for (r = d->reallocy, posptr = d->ypos, rend = d->reallocy + d->height;
	 r < rend; r++, posptr++)
	*posptr = r->possition;
    moveoldpoints();
    calculatenew();
    dosymetry();
}


static void recalculate_view(zoom_context * c)
{
    double xs = c->s.mc - c->s.nc, ys = (c->s.mi - c->s.ni) / c->height * c->width,
     xc = (c->s.mc + c->s.nc) / 2, yc = (c->s.mi + c->s.ni) / 2, size;

    if (xs > ys)
	size = xs;
    else
	size = ys;
    c->s.nc = xc - size / 2;
    c->s.mc = xc + size / 2;
    c->s.ni = yc - size / 2 * c->height / c->width;
    c->s.mi = yc + size / 2 * c->height / c->width;
}
static void recalculate_view1(zoom_context * c)
{
    double xs = c->s.mc - c->s.nc, ys = (c->s.mi - c->s.ni) * 1024 / 768,
     xc = (c->s.mc + c->s.nc) / 2, yc = (c->s.mi + c->s.ni) / 2, size;

    if (xs > ys)
	size = xs;
    else
	size = ys;
    c->s.nc = xc - size / 2;
    c->s.mc = xc + size / 2;
    c->s.ni = yc - size / 2 * 768 / 1024;
    c->s.mi = yc + size / 2 * 768 / 1024;
}

void init_tables(zoom_context * c)
{
    int i;

    c->dirty = 2;
    for (i = 0; i < c->width + 1; i++)
	c->xpos[i] = INT_MAX;
    for (i = 0; i < c->height + 1; i++)
	c->ypos[i] = INT_MAX;
}

void set_formula(zoom_context * c, CONST int num)
{
    if (num >= nformulas)
	return;
    c->currentformula = formulas + num;
    c->mandelbrot = c->currentformula->mandelbrot;
    c->pre = c->currentformula->pre;
    c->pim = c->currentformula->pim;
    c->s.ni = c->currentformula->v.ni;
    c->s.nc = c->currentformula->v.nc;
    c->s.mi = c->currentformula->v.mi;
    c->s.mc = c->currentformula->v.mc;
    init_tables(c);
}

static void alloc_tables(zoom_context * c)
{
    c->xpos = (number_t *) malloc((c->width + 5) * sizeof(*c->xpos));
    c->ypos = (number_t *) malloc((c->height + 5) * sizeof(*c->ypos));
    c->reallocx = (struct realloc *) malloc(sizeof(struct realloc) * (c->width + 1));
    c->reallocy = (struct realloc *) malloc(sizeof(struct realloc) * (c->height + 1));
}

static void free_tables(zoom_context * c)
{
    free((void *) c->xpos);
    free((void *) c->ypos);
    free((void *) c->reallocx);
    free((void *) c->reallocy);
}

void resize_to(zoom_context * c, CONST int width, CONST int height, char *vbuff, char *back)
{
    free_tables(c);
    c->width = width;
    c->height = height;
    c->vbuff = vbuff;
    c->back = back;
    alloc_tables(c);
    init_tables(c);
}

void set_view(zoom_context * c, CONST vinfo * s)
{
    c->s = *s;
    if (c->fullscreen)
	recalculate_view1(c);
    else
	recalculate_view(c);
}

void free_context(zoom_context * c)
{
    free_tables(c);
    free((void *) c);
}

zoom_context *make_context(CONST int width, CONST int height, CONST int formula, CONST int full, void (*switchptr) (), char *vbuf, char *bckup)
{
    zoom_context *new;

    new = (zoom_context *) calloc(sizeof(zoom_context), 1);
    new->fullscreen = full;
    new->width = width;
    new->maxiter = DEFAULT_MAX_ITER;
    new->coloringmode = 0;
    new->height = height;
    new->vbuff = vbuf;
    new->back = bckup;
    new->switch_function = switchptr;
    alloc_tables(new);
    set_formula(new, formula);
    return (new);
}
