#ifndef ZOOM_H
#define ZOOM_H

#include "config.h"
#include "formulas.h"

struct realloc {
    number_t possition;
    int plus;
    int recalculate;
    int symto;
    int symref;
    int dirty;
};

typedef struct {
    void (*switch_function) (void);
    number_t *xpos, *ypos;
    int maxiter, coloringmode, incoloringmode;
    int mandelbrot;
    int fullscreen;
    number_t pre, pim;
    int plane;
    int dirty;
    int num_colors;
    unsigned char colors[MAXCOLORS];
    unsigned char cmap[3][MAXCOLORS];
    struct realloc *reallocx, *reallocy;
    struct formula *currentformula;
    int width, height;
    vinfo s;
    char *vbuff, *back;
} zoom_context;

void do_fractal(zoom_context *);
void set_formula(zoom_context *, CONST int);
void resize_to(zoom_context *, CONST int, CONST int, char *, char *);
void set_view(zoom_context *, CONST vinfo *);
void free_context(zoom_context *);
void init_tables(zoom_context *);
zoom_context *make_context(CONST int, CONST int, CONST int, CONST int, void (*)(), char *, char *);

#endif				/* ZOOM_H */
