/* This should be somewhere else, but where? */

#define __LIBRARY__
#include "/usr/src/linux/include/linux/unistd.h"

_syscall2(int,activate_cp,int,whichvc,int,whichcp)

_syscall2(int,progcp,int,whichcp,char *,data)

_syscall3(int,progsfchar,int,whichcp,char,whichchar,char *,newchar)

#undef __LIBRARY

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>



void die(char *message) {
  printf("addcp:  %s\n",message);
  exit(1);
}

void usage(void) {
  printf("usage:  addcp codepage-file codepage\n");
  exit(1);
}

int main(int argc,char **argv) {

  char cp_data[257*32];       /* here we store the codepage information */


  int whichcp = 0;
  int handle;

  unsigned int i;
  
  if (argc != 3) 
    usage();
  
  whichcp = atoi(argv[2]);

  if ((handle = open(argv[1], O_RDONLY)) < 0)
    die("Can't open input file");
  
  /*Now we read the .cp file, and extract the data we need. */
  /*Unfortunately, I don't know the real format of the .cp file, so I */
  /*have to hope that what I've used before is the only possibility. */

  read(handle,cp_data,40); /*Read and ignore 40 bytes of junk */
  read(handle,cp_data,256*16); /*Read and ignore the 16-byte font*/

  read(handle,cp_data,6); /*Read and ignore 6 more bytes of junk*/
  for (i=0 ; i < 256 ; i++) 
    read(handle,&(cp_data[i*32]),14); /*Finally, the real data! */
  close(handle);

  return(progcp(whichcp,cp_data));

}
