#!/bin/sh
# do tar with the following options:
# c - create, l - local file system
# v - verbose, V - Volume name:
# S - test for sparse files
echo Doing incremental backup of linux file system...
now=`date`
then=`cat dates/date.backup.linux`
title="incremental backup of / (Linux partition), from $then to $now"
logfile="logs/`date "+%y%m%d"`.linux.inc.log" 
echo >  $logfile
echo >>  $logfile
echo >>  $logfile
echo >>  $logfile
tail -f $logfile &
tar -clzvSf -\
	--block-compress \
	-V "$title"\
	-X excludes/linux.exclude\
	-N "$then" \
	/ \
	2>> $logfile |\
	dd  obs=4000k 2>>$logfile >/dev/tape
echo $now > dates/date.backup.linux
echo Ready.
echo Transcript written to $logfile .
