/* ZGV v1.3 - (c) 1993 Russell Marks for improbabledesigns.
 * See README for license details.
 *
 * rcfile.c - simple config file handling.
 *             I *really* mean simple. Like, it's very simplistic indeed.
 */

#include <stdio.h>
#include <stdlib.h>
#include <vga.h>
#include "rc_config.h"

#define boolvalue(x) ((x=='y')?1:0)
#define putbool(x) (x?'y':'n')

struct zgv_config cfg;


/* In zgv v1.3, the following options can be defined in the config file:
 * (and of course, in later versions since I'll forget to change the
 *  above line... :) )
 *
 * Description						Entry
 *
 * screen mode (1-9)  ('virtual' set appropriately)	'm='
 * zoom on/off						'z='
 * vkludge on/off					'v='
 * mode select on/off					's='
 *   (mode select is the code which
 *     1. switches to 640x480x16 if <= 16 colour GIF
 *     2. switches to 320x200x256 is GIF is 320x200.)
 * brightness (value to be added to colour value)	'b='
 * contrast (value to multiply colour value by)		'c='
 *
 * Actually you don't need an '='. Any character will do, except \n, ^d.
 *  Or Benny from Crossroads, that wasn't a very convincing character.
 *
 * Lines beginning with '#' are ignored (but you can't start a comment
 * halfway through a line). In fact lines beginning with any character
 * except one of 'mzvsbc' is ignored. Told you it was simple.
 *
 * 'on/off' boolean values are either 'y' or 'n'. Hence 'on/off'. !?
 *
 * The config file is $HOME/.zgvrc and is really only meant to be
 * generated by zgv with the save config option.
 *
 * No validation - the slightest error can cause bizarritudeinous
 * manifestations of the highest order.
 *
 * XXX - this all sucks big time and needs to be replaced
 */
 

getconfig()
{
FILE *in;
char cfgfile[1024];

strcpy(cfgfile,getenv("HOME"));
strcat(cfgfile,"/.zgvrc");
if((in=fopen(cfgfile,"r"))==NULL)
  defaultcfg();
else
  {
  parseconfig(in);
  fclose(in);
  }
}


parseconfig(in)
FILE *in;
{
char inpline[1024];

while(fgets(inpline,1024,in)!=NULL) 
  switch(inpline[0])
    {
    case 'm':  /* startup mode */
      cfg.videomode=atoi(inpline+2);
      break;
    case 'z':  /* zoom */
      cfg.zoom=boolvalue(inpline[2]);
      break;
    case 'v':  /* vkludge */
      cfg.vkludge=boolvalue(inpline[2]);
      break;
    case 's':  /* mode select */
      cfg.modesel=boolvalue(inpline[2]);
      break;
    case 'b':  /* brightness */
      cfg.brightness=atoi(inpline+2);
      break;
    case 'c':  /* contrast */
      cfg.contrast=atof(inpline+2);
      break;
    }
}


defaultcfg()
{
/* it'll use 360x480 if you haven't got this... */
cfg.videomode=G640x480x256;
cfg.zoom=0;
cfg.vkludge=0;
cfg.modesel=0;
cfg.brightness=0;
cfg.contrast=(double)1;
}


saveconfig()
{
FILE *out;
char cfgfile[1024];

strcpy(cfgfile,getenv("HOME"));
strcat(cfgfile,"/.zgvrc");
if((out=fopen(cfgfile,"w"))!=NULL)
  {
  fprintf(out,"# zgv config file - automatically generated\n\n");
  fprintf(out,"# NB x 2^N: small error = Big Problem\n"
              "# if you want to edit this file, bear in mind the following:\n"
              "#  1. don't.\n"
              "#  2. don't.\n"
              "# and MOST IMPORTANTLY...\n"
              "#  3. don't. Really. I'm not kidding.\n\n");
  fprintf(out,"# default video mode\n"
              "m=%d\n"
              "# zoom\n"
              "z=%c\n"
              "# virtual mode kludge\n"
              "v=%c\n"
              "# mode select code\n"
              "s=%c\n"
              "# brightness add\n"
              "b=%d\n"
              "# contrast multiplier\n"
              "c=%lf\n",
              cfg.videomode,putbool(cfg.zoom),putbool(cfg.vkludge),
              putbool(cfg.modesel),cfg.brightness,cfg.contrast);
  fclose(out);
  }
}
