/* xvSolitaire, version 1.0
 * Copyright (C) 1993  Andreas Almroth
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/cms.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/notice.h>
#include <xview/icon.h>
#include "sol_structs.h"
#include "sol_data.h"
#include "main_protos.h"

Server_image bild,tom;
#ifdef MONO_SCREEN
Server_image mono;
#endif
Frame frame,about;
Panel panel;
Xv_notice notice,madeit;
Cms cms;
int from = 0;
int max = 0, count;
int backup[81];

int main(int argc, char *argv[])
{
  Menu menu;
  Menu_item menu_item;
  Icon icon;

  xv_init(XV_INIT_ARGC_PTR_ARGV,&argc,argv,NULL);

  if (! (now = work = board = parse_resource())) {
    fprintf(stderr,"No boards loaded.\n");
    exit(1);
  }

  cms = (Cms)xv_create(XV_NULL,CMS,CMS_CONTROL_CMS,TRUE,
		       CMS_SIZE,CMS_CONTROL_COLORS + NUM_COLORS,
		       CMS_COLORS,colors,NULL);

  frame = (Frame)xv_create(XV_NULL,FRAME,FRAME_LABEL,"xvSolitaire",
			   FRAME_MAX_SIZE,600,580,FRAME_MIN_SIZE,600,580,
			   FRAME_SHOW_RESIZE_CORNER,FALSE,
			   XV_WIDTH,600,XV_HEIGHT,580,NULL);

  icon = (Icon)xv_create(frame,ICON,ICON_LABEL,"xvSol",NULL);

  xv_set(frame,FRAME_ICON,icon,NULL);

  about = (Frame)xv_create(frame,FRAME_CMD,XV_WIDTH,490,XV_HEIGHT,400,
			   FRAME_LABEL,"About xvSolitaire...",NULL);

  panel = (Panel)xv_get(about,FRAME_CMD_PANEL,NULL);

  xv_create(panel,PANEL_MULTILINE_TEXT,PANEL_DISPLAY_ROWS,30,
	    PANEL_VALUE_DISPLAY_LENGTH,65,PANEL_VALUE,info,
	    PANEL_READ_ONLY,TRUE,SCROLLBAR_VIEW_START,2,NULL);

  bild = (Server_image)xv_create(XV_NULL,SERVER_IMAGE,XV_WIDTH,bild3_width,
				 XV_DEPTH,2,XV_HEIGHT,bild3_height,
				 SERVER_IMAGE_BITS,bild3_bits,NULL);

  tom = (Server_image)xv_create(XV_NULL,SERVER_IMAGE,XV_WIDTH,tom_width,
				 XV_DEPTH,2,XV_HEIGHT,tom_height,
				 SERVER_IMAGE_BITS,tom_bits,NULL);

#ifdef MONO_SCREEN
  mono = (Server_image)xv_create(XV_NULL,SERVER_IMAGE,XV_WIDTH,mono_width,
				 XV_DEPTH,2,XV_HEIGHT,mono_height,
				 SERVER_IMAGE_BITS,mono_bits,NULL);
#endif

  panel = (Panel)xv_create(frame,PANEL,WIN_CMS,cms,XV_X,0,XV_Y,0,NULL);

  notice = (Xv_notice)xv_create(panel,NOTICE,NOTICE_MESSAGE_STRINGS,
				"No more moves, sorry...\n",NULL,
				NOTICE_BUTTON_YES,"Oki doki",NULL);

  madeit = (Xv_notice)xv_create(panel,NOTICE,NOTICE_MESSAGE_STRINGS,
				"Congratulations!\n","You made it...\n",NULL,
				NOTICE_BUTTON_YES,"Yees yees yeeees!",NULL);

  menu = (Menu)xv_create(XV_NULL,MENU,MENU_NOTIFY_PROC,proj_proc,MENU_STRINGS,
			 "New game","About","Quit",NULL,NULL);

  xv_create(panel,PANEL_BUTTON,PANEL_LABEL_STRING,"Project",
	    PANEL_ITEM_MENU,menu,NULL);

  menu = (Menu)xv_create(XV_NULL,MENU,NULL);

  while (work) {
    menu_item = (Menu_item)xv_create(XV_NULL,MENUITEM,
				     MENU_STRING,work->name,
				     MENU_NOTIFY_PROC,board_proc,
				     MENU_RELEASE,NULL);

    xv_set(menu,MENU_APPEND_ITEM,menu_item,NULL);

    next = work->next;
    work = next;
  }

  work = board;

  xv_create(panel,PANEL_BUTTON,PANEL_LABEL_STRING,"Boards",
	    PANEL_ITEM_MENU,menu,NULL);

  draw_board(now);

  xv_main_loop(frame);

  exit(0);
}

int proj_proc(Menu men,Menu_item item)
{
  if ( ! strcmp("New game",(char *)xv_get(item,MENU_STRING))) {
    destroy_board(now);
    draw_board(now);
    return XV_OK;
  }
  else if ( ! strcmp("About",(char *)xv_get(item,MENU_STRING))) {
    xv_set(about,XV_SHOW,TRUE,FRAME_CMD_PIN_STATE,FRAME_CMD_PIN_IN,NULL);

    return XV_OK;
  }
  else if ( ! strcmp("Quit",(char *)xv_get(item,MENU_STRING))) {
    xv_destroy_safe(frame);
    free_boards(board);
    exit(0);
  }
    
  return XV_OK;
}

int board_proc(Menu men,Menu_item item)
{
  while (work) {
    if ( ! strcmp(work->name,(char *)xv_get(item,MENU_STRING))) {
      destroy_board(now);
      draw_board(work);
      now = work;
      work = board;
      return XV_OK;
    }

    next = work->next;
    work = next;
  }
  return XV_OK;
}

int move_ball(Panel_item item,Event event)
{
  int loop;

  for (loop = 0 ; loop < 81 ; loop++) {
    if (now->item[loop] == item) {
      if (loop == from) {
	from = 0;
#ifdef MONO_SCREEN
	xv_set(now->item[loop],PANEL_LABEL_IMAGE,bild,NULL);
#else
	xv_set(now->item[loop],PANEL_ITEM_COLOR,CMS_CONTROL_COLORS + BLUE,
	       NULL);
#endif
	return XV_OK;
      }
      else if (! from) {
	if (now->data[loop] == 1) from = loop;
#ifdef MONO_SCREEN
	xv_set(now->item[loop],PANEL_LABEL_IMAGE,mono,NULL);
#else
	xv_set(now->item[loop],PANEL_ITEM_COLOR,CMS_CONTROL_COLORS+YELLOW,NULL);
#endif
      }
      else {
	if (loop - from == 2 && now->data[loop - 1] == 1 &&
	    now->data[loop] == 0) /* Move right */
	  update_board(from,loop - 1, loop);
	else if (from - loop == 2 && now->data[loop + 1] == 1 &&
	    now->data[loop] == 0) /* Move left */
	  update_board(from,loop + 1,loop);
	else if (loop - from == 18 && now->data[loop - 9] == 1 &&
	    now->data[loop] == 0) /* Move down */
	  update_board(from,loop - 9,loop);
	else if (from - loop == 18 && now->data[loop + 9] == 1 &&
	    now->data[loop] == 0) /* Move up */
	  update_board(from,loop + 9,loop);
	else if (from - loop == 20 && now->data[loop + 10] == 1 &&
	    now->data[loop] == 0) /* Move left/up */
	  update_board(from,loop + 10,loop);
	else if (from - loop == 16 && now->data[loop + 8] == 1 &&
	    now->data[loop] == 0) /* Move right/up */
	  update_board(from,loop + 8,loop);
	else if (loop - from == 16 && now->data[loop - 8] == 1 &&
	    now->data[loop] == 0) /* Move left/down */
	  update_board(from,loop - 8,loop);
	else if (loop - from == 20 && now->data[loop - 10] == 1 &&
	    now->data[loop] == 0) /* Move right/down */
	  update_board(from,loop - 10,loop);
      }
      check_board();
      return XV_OK;
    }
  }
  check_board();
  return XV_OK;
}

void update_board(int x,int y,int z)
{
  now->data[x] = 0;
  now->data[y] = 0;
  now->data[z] = 1;
  
  xv_set(now->item[x],PANEL_LABEL_IMAGE,tom,PANEL_ITEM_COLOR,CMS_CONTROL_COLORS + BLUE,NULL);
  xv_set(now->item[y],PANEL_LABEL_IMAGE,tom,NULL);
  xv_set(now->item[z],PANEL_LABEL_IMAGE,bild,PANEL_ITEM_COLOR,CMS_CONTROL_COLORS + BLUE,NULL);
  from = 0;
  count--;
}

void draw_board(struct board *wrk)
{
  int loop;
  int x = 16, y = 48;
 
  for (loop = 0 ; loop < 81 ; loop++) {
    if (wrk->data[loop] == 1) {
      wrk->item[loop] = xv_create(panel,PANEL_BUTTON,PANEL_LABEL_IMAGE,bild,
				  XV_X,x,XV_Y,y,PANEL_NOTIFY_PROC,move_ball,
				  PANEL_ITEM_COLOR,CMS_CONTROL_COLORS + BLUE,
				    NULL);

      max++;
    }
    else if (wrk->data[loop] == 0) {
      wrk->item[loop] = xv_create(panel,PANEL_BUTTON,PANEL_LABEL_IMAGE,tom,
				    XV_X,x,XV_Y,y,PANEL_NOTIFY_PROC,move_ball,
				    NULL);

    }

    backup[loop] = wrk->data[loop];

    x += 64;
    if (x == 592) {
      x = 16;
      y += 56;
    }
  }

  from = 0;
}

void destroy_board(struct board *wrk)
{
  int loop;

  for (loop = 0 ; loop < 81 ; loop++) {
    if (wrk->item[loop]) xv_destroy(wrk->item[loop]);
    wrk->data[loop] = backup[loop];
  }

  from = 0;
}

void check_board(void)
{
  int loop, loop2,loop3;
  int big[169];

  loop2 = 0;
  for (loop = 0 ; loop < 81 ; loop++)
    if (now->data[loop] == 1) loop2++;

  if (loop2 == 1) {
    for (loop = 0 ; loop < 81 ; loop++) 
      if (now->item[loop]) 
	xv_set(now->item[loop],PANEL_INACTIVE,TRUE,NULL);

    xv_set(madeit,XV_SHOW,TRUE,NULL);

    return;
  }

  for (loop = 0 ; loop < 169 ; loop++) big[loop] = 2;

  loop2 = 13 ; loop3 = 0;
  for (loop = 0 ; loop < 81 ; loop++) {
    big[loop2++] = now->data[loop];
    loop3++;
    if (loop3 == 9) {
      loop2 += 4;
      loop3 = 0;
    }
  }

  for (loop = 13 ; loop < 156 ; ) {
    for (loop2 = loop + 1; loop2 < loop + 10 ; loop2++) {
      if (big[loop2] == 1) {
	if (big[loop2-14] == 1 && big[loop2-28] == 0) return;   /* Up/Left   */
	else if (big[loop2-13]==1 && big[loop2-26]==0) return;  /* Up        */
	else if (big[loop2-12]==1 && big[loop2-24]==0) return;  /* Up/Right  */
	else if (big[loop2-1] ==1 && big[loop2-2] ==0) return;  /* Left      */
	else if (big[loop2+1] ==1 && big[loop2+2] ==0) return;  /* Right     */
	else if (big[loop2+12]==1 && big[loop2+24]==0) return;  /* Down/Left */
	else if (big[loop2+13]==1 && big[loop2+26]==0) return;  /* Down      */
	else if (big[loop2+14]==1 && big[loop2+28]==0) return;  /* Down/Right*/
      }
    }
    loop += 13;
  }

  for (loop = 0 ; loop < 81 ; loop++) 
    if (now->item[loop]) 
      xv_set(now->item[loop],PANEL_INACTIVE,TRUE,NULL);

  xv_set(notice,XV_SHOW,TRUE);

  return;
}
