/* xvSolitaire, version 1.0
 * Copyright (C) 1993  Andreas Almroth
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <stdio.h>
#include "sol_structs.h"

struct board *parse_resource(void);
void free_boards(struct board *);

struct board *parse_resource(void)
{
  FILE *file = NULL;
  struct board *board = NULL,*work,*next;
  char buffer[80];
  char *rcname;
  work = board;

  if ((rcname = getenv("SOLRC"))) {
    if ( ! (file = fopen(rcname,"r"))) {
      fprintf(stderr,"***001: Can't open resource file.\n");
      exit(1);
    }
  }
  else if ((rcname = getenv("HOME"))) {
    char bufwork[256];

    sprintf(bufwork,"%s/.solrc",rcname);

    if ( ! (file = fopen(bufwork,"r"))) {
      if ( ! (file = fopen(".solrc","r"))) {
	fprintf(stderr,"***001: Can't open resource file.\n");
	exit(1);
      }
    }
  }

  while (fgets(buffer,79,file)) {
    if ( ! (strncmp(buffer,"BOARD:",6))) {
      register int loop,loop2;
      char tkn;
      
      if ( ! (next = (struct board *)calloc(1,sizeof(struct board)))) {
	fprintf(stderr,"***002: Can't allocate sufficient memory.\n");
	fclose(file);
	exit(1);
      }

      if (board == NULL) 
	board = work = next;
      else {
	work->next = next;
	work = next;
      }

      strncpy(work->name,&buffer[6],32);

      for (loop = 0 ; loop < 9 ; loop++) {
	if (! fgets(buffer,79,file)) {
	  fprintf(stderr,"***003: Error in resource file.\n");
	  free_boards(board);
	  fclose(file);
	}

	if (strlen(buffer) < 9) {
	  fprintf(stderr,"***003: Error in resource file.\n");
	  free_boards(board);
	  fclose(file);
	}

	for (loop2 = 0 ; loop2 < 9 ; loop2++) {
	  tkn = buffer[loop2];
	  work->data[loop * 9 + loop2] = tkn - 48;
	}
      }
    }
  }
  fclose(file);
  return board;
}

void free_boards(struct board *wrk)
{
  struct board *next;

  while (wrk) {
    next = wrk->next;
    free(wrk);
    wrk = next;
  }
}

