#include <syscall.h>
#include <unistd.h>
#include <errno.h>

loff_t
__llseek (int fd, loff_t offset, int whence)
{
  int ret;
  loff_t result;

  ret = syscall (SYS__llseek, fd, (off_t) (offset >> 32),
	(off_t) (offset & 0xffffffff), &result, whence);

  return ret ? (loff_t) ret : result;
}

#include <gnu-stabs.h>
#ifdef weak_alias
weak_alias (__llseek, llseek);
#endif
